////////////////////////////////////////////////////////////////
// MFX 1993 Written by Paul DiLascia.

#include "mfx.h"

//////////////////
// Encapsulation of MCI VBX control.
//

BEGIN_MESSAGE_MAP(CMCIControl, CVBControl)
   //{{AFX_MSG_MAP(CMCIControl)
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()

///////////////////
// Register VBX events. 
// Once registered, you can use them in message maps. For example the line
//
// ON_VBXEVENT(VBN_STATUSUPDATE, IDC_MCICTL, OnMCIStatusUpdate)
//
// Tells MFC to call your member function OnMCIStatusUpdate whenever the
// MCI control whose ID is IDC_MCICTL sends the StatusUpdate event.
// 
//
//{{AFX_VBX_REGISTER_MAP()
   UINT NEAR VBN_STATUSUPDATE = AfxRegisterVBEvent("StatusUpdate");
   UINT NEAR VBN_DONE         = AfxRegisterVBEvent("DONE");
   UINT NEAR VBN_DRAGSROP     = AfxRegisterVBEvent("DragDrop");

   // Button events. Note: the GotFocus and LostFocus events
   // are not supported. If needed, they should be added here.

   UINT NEAR VBN_BACKCLICK    = AfxRegisterVBEvent("BackClick");
   UINT NEAR VBN_EJECTCLICK   = AfxRegisterVBEvent("EjectClick");
   UINT NEAR VBN_NEXTCLICK    = AfxRegisterVBEvent("NextClick");
   UINT NEAR VBN_PAUSECLICK   = AfxRegisterVBEvent("PauseClick");
   UINT NEAR VBN_PLAYCLICK    = AfxRegisterVBEvent("PlayClick");
   UINT NEAR VBN_PREVCLICK    = AfxRegisterVBEvent("PrevClick");
   UINT NEAR VBN_RECORDCLICK  = AfxRegisterVBEvent("RecordClick");
   UINT NEAR VBN_STEPCLICK    = AfxRegisterVBEvent("StepClick");
   UINT NEAR VBN_STOPCLICK    = AfxRegisterVBEvent("StopClick");

   UINT NEAR VBN_BACKCOMPLETED   = AfxRegisterVBEvent("BackCompleted");
   UINT NEAR VBN_EJECTCOMPLETED  = AfxRegisterVBEvent("EjectCompleted");
   UINT NEAR VBN_NEXTCOMPLETED   = AfxRegisterVBEvent("NextCompleted");
   UINT NEAR VBN_PAUSECOMPLETED  = AfxRegisterVBEvent("PauseCompleted");
   UINT NEAR VBN_PLAYCOMPLETED   = AfxRegisterVBEvent("PlayCompleted");
   UINT NEAR VBN_PREVCOMPLETED   = AfxRegisterVBEvent("PrevCompleted");
   UINT NEAR VBN_RECORDCOMPLETED = AfxRegisterVBEvent("RecordCompleted");
   UINT NEAR VBN_STEPCOMPLETED   = AfxRegisterVBEvent("StepCompleted");
   UINT NEAR VBN_STOPCOMPLETED   = AfxRegisterVBEvent("StopCompleted");

//}}AFX_VBX_REGISTER_MAP

//////////////////
// Constructor has nothing to do.
//
CMCIControl::CMCIControl()
{
   
}

//////////////////
// Create MCI control. Calls base VBControl class to do the work.
//
BOOL CMCIControl::Create(DWORD style, const RECT& pos, 
   CWnd* parent, UINT id, CFile* file, BOOL autoD)
{
   return CVBControl::Create("MCI.VBX;MMControl;", 
      style, pos, parent, id, file, autoD);
}

//////////////////
// Play MCI from from to to.
//
void CMCIControl::Play(long from, long to)
{
   SetProp("From", from);
   SetProp("To", to);
   Command("Play");
}

//////////////////
// Set button property. 
// "butn" is name of button (e.g., "Play");
// "prop" is name of property ("Visible" or "Enabled"); 
// "val"  is new value of property.
//
void CMCIControl::SetButtonProp(CSTR butn, CSTR prop, BOOL val)
{
   char temp[40];
   strcpy(temp, butn);
   strcat(temp, prop);
   SetProp(temp, val);
}
