////////////////////////////////////////////////////////////////
// MFX Microsoft Foundation Class Library Extensions
// 1993 Written by Paul DiLascia
//
// NOTE: for proper indention, set tab size = 3. 

#ifndef _MFX_H
#define _MFX_H

#include <afxwin.h>			// MFC core and standard components
#include <afxext.h>			// MFC extensions (including VB)
#include <stdlib.h>
#include <string.h>

/////////////////
// Useful typedefs
typedef const char* CSTR;

// Shorthand for checking runtime class
#define ISA(classname)	IsKindOf(RUNTIME_CLASS(classname))

//////////////////
// MFX application object.
// Apps should derive their main application object from this.
//
class CMfxApp : public CWinApp {
	DECLARE_DYNAMIC(CMfxApp)
public:
	CMfxApp();

	HCURSOR LoadCursor(LPCSTR name)
		{ return ::LoadCursor(HIWORD(name) ? m_hInstance : NULL, name); }
	HCURSOR LoadCursor(int id)
		{ return CWinApp::LoadCursor(id); }
};

#ifndef _DEBUG
inline CMfxApp* MfxGetApp() { return (CMfxApp*)AfxGetApp(); }
#else
extern CMfxApp* MfxGetApp();
#endif

//////////////////
// Like a normal CRect, but has constructors to get window dimensions.
// Gets either client area, client area in screen coords or window
// in screen coords.
//
class CWinRect : public CRect {
public:
   enum WHICHRECT { CLIENT, CLIENTSCREEN, WINDOW, WINDOWCLIENT, MDICLIENT };
private:
   void Construct(CWnd *pWnd, WHICHRECT which);
public:
   // Constructors and assignment
   CWinRect(CWnd *pWnd, WHICHRECT which=CLIENT) { Construct(pWnd, which); }
   CWinRect(CWnd  &wnd, WHICHRECT which=CLIENT) { Construct(&wnd, which); }
   CWinRect(const CRect& rc)  { *this = rc; }
   CWinRect& operator= (const CRect& rc) 
      { *((CRect*)this) = rc; return *this; }

   void CapturePt(CPoint &pt);
   void Normalize();
};

//////////////////
// Extended string class
//
class CMfxString : public CString {
public:
   // Constructors
   CMfxString()                           { }
   CMfxString(CSTR str) : CString(str)    { }
   CMfxString(CString s): CString(s)      { }

   // Assignment
   const CMfxString& operator=(CSTR str)  
      { CString::operator=(str); return *this; }
   const CMfxString& operator=(CString s) 
      { CString::operator=(s); return *this; }

   // Useful stuff
   int printf(CSTR fmt, ...);
   int MessageBox(int type=MB_OK, CSTR caption=NULL)
      { return ::MessageBox(NULL,(CSTR)(*this),caption,type); }
};

//////////////////
// Class to handle generic mouse-dragging action
//
class CDragger {
public:
   int      m_dragOp;            // user-defnied drag operation, zero=none
   CRect    m_rcOrg;             // original rectangle
   CRect    m_rcPrev;            // previous rectangle
   CRect    m_rcCur;             // current rectangle
   CPoint   m_ptOrg;             // original point
   CPoint   m_ptPrev;            // previous point
   CPoint   m_ptCur;             // current point
   CRect    m_rcClip;            // cursor clipping rectangle if any
   CWnd*    m_pCapWnd;           // window with capture, if any

   CDragger();
   void Begin(CPoint pt, int dragop=1, CRect* pRect=NULL, CWnd* pWnd=NULL);
   void End();
   void BeginMove(CPoint pt);
   void EndMove();
   void Clip(CRect& rcScreen);
   void Clip(CWnd *pWnd, CWinRect::WHICHRECT which=CWinRect::CLIENTSCREEN);
};

////////////////////////////////////////////////////////////////
// Global objects for mouse, keyboard, cursor, etc.
////////////////////////////////////////////////////////////////

//////////////////
// Global mouse object.  There's only one: TheMouse.
// Use this object to get/set mouse parameters, capture the mouse, etc.
// 
class GMouse {
public:
   CWnd* Capture()         { return CWnd::GetCapture(); }
   CWnd* Capture(CWnd *w)  { return w->SetCapture(); }
   void Release()          { ReleaseCapture(); }
};
extern GMouse TheMouse;

/////////////////
// Global Cursor.
// 
class GCursor {
public:
   HCURSOR operator= (HCURSOR hc)   { return SetCursor(hc); }
   HCURSOR operator= (LPCSTR name)  
      { return *this = MfxGetApp()->LoadCursor(name); }
   HCURSOR operator= (int id)       
      { return *this = MfxGetApp()->LoadCursor(id); }

   void     GetPos(int x, int y)    { SetCursorPos(x, y); }
   CPoint   GetPos()                { CPoint p; GetCursorPos(&p); return p; }
   operator CPoint()                { return GetPos(); }
   CPoint   operator=(CPoint p)     { SetCursorPos(p.x, p.y); return p; }

   void Clip(CWnd *pWnd);
   void Clip(CRect &rect)           { ClipCursor(&rect); }
   void UnClip()                    { ClipCursor(NULL); }
};
extern GCursor TheCursor;

//////////////////
// Global Keyboard object, used to get info about the keyboard.
// 
class GKeyboard {
public:
   int CodePage()                { return GetKBCodePage(); }
   int Type()                    { return GetKeyboardType(0); }
   int SubType()                 { return GetKeyboardType(1); }
   int NumFnKeys()               { return GetKeyboardType(2); }
   int KeyName(LONG lparam, char *buf, int buflen)
      { return GetKeyNameText(lparam, buf, buflen); }
   int State(int vkey)           { return GetKeyState(vkey); }
   void GetState(BYTE* buf)      { GetKeyboardState(buf); }
   void SetState(BYTE* buf)      { SetKeyboardState(buf); }
   BOOL IsArrowKey(int key)      { return VK_LEFT<=key && key<=VK_DOWN; }
};
extern GKeyboard TheKeyboard;

//////////////////
// Class to display a wait cursor (hourglass).
//
class CHourglass {
   CWnd*          m_pCapWnd;     // window to capture mouse, if any
   HCURSOR        m_hSaveCursor; // save cursor handle
public:
   CHourglass(CWnd *pWnd=NULL);
   ~CHourglass();
};

//////////////////
// CMCIControl encapsulates VBX MCI control, which plays AVI video files.
// This control is a button bar, with buttons for stop, play, fwd, etc.
//
class CMCIControl : public CVBControl {
   void SetButtonProp(CSTR butn, CSTR prop, BOOL val);
public:
   CMCIControl();

   BOOL SetProp(LPCSTR name, long val) 
      { return SetNumProperty(name, val); }
   BOOL SetProp(LPCSTR name, LPCSTR val) 
      { return SetStrProperty(name, val); }

   void Command(LPCSTR cmd)      { SetProp("Command", cmd); }
   void Seek(long pos)           { SetProp("To", pos); Command("Seek"); }
   long Length()                 { return GetNumProperty("Length"); }
   long Position()               { return GetNumProperty("Position"); }
   long Error()                  { return GetNumProperty("Error"); }
   CString ErrorMsg()            { return GetStrProperty("ErrorMessage"); }
   void Close()                  { Command("Close"); }
   void Open(LPCSTR filename)    
      { SetProp("FileName", filename); Command("Open"); }
   void Play(long frame)         { Play(frame, frame); }
   void Play(long from, long to);

   void SetDisplayWnd(CWnd* pWnd)
      { SetProp("hWndDisplay", (int)pWnd->m_hWnd); }

   void SetButtonEnabled(CSTR butn, BOOL enab)
      { SetButtonProp(butn, "Enabled", enab); }
   void SetButtonVisible(CSTR butn, BOOL show)
      { SetButtonProp(butn, "Visible", show); }

   BOOL Create(DWORD style, const RECT& pos, CWnd* parent, UINT id,
      CFile* f=NULL, BOOL autoDel=FALSE);

protected:
   //{{AFX_MSG(CMCIControl)
   //}}AFX_MSG
   DECLARE_MESSAGE_MAP()
};

//////////////////
// Registered MCI control events
//
//{{AFX_VBX_REGISTER()
   extern UINT NEAR VBN_STATUSUPDATE;
   extern UINT NEAR VBN_DONE;
   extern UINT NEAR VBN_DRAGSROP;
   extern UINT NEAR VBN_BACKCLICK;
   extern UINT NEAR VBN_EJECTCLICK;
   extern UINT NEAR VBN_NEXTCLICK;
   extern UINT NEAR VBN_PAUSECLICK;
   extern UINT NEAR VBN_PLAYCLICK;
   extern UINT NEAR VBN_PREVCLICK;
   extern UINT NEAR VBN_RECORDCLICK;
   extern UINT NEAR VBN_STEPCLICK;
   extern UINT NEAR VBN_STOPCLICK;
   extern UINT NEAR VBN_BACKCOMPLETED;
   extern UINT NEAR VBN_EJECTCOMPLETED;
   extern UINT NEAR VBN_NEXTCOMPLETED;
   extern UINT NEAR VBN_PAUSECOMPLETED;
   extern UINT NEAR VBN_PLAYCOMPLETED;
   extern UINT NEAR VBN_PREVCOMPLETED;
   extern UINT NEAR VBN_RECORDCOMPLETED;
   extern UINT NEAR VBN_STEPCOMPLETED;
   extern UINT NEAR VBN_STOPCOMPLETED;
//}}AFX_VBX_REGISTER

#endif // _MFX_H
