////////////////////////////////////////////////////////////////
// MFX 1993 Written by Paul DiLascia.

#include "mfx.h"

//////////////////
// Common constructor worker fn for CWinRect. Stuffs rect w/appropriate
// window dimensions in appropriate coords:
//   which = CLIENT        Get client area in client coords top left = (0,0)
//   which = CLIENTSCREEN  Get client area in screen coords
//   which = WINDOW        Get window area in screen coords
//   which = WINDOWCLIENT  (strange) Get window area in client coords
//   which = MDICLIENT     Get MDI client win client area in window coords;
//                         pWnd must be MDI Frame window
//
void CWinRect::Construct(CWnd *pWnd, WHICHRECT which)
{
   ASSERT(pWnd);
   switch (which) {
   case CLIENT:
   case CLIENTSCREEN:
      pWnd->GetClientRect(this); 
      if (which==CLIENTSCREEN)
         pWnd->ClientToScreen(this);
      break;
   case WINDOW:
   case WINDOWCLIENT:
      pWnd->GetWindowRect(this); 
      if (which==WINDOWCLIENT)
         pWnd->ScreenToClient(this);
      break;
   case MDICLIENT:
      char buf[80];
      HWND hwnd = GetWindow(pWnd->m_hWnd, GW_CHILD);
      ASSERT(hwnd);
      GetClassName(hwnd, buf, sizeof(buf));
      ASSERT(strcmp(buf,"MDIClient")==0);
      GetWindowRect(hwnd, (LPRECT)this);
      break;
   }
}

//////////////////
// Capture a point.
// That is, alter the point so that it lies within the rectangle.
//
void CWinRect::CapturePt(CPoint &pt)
{  
   CWinRect rc = *this;
   rc.Normalize();
   pt.x = min(max(pt.x, rc.left), rc.right-1); 
   pt.y = min(max(pt.y, rc.top),  rc.bottom-1); 
}

//////////////////
// Make sure that left <= right and top <= bottom.
// 
void CWinRect::Normalize()
{
   if (left > right) {
      int r = right;
      right = left;
      left = r;
   }
   if (top > bottom) {
      int b = bottom;
      bottom = top;
      top = b;
   }
}

