/**********************************************************************/
/*                                                                    */
/*    COMPUT32.C -- Example 32-bit DLL                                */
/*                                                                    */
/*    Copyright (C) 1993 by Walter Oney                               */
/*    All rights reserved                                             */
/*                                                                    */
/**********************************************************************/

#include <windows.h>

#define W32SUT_32
#include "w32sut.h"

static DWORD WINAPI CallBack(LPVOID, DWORD);

/**********************************************************************/

BOOL WINAPI LibMain(HANDLE hInst, DWORD dwReason, LPVOID junk)
   {                             // LibMain
   UT32PROC stepdown;

   switch (dwReason)
      {                          // select on reason code

   case DLL_PROCESS_ATTACH:
      return UTRegister(hInst, "COMPUTE.DLL", MAKEINTRESOURCE(2),
         NULL, &stepdown, CallBack, NULL);

   case DLL_PROCESS_DETACH:
      UTUnRegister(hInst);       // would happen automatically anyway
      break;
      }                          // select on reason code

   return TRUE;                  // (only matters for process attach)
   }                             // LibMain

/**********************************************************************/

/* Callback routine for calls from COMPUTE.DLL: */

DWORD WINAPI CallBack(LPDWORD data, DWORD code)
   {                             // CallBack
   switch (code)
      {                          // select on function code
   case 0:
      return data[0] + data[1];
   case 1:
      return data[0] - data[1];
   case 2:
      return data[0] * data[1];
   case 3:
      if (data[1])
         return data[0] / data[1];
      else
         return data[0];
      }                          // select on function code
   return 0;
   }                             // CallBack
