/**********************************************************************/
/*                                                                    */
/*    COMPUTE.C -- 16-bit interface to 32-bit DLL                     */
/*                                                                    */
/*    Copyright (C) 1993 by Walter Oney                               */
/*    All rights reserved                                             */
/*                                                                    */
/*    This DLL illustrates how a 16-bit program can use the services  */
/*    of a 32-bit DLL built for NT.                                   */
/*                                                                    */
/**********************************************************************/

#include <windows.h>

#define W32SUT_16
#include "w32sut.h"

#include "dlldemon.h"

static HINSTANCE hLib;           // COMPUT32.DLL instance handle
static HINSTANCE hInst;          // our own instance handle
static HINSTANCE hDemon;         // DLLDEMON.DLL instance handle
static UT16CBPROC pfnCallBack;   // callback routine into DLLDEMON

/**********************************************************************/

/* Boilerplate initialization & termination routines for a 16-bit
   DLL: */

BOOL FAR PASCAL LibMain(HINSTANCE hInstance, WORD wDataSeg,
   WORD cbHeap, DWORD ignore)
   {                             // LibMain
   if (cbHeap)
      UnlockData(0);
   hInst = hInstance;

/* The following call to LoadLibrary artificially increases the use
   count on DLLDEMON.DLL by 1. The reason for this is explained
   immediately below. */

   hDemon = LoadLibrary("DLLDEMON.DLL");
   return TRUE;
   }                             // LibMain

void FAR PASCAL WEP(BOOL bSysExit)
   {                             // WEP

/* If we ever loaded our matching 32-bit DLL, unload it now. */

   if (hLib >= HINSTANCE_ERROR)
      Unload32BitDLL(hLib);

/* It's now safe to let DLLDEMON.DLL get unloaded. We artificially
   increased its use count by 1 during our initialization routine to
   be sure it didn't get unloaded before our WEP got called. (Windows
   doesn't nest calls to WEP's in the same order as the DLL's are
   loaded, unfortunately.) Therefore, we need to decrement the use
   count now. */

   FreeModule(hDemon);
   }                             // WEP

/**********************************************************************/

/* Universal thunk initialization routine */

DWORD FAR PASCAL UT16Init(UT16CBPROC pfnCB, LPVOID data)
   {                             // UT16Init
   pfnCallBack = pfnCB;          // save callback routine address
   FreeModule(hInst);            // make our own use count 1 again
   return TRUE;                  // allows UTRegister to succeed
   }                             // UT16Init

/**********************************************************************/

/* NULLPROC is a dummy callback procedure that will be used if we're
   unable for some reason to load the 32-bit matching DLL. */

static DWORD FAR PASCAL nullproc(LPVOID a1, DWORD a2, LPVOID FAR *a3)
   {return 0;}

/**********************************************************************/

/* LOADDLL loads the 32-bit DLL the first time it's required. It won't
   work to do the Load32BitDLL call from our LibMain because SendMessage
   is inoperative at that time. */

static void loaddll(void)
   {                             // loaddll
   if (pfnCallBack)
      return;
   if ((hLib = Load32BitDLL("COMPUT32.DLL")) < HINSTANCE_ERROR)
      pfnCallBack = nullproc;
   }                             // loaddll

/**********************************************************************/

/* CALLBACK executes the 32-bit DLL's callback routine and corrects
   the return value (which Win32s unaccounably fails to do!) */

static DWORD callback(LPVOID a1, DWORD a2, LPVOID FAR *a3)
   {                             // callback
   (*pfnCallBack)(a1, a2, a3);
   #pragma warning(disable:4035)
   _asm
      {                          // correct return value
      _emit 66h
      mov   dx, ax
      _emit 66h
      shr   dx, 16
      }                          // correct return value
   }                             // callback

/**********************************************************************/

/* These are the exported entries that interface to the 32-bit DLL.
   As explained before the definition of LOADDLL, we have to wait until
   one of these entries is called before it's safe to load the 32-bit
   DLL. We also have to use a corrective wrapper (CALLBACK) to get
   the Universal Thunk's return value into DX:AX instead of EAX.
   Apart from the details, in other words, this is pretty
   straightforward! */

DWORD FAR _cdecl Add32(DWORD left, DWORD right)
   {loaddll();return callback(&left, 0, NULL);}

DWORD FAR _cdecl Sub32(DWORD left, DWORD right)
   {loaddll();return callback(&left, 1, NULL);}

DWORD FAR _cdecl Mul32(DWORD left, DWORD right)
   {loaddll();return callback(&left, 2, NULL);}

DWORD FAR _cdecl Div32(DWORD left, DWORD right)
   {loaddll();return callback(&left, 3, NULL);}
