/**********************************************************************/
/*                                                                    */
/*    DLLDEM32.C -- Server process for loading 32-bit DLL's           */
/*                                                                    */
/*    Copyright (C) 1993 by Walter Oney                               */
/*    All rights reserved                                             */
/*                                                                    */
/**********************************************************************/

#include <windows.h>
#include <string.h>

#define W32SUT_32
#include "w32sut.h"

#define VERMAJOR 1
#define VERMINOR 0

typedef struct tagPDB
   {
   short junk[5];
   short modindex;
   } PDB, *LPPDB;

static DWORD WINAPI CallBack(LPVOID, DWORD);
static LPPDB (WINAPI *PpdbGetProcess)(void);
static short modindex;
static HWND hwndServer;

LRESULT WINAPI DummyWndProc(HWND, UINT, WPARAM, LPARAM);

/**********************************************************************/

/* Main program: */

int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrev, LPSTR lpCmd,
   int nShow)
   {                             // WinMain
   HINSTANCE hMod = LoadLibrary("W32SKRNL.DLL");
   WORD version[2] = {VERMINOR, VERMAJOR};
   UT32PROC stepdown;
   MSG msg;
   WNDCLASS wc;
   HWND hwnd;

/* Find the internal PpdbGetProcess function in Win32s for use during
   callbacks. */

   PpdbGetProcess = (LPPDB (WINAPI *)(void))
      GetProcAddress(hMod, "_PpdbGetProcess@0");
   modindex = PpdbGetProcess()->modindex;

/* Register a universal thunk to provide for the callback routine. */

   if (!UTRegister(hInst, "DLLDEMON.DLL", MAKEINTRESOURCE(2),
      NULL, &stepdown, CallBack, &version))
      return 0;                  // can't create thunk

/* Create a dummy window. The purpose of this is to receive a
   WM_CLOSE message when DLLDEMON.DLL terminates. */

   memset(&wc, 0, sizeof(wc));
   wc.lpszClassName = "DLLDEMON";
   wc.hInstance = hInst;
   wc.lpfnWndProc = DummyWndProc;
   RegisterClass(&wc);
   hwnd = CreateWindow("DLLDEMON", NULL, 0, 0, 0, 0, 0, NULL, NULL,
      hInst, NULL);

/* Enter a dummy message loop that ends when the last instance of
   DLLDEMON unloads. */

   while (GetMessage(&msg, NULL, 0, 0))
      {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
      }

   UTUnRegister(hInst);
   return 0;
   }                             // WinMain

/**********************************************************************/

/* Dummy window proc: */

LRESULT WINAPI DummyWndProc(HWND hwnd, UINT msg, WPARAM wParam,
   LPARAM lParam)
   {                             // DummyWndProc
   switch (msg)
      {                          // select on message code
   case WM_CREATE:
      hwndServer = hwnd;
      return 0;
   case WM_CLOSE:
      PostQuitMessage(0);
      return 0;
   case WM_USER+0x100:
   case WM_USER+0x101:
      {                          // library load or unload
      DWORD value;
      int oldindex;
      LPPDB pdb;

      pdb = PpdbGetProcess();
      oldindex = pdb->modindex;
      pdb->modindex = modindex;

      if (msg == WM_USER+0x100)
         value = (DWORD) LoadLibrary((LPSTR) lParam);
      else
         FreeLibrary((HINSTANCE) lParam);

      pdb->modindex = oldindex;
      return value;
      }                          // library load or unload
   default:
      return DefWindowProc(hwnd, msg, wParam, lParam);
      }                          // select on message code
   }                             // DummyWndProc

/**********************************************************************/

/* Callback routine for calls from DLLDEM16.DLL: */

DWORD WINAPI CallBack(LPVOID junk1, DWORD junk2)
   {                             // CallBack
   return (DWORD) hwndServer;
   }                             // CallBack
