/**********************************************************************/
/*                                                                    */
/*    DLLDEMON.C -- 16-bit listener DLL for DLLDEMON server.          */
/*                                                                    */
/*    Copyright (C) 1993 by Walter Oney                               */
/*    All rights reserved                                             */
/*                                                                    */
/**********************************************************************/

#include <windows.h>
#include <assert.h>

#define W32SUT_16                // indicate 16-bit side of interface
#include "w32sut.h"              // from \mstools\win32s\ut on CD

#include "dlldemon.h"

#define VERMAJOR 1
#define VERMINOR 0

static HINSTANCE hInst;          // DLL's instance handle
static HWND hwndServer;          // server's window handle
static UT16CBPROC lpfnCallback;  // DLLDEM32 callback routine

/**********************************************************************/

/* Initialization & termination routines: */

BOOL FAR PASCAL LibMain(HINSTANCE hInstance, WORD wDataSeg,
   WORD cbHeap, DWORD ignore)
   {                             // LibMain
   WORD hServer;

   if (cbHeap)
      UnlockData(0);
   hInst = hInstance;

/* Use WinExec to launch the 32-bit demon server. Use the server's
   callback to get the handle of its dummy window, which we use
   in order to load and unload DLL's for people. */

   hServer = WinExec("DLLDEM32.EXE", SW_HIDE);
   if (hServer < 32)
      return FALSE;              // can't launch server
   hwndServer = (HWND) (*lpfnCallback)(NULL, 0, NULL);

   return TRUE;                  // i.e., OK to load this DLL
   }                             // LibMain

void FAR PASCAL WEP(BOOL bSysExit)
   {                             // WEP
   if (hwndServer)
      PostMessage(hwndServer, WM_CLOSE, 0, 0); // shut down server
   }                             // WEP

/**********************************************************************/

/* Universal thunk initialization routine */

DWORD FAR PASCAL UT16Init(UT16CBPROC pfnCB, LPVOID data)
   {                             // UT16Init
   LPWORD version = (LPWORD) data;
   char errmsg[128];

   if (version[1] > VERMAJOR)
      {                          // 32-bit DLL from our future
      wsprintf(errmsg, "Version mismatch in Universal Thunk interfaces"
         " to DLLDEMON.DLL. 32-bit version is %d.%02d, but 16-bit"
         " version is %d.%02d", version[1], version[0],
         VERMAJOR, VERMINOR);
      MessageBox(NULL, errmsg, "ERROR", MB_ICONHAND | MB_OK);
      return FALSE;              // fails call to UTRegister
      }                          // 32-bit DLL from our future

/* The use count on this module has been artificially increased by 1
   due to the call to UTRegister. Call FreeModule to reduce it so
   we unload when our last actual user unloads. */

   lpfnCallback = pfnCB;
   FreeModule(hInst);

   return TRUE;                  // allows UTRegister to succeed
   }                             // UT16Init

/**********************************************************************/

/* Load32BitDLL loads a 32-bit DLL at the behest of a 16-bit caller. */

HINSTANCE FAR PASCAL Load32BitDll(LPSTR lpszName)
   {                             // Load32BitDll
   HINSTANCE hLib;
   HGLOBAL hMem = (HGLOBAL) GlobalHandle(SELECTOROF(lpszName));

/* The string may be in moveable 16-bit memory. Use GlobalFix to
   prevent it from moving in linear memory while we run the 32-bit
   server. */

   GlobalFix(hMem);

/* Use SendMessage to the server's window to get the DLL loaded by a
   definite Win32s task. Note that messages in the range 0400-04FF
   are not passed on by Win32s to the 32-bit window proc! */

   hLib = (HINSTANCE) SendMessage(hwndServer, WM_USER+0x100, 0,
      (LPARAM) UTSelectorOffsetToLinear(lpszName));
   GlobalUnfix(hMem);
   return hLib;
   }                             // Load32BitDll

/**********************************************************************/

/* Unload32bitDLL unloads a 32-bit DLL. We use SendMessage so that the
   32-bit call to FreeLibrary comes from the same Win32s task as was
   used to load it in the first place. (Otherwise, Win32s notices the
   mismatch and crashes.) */

VOID FAR PASCAL Unload32BitDll(HINSTANCE hLib)
   {                             // Unload32BitDLL
   SendMessage(hwndServer, WM_USER+0x101, 0, (LPARAM) (WORD) hLib);
   }                             // Unload32BitDLL
