#######################################################################
#                                                                     #
#    Project make file for Universal Thunk examples                   #
#                                                                     #
#    Copyright (C) 1993 by Walter Oney                                #
#    All rights reserved                                              #
#                                                                     #
#    Intended for use with PolyMake v 3.2, C8, MASM 6.1               #
#                                                                     #
#######################################################################

all: waltio.dll test.exe waltio16.dll waltio32.dll test32.exe \
     dlldemon.dll dlldem32.exe test32.sym dlldem32.sym \
     compute.dll comput32.dll comput32.sym waltio32.sym

.SUFFIXES

CCDLL = cl -c -ASw -Gsw2 -W3 -DSTRICT -Zi -Od
CCW   = cl -c -AS  -Gsw2 -W3 -DSTRICT -Zi -Od
CCNT = \mstools\bin\cl386 -I\mstools\h -c -G3d -W3 -Di386=1 -DWIN32 -D_X86_ -Od -Zi
LINK32 = \mstools\bin\link32
NTLIB  = \mstools\lib

.rc.res:
   :rc -r $*.rc $@

.def.lib:
   :implib $@ $*.def

.exe.sym:
   \windows\system\win32s\bin\mapsympe -o $@ $*.exe

.dll.sym:
   \windows\system\win32s\bin\mapsympe -o $@ $*.dll

######################## W A L T I O . D L L ##########################

WALTIO = waltio.obj heap.obj select.obj output.obj

libentry.obj: $*.asm
   :masm -Zi $?; >$*.err

waltio.obj: iwaltio.h waltio.h

heap.obj: iwaltio.h

select.obj: iwaltio.h

$(WALTIO): $*.c
   @echo $*.c >$*.err
   :$(CCDLL) $*.c >>$*.err

waltio.dll: $(WALTIO) libentry.obj $*.def $*.res
   :link <@<
/nod /noe /map /co $[s, "+\n", $[m, "*.obj", $**]]
$@
$*
libw sdllcew toolhelp commdlg $[m, "*.lib", $**]
$[m, "*.def", $**]
<
   :rc $[m, "*.res", $**] $@
   :mapsym $*

###################### W A L T I O 1 6 . D L L ########################

waltio16.obj: $*.c
   @echo $*.c >$*.err
   :$(CCDLL) $*.c >>$*.err

waltio16.dll: $*.obj libentry.obj $*.def waltio.lib
   :link <@<
/nod /noe /map /co $[s, "+\n", $[m, "*.obj", $**]]
$@
$*
libw sdllcew $[m, "*.lib", $**]
$[m, "*.def", $**]
<
   :rc $[m, "*.res", $**] $@
   :mapsym $*

###################### W A L T I O 3 2 . D L L ########################

waltio32.obj: $*.c
   @echo $*.c >$*.err
   $(CCNT) $*.c >>$*.err

waltio32.lib waltio32.exp: $*.def
   $(LINK32) -lib -out:$*.lib -machine:i386 -def:$*.def

waltio32.dll: $*.obj $*.exp
   $(LINK32) <@<
-entry:LibMain@12 -subsystem:windows -dll -debug:full -debugtype:coff
-out:$@
$[s, "\n", $[m, "*.obj", $**]]
$[s, "\n", $[m, "*.exp", $**]]
w32sut32.lib $(NTLIB)\kernel32.lib $(NTLIB)\user32.lib $(NTLIB)\libc.lib
<

######################## T E S T 3 2 . E X E ##########################

test32.obj: $*.c
   @echo $*.c >$*.err
   $(CCNT) $*.c >>$*.err

test32.exe: $*.obj waltio32.lib
   $(LINK32) <@<
-entry:WinMainCRTStartup -subsystem:windows -debug:full -debugtype:coff
-out:$@
$[s, "\n", $[m, "*.obj", $**]]
$[s, "\n", $[m, "*.lib", $**]]
$(NTLIB)\libc.lib $(NTLIB)\kernel32.lib $(NTLIB)\user32.lib
<

########################## T E S T . E X E ############################

test.obj: $*.c waltio.h
   @echo $*.c >$*.err
   :$(CCW) $*.c >>$*.err

test.exe: $*.obj $*.def waltio.lib compute.lib
   :link <@<
/nod /noe /map /co $[s, "+\n", $[m, "*.obj", $**]]
$@
$*
libw slibcew $[m, "*.lib", $**]
$[m, "*.def", $**]
<
   :rc $@
   :mapsym $*

###################### D L L D E M O N . D L L ########################

dlldemon.obj: $*.c dlldemon.h
   @echo $*.c >$*.err
   :$(CCDLL) $*.c >>$*.err

dlldemon.dll: $*.obj libentry.obj $*.def
   :link <@<
/nod /noe /map /co $[s, "+\n", $[m, "*.obj", $**]]
$@
$*
w32sut16 libw sdllcew $[m, "*.lib", $**]
$[m, "*.def", $**]
<
   :rc $[m, "*.res", $**] $@
   :mapsym $*

##################### D L L D E M 3 2 . E X E #########################

dlldem32.obj: $*.c
   @echo $*.c >$*.err
   $(CCNT) $*.c >>$*.err

dlldem32.exe: $*.obj
   $(LINK32) <@<
-entry:WinMainCRTStartup -subsystem:windows -debug:full -debugtype:coff
-out:$@
$[s, "\n", $[m, "*.obj", $**]]
$[s, "\n", $[m, "*.lib", $**]]
$(NTLIB)\libc.lib $(NTLIB)\kernel32.lib $(NTLIB)\user32.lib w32sut32.lib
<

####################### C O M P U T E . D L L #########################

compute.obj: $*.c
   @echo $*.c >$*.err
   :$(CCDLL) $*.c >>$*.err

compute.dll: $*.obj libentry.obj $*.def dlldemon.lib
   :link <@<
/nod /noe /map /co $[s, "+\n", $[m, "*.obj", $**]]
$@
$*
w32sut16 libw sdllcew $[m, "*.lib", $**]
$[m, "*.def", $**]
<
   :rc $[m, "*.res", $**] $@
   :mapsym $*

##################### C O M P U T 3 2 . D L L #########################

comput32.obj: $*.c
   @echo $*.c >$*.err
   $(CCNT) $*.c >>$*.err

comput32.dll: $*.obj
   $(LINK32) <@<
-entry:LibMain@12 -subsystem:windows -debug:full -debugtype:coff
-out:$@ -dll
$[s, "\n", $[m, "*.obj", $**]]
$[s, "\n", $[m, "*.lib", $**]]
$(NTLIB)\libc.lib $(NTLIB)\kernel32.lib $(NTLIB)\user32.lib w32sut32.lib
<

################################## P R I N T ##################################

print: $[f,"", $(WALTIO), c] makefile waltio.def waltio.rc waltio.h \
       waltio16.c waltio16.def waltio32.c waltio32.def \
       dlldemon.c dlldemon.def dlldem32.c \
       compute.c compute.def comput32.c \
       test.c test32.c
    @echo @echo off >printit.foo
    !@echo laser +8 $? >>printit.foo
    @sort <printit.foo >printit.bat
    @del printit.foo
    -@printit
    @echo Printed! >print
