/**********************************************************************/
/*								      */
/*    WALTIO.H -- Declarations for scrolling output package DLL       */
/*								      */
/*    Copyright (C) 1993 by Walter Oney 			      */
/*    All rights reserved					      */
/*								      */
/**********************************************************************/

#ifndef WALTIO_H
#define WALTIO_H

#ifdef WIN32
#undef	_far
#define _far
#undef __near
#define __near
#endif

extern int _far _cdecl printf(const LPSTR lpFormat, ...);
extern int _far _cdecl vprintf(const LPSTR lpFormat,
   LPVOID substargs);
extern int _far _cdecl puts(const LPSTR string);
extern int _far _cdecl putchar(const char);
extern void _far _cdecl waltio_yield(void);
extern long _far _cdecl FortyTwo(void);

#ifdef WALTIO_MAIN

extern int __argc;
extern char *__argv[];
extern char ** __near __cdecl _environ;     /* pointer to environment table */
static HINSTANCE hInst;
static int nCmdShow;

int WALTIO_MAIN();

int NEAR PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrev, LPSTR lpCmd, int nShow)
   {				 // WinMain
   MSG msg;
   hInst = hInstance;
   nCmdShow = nShow;
   WALTIO_MAIN(__argc, __argv, _environ);
   while (GetMessage(&msg, NULL, 0, 0))
      { 			 // empty message queue
      TranslateMessage(&msg);
      DispatchMessage(&msg);
      } 			 // empty message queue
   return msg.wParam;
   }				 // WinMain

#endif // WALTIO_MAIN

#endif // WALTIO_H
