/**********************************************************************/
/*                                                                    */
/*    WALTIO16.C -- 16-bit interface module for Universal Thunk       */
/*                  access to WALTIO.DLL                              */
/*                                                                    */
/*    Copyright (C) 1993 by Walter Oney                               */
/*    All rights reserved                                             */
/*                                                                    */
/**********************************************************************/

#include <windows.h>

/* Define W32SUT_16 to get the 16-bit declarations from w32sut.h: */

#define W32SUT_16                // indicate 16-bit side of interface
#include "w32sut.h"              // from \mstools\win32s\ut on CD

#include "waltio.h"

#define VERMAJOR 1
#define VERMINOR 0

static HINSTANCE hInst;          // DLL's instance handle

/**********************************************************************/

/* Boilerplate initialization & termination routines for a 16-bit
   DLL: */

BOOL FAR PASCAL LibMain(HINSTANCE hInstance, WORD wDataSeg,
   WORD cbHeap, DWORD ignore)
   {                             // LibMain
   if (cbHeap)
      UnlockData(0);
   hInst = hInstance;
   return TRUE;                  // i.e., OK to load this DLL
   }                             // LibMain

void FAR PASCAL WEP(BOOL bSysExit)
   {                             // WEP
   }                             // WEP

/**********************************************************************/

/* The universal thunk interface allows for a special initialization
   routine to be specified in the 32-bit call to UTRegister. In this
   example, we're using the feature to provide a version number
   check.

   This function must be exported with ordinal "2" because the 32-bit
   side of the example interface specifies it by ordinal. You could
   also reference it by name in the UTRegister call, and then it
   wouldn't matter what the export ordinal was.
*/

DWORD FAR PASCAL UT16Init(UT16CBPROC pfnCB, LPVOID data)
   {                             // UT16Init
   DWORD ver32 = *(LPDWORD) data;
   char errmsg[128];

   if (HIWORD(ver32) > VERMAJOR)
      {                          // 32-bit DLL from our future
      wsprintf(errmsg, "Version mismatch in Universal Thunk interfaces"
         " to WALTIO.DLL. 32-bit version is %d.%02d, but 16-bit"
         " version is %d.%02d", HIWORD(ver32), LOWORD(ver32),
         VERMAJOR, VERMINOR);
      MessageBox(NULL, errmsg, "ERROR", MB_ICONHAND | MB_OK);
      return FALSE;              // fails call to UTRegister
      }                          // 32-bit DLL from our future

   wsprintf(errmsg, "Universal Thunk connection established to"
      " WALTIO.DLL. 32-bit version is %d.%02d, 16-bit version is"
      " %d.%02d", HIWORD(ver32), LOWORD(ver32), VERMAJOR, VERMINOR);
   MessageBox(NULL, errmsg, "Greetings", MB_ICONINFORMATION | MB_OK);

   return TRUE;                  // allows UTRegister to succeed
   }                             // UT16Init

/**********************************************************************/

/* Calls to the entry points in the real WALTIO.DLL funnel through
   this interface procedure. In this example only, it must be exported
   with ordinal "3" to match the 32-bit call to UTRegister.

   The arguments are:

   data        Contains a 16:16 (far) pointer to the data area passed
               to the 32-bit interface function. In general, this
               data area contains translated values of arguments and
               structures.

   funcode     Contains an arbitrary 32-bit value. In this example,
               it specifies which function should be executed in the
               target DLL.

   The return value can be used for any purpose. Here, it turns into
   the eventual return value from the original 32-bit call.
*/

DWORD FAR PASCAL UT16Proc(LPVOID data, DWORD funcode)
   {                             // UT16Proc
   switch (funcode)
      {                          // select function to perform

/*--------------------------------------------------------------------*/

   /* Function 0: vprintf(control-string, arg-vector). To step this
      function down, the thunk passes the address of a structure that
      points to the control string and the (translated) vector of
      arguments. */

   case 0:
      {                          // vprintf
      struct vprintf_args
         {
         LPSTR cs;
         LPVOID args;
         } FAR *ap = (struct vprintf_args FAR *) data;

      return vprintf(ap->cs, ap->args);
      }                          // vprintf

/*--------------------------------------------------------------------*/

   /* Function 1: puts(string). For this function, the thunk just
      passes its own pointer argument straight through, and WIN32s
      translates it automatically. */

   case 1:
      {                          // puts
      return puts(data);
      }                          // puts

/*--------------------------------------------------------------------*/

   /* Function 2: FortyTwo() -- used for benchmarking purposes */

   case 2:
      return FortyTwo();

/*--------------------------------------------------------------------*/

   default:
      {                          // unknown function
      char errmsg[128];
      wsprintf(errmsg, "Unknown function (index %ld) specified in call"
         " to WALTIO.DLL Universal Thunk", funcode);
      MessageBox(NULL, errmsg, "ERROR", MB_ICONHAND | MB_OK);
      return 0;
      }                          // unknown function

      }                          // select function to perform
   }                             // UT16Proc
