
/*
 * This file was generated by the SOM Compiler.
 * FileName: wpprgext.c.
 * Generated using:
 *     SOM Precompiler spc: 1.22
 *     SOM Emitter emitc: 1.24
 */

/*
 * 
 * 
 *   Module Name : WPPRGEXT
 * 
 *   Description : OS/2 Workplace Shell WPProgram Object Extension.
 *                 This extension adds the option to close the folder
 *                 to which the launching program belongs.
 * 
 *   Programmer  : Yong D. Lee
 *   Date        : Nov 21, 1993
 * 
 *   Disclaimer of warranties:
 *       The code is provided "AS IS", without warranty of any kind.  I shall
 *       not be liable for any damages arising out of your use of this code.
 * 
 */

#define WPPrgExt_Class_Source
#define M_WPPrgExt_Class_Source

#include "wpprgext.ih"
#include "wpprgext.ph"

#include <string.h>
#include <stdio.h>
#include <memory.h>
#include <stdlib.h>

/*************************************************************************/
/*                                                                       */
/*                     Non-method function prototype                     */
/*                                                                       */
/*************************************************************************/

MRESULT EXPENTRY FolderDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);

/*************************************************************************/
/*                                                                       */
/*               Global/Static (Non-Instance) Data Section               */
/*                                                                       */
/*************************************************************************/

UCHAR szWPPrgExtClassTitle[CCHMAXPATH] = "";
HMODULE hmod = NULLHANDLE;

/*************************************************************************/
/*                                                                       */
/*                         Method Implementation                         */
/*                                                                       */
/*************************************************************************/

/*
 * 
 *  METHOD: QueryFolderClose                               ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 * 
 *    Query state of folder close flag
 * 
 *  RETURN:
 * 
 *    ULONG - folder closing option
 * 
 */

SOM_Scope ULONG   SOMLINK wpprgext_QueryFolderClose(WPPrgExt *somSelf)
{
    WPPrgExtData *somThis = WPPrgExtGetData(somSelf);
    WPPrgExtMethodDebug("WPPrgExt","wpprgext_QueryFolderClose");

    return (ULONG) _folderClose;
}

/*
 *
 *  METHOD: SetFolderClose                                 ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Set state of folder close flag
 *
 */

SOM_Scope VOID   SOMLINK wpprgext_SetFolderClose(WPPrgExt *somSelf, ULONG flag)
{
    WPPrgExtData *somThis = WPPrgExtGetData(somSelf);
    WPPrgExtMethodDebug("WPPrgExt","wpprgext_SetFolderClose");

    _folderClose = flag;
}

/*
 * 
 *  METHOD: AddFolderPage                                  ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 * 
 *    Add the folder page to the settings notebook
 * 
 *  RETURN:
 * 
 *    0              Unsuccessful
 *    ulPageId       Identifier for the inserted page
 * 
 * 
 *    Methods from the WPObject class
 * 
 */

SOM_Scope ULONG   SOMLINK wpprgext_AddFolderPage(WPPrgExt *somSelf, HWND hwndNotebook)
{
    PAGEINFO pageinfo;

    WPPrgExtData *somThis = WPPrgExtGetData(somSelf);
    WPPrgExtMethodDebug("WPPrgExt","wpprgext_AddFolderPage");

    memset((PCH)&pageinfo, 0, sizeof(PAGEINFO));
    pageinfo.cb = sizeof(PAGEINFO);
    pageinfo.hwndPage = NULLHANDLE;
    pageinfo.usPageStyleFlags = BKA_MAJOR;
    pageinfo.usPageInsertFlags = BKA_LAST;
    pageinfo.pfnwp = FolderDlgProc;
    pageinfo.resid = hmod;
    pageinfo.dlgid = IDD_FOLDER;
    pageinfo.pszName = "Folder";
    pageinfo.pCreateParams = somSelf;

    return _wpInsertSettingsPage(somSelf, hwndNotebook, &pageinfo);
}

/*************************************************************************/
/*                                                                       */
/*                     Override Method Implementation                    */
/*                                                                       */
/*************************************************************************/

/*
 * 
 *  OVERRIDE: wpInitData
 * 
 *  DESCRIPTION:
 * 
 *    Initialize the state variables and allocate any extra memory
 *    that might be needed
 * 
 */

SOM_Scope void   SOMLINK wpprgext_wpInitData(WPPrgExt *somSelf)
{
    WPPrgExtData *somThis = WPPrgExtGetData(somSelf);
    WPPrgExtMethodDebug("WPPrgExt","wpprgext_wpInitData");

    memset((PVOID)somThis, 0, sizeof(WPPrgExtData));
    _folderClose = DONOTCLOSE;

    parent_wpInitData(somSelf);
}

/*
 * 
 *  OVERRIDE: wpUnInitData
 * 
 *  DESCRIPTION:
 * 
 *    Clear up memory that was allocated on wpInitData
 * 
 */

SOM_Scope void   SOMLINK wpprgext_wpUnInitData(WPPrgExt *somSelf)
{
    WPPrgExtData *somThis = WPPrgExtGetData(somSelf);
    WPPrgExtMethodDebug("WPPrgExt","wpprgext_wpUnInitData");

    parent_wpUnInitData(somSelf);
}

/*
 * 
 *  OVERRIDE: wpSaveState
 * 
 *  DESCRIPTION:
 * 
 *    Save state variable (folder close flag)
 * 
 */

SOM_Scope BOOL   SOMLINK wpprgext_wpSaveState(WPPrgExt *somSelf)
{
    WPPrgExtData *somThis = WPPrgExtGetData(somSelf);
    WPPrgExtMethodDebug("WPPrgExt","wpprgext_wpSaveState");

    _wpSaveLong(somSelf, szWPPrgExtClassTitle, IDKEY_FOLDER, _folderClose);

    return (parent_wpSaveState(somSelf));
}

/*
 * 
 *  OVERRIDE: wpRestoreState
 * 
 *  DESCRIPTION:
 * 
 *    Restore saved state variable
 * 
 */

SOM_Scope BOOL   SOMLINK wpprgext_wpRestoreState(WPPrgExt *somSelf, ULONG ulReserved)
{
    WPPrgExtData *somThis = WPPrgExtGetData(somSelf);
    WPPrgExtMethodDebug("WPPrgExt","wpprgext_wpRestoreState");

    _wpRestoreLong(somSelf, szWPPrgExtClassTitle, IDKEY_FOLDER, &_folderClose);

    return (parent_wpRestoreState(somSelf,ulReserved));
}

/*
 * 
 *  OVERRIDE: wpAddSettingsPages
 * 
 *  DESCRIPTION:
 * 
 *    Add folder settings page to let the user alter the flag
 * 
 */

SOM_Scope BOOL   SOMLINK wpprgext_wpAddSettingsPages(WPPrgExt *somSelf, HWND hwndNotebook)
{
    WPPrgExtData *somThis = WPPrgExtGetData(somSelf);
    WPPrgExtMethodDebug("WPPrgExt","wpprgext_wpAddSettingsPages");

    if (parent_wpAddSettingsPages(somSelf, hwndNotebook) && _AddFolderPage(somSelf, hwndNotebook)) {
        return (TRUE);
    } else {
        return (FALSE);
    }
  
}

/*
 * 
 *   METHOD: wpOpen                                        
 *                                                         
 *   DESCRIPTION:
 * 
 *     Opens the program object window. Close folder upon openning 
 *     according to folderClose flag
 * 
 */

SOM_Scope HWND   SOMLINK wpprgext_wpOpen(WPPrgExt *somSelf, HWND hwndCnr, ULONG ulView, ULONG param)
{
    LONG leftShift;
    LONG rightShift;
    BOOL close;
    HWND hwndTop;

    WPPrgExtData *somThis = WPPrgExtGetData(somSelf);
    WPPrgExtMethodDebug("WPPrgExt","wpprgext_wpOpen");

    if (!_wpSwitchTo(somSelf, ulView)) {

        /*
         * Get the state of shift keys so that we can close the parent
         * folder if shift key is pressed
         */
        leftShift = WinGetPhysKeyState(HWND_DESKTOP, 0x002a);
        rightShift = WinGetPhysKeyState(HWND_DESKTOP, 0x0036);

        if ((leftShift & 0x8000) || (rightShift & 0x8000))
            close = TRUE;
        else {

            /*
             * Check for the flags in the Folder page in settings notebook
             */
            switch (ulView) {

                case OPEN_SETTINGS:

                    if (_folderClose & CLOSENOTEBOOK)
                        close = TRUE;
                    else
                        close = FALSE;

                    break;

                case OPEN_RUNNING:

                    if (_folderClose & CLOSEPROGRAM)
                        close = TRUE;
                    else
                        close = FALSE;

                    break;

                default:
                    close = FALSE;

            }
        }

        if (close) {

            /*
             * The active window before opwning the new folder must be the parent folder.
             * If it's not the desktop window (if there are no window below the parent
             * folder in z-order), close the parent window
             */
            if (((hwndTop = WinQueryActiveWindow(HWND_DESKTOP)) != NULLHANDLE) && (WinQueryWindow(hwndTop, QW_NEXT) != NULLHANDLE))
                WinSendMsg(hwndTop, WM_CLOSE, (MPARAM)0, (MPARAM)0);

        }
    }

    /*
     * Call the original wpOpen
     */
    return (parent_wpOpen(somSelf, hwndCnr, ulView, param));
}
/*
 * 
 *  OVERRIDE: wpSetup
 * 
 *  DESCRIPTION:
 * 
 *    Specift setup strings and do some initialization
 * 
 */

SOM_Scope BOOL   SOMLINK wpprgext_wpSetup(WPPrgExt *somSelf, PSZ pszSetupString)
{
    WPPrgExtData *somThis = WPPrgExtGetData(somSelf);
    WPPrgExtMethodDebug("WPPrgExt","wpprgext_wpSetup");

    return (parent_wpSetup(somSelf,pszSetupString));
}

#undef SOM_CurrentClass
#define SOM_CurrentClass SOMMeta

/*************************************************************************/
/*                                                                       */
/*                      Class Method Implementation                      */
/*                                                                       */
/*************************************************************************/

/*
 *
 *  METHOD: clsQueryModuleHandle                         ( ) PRIVATE
 *                                                       (X) PUBLIC
 *  DESCRIPTION:
 *
 *    This method returns the module handle of this class.
 *
 *  RETURN:
 *
 *    0          Unsuccessful
 *    non-zero   Module handle
 *
 */

SOM_Scope HMODULE   SOMLINK wpprgextM_clsQueryModuleHandle(M_WPPrgExt *somSelf)
{
    zString zsPathName;
    APIRET rc;

    /* M_WPPrgExtData *somThis = M_WPPrgExtGetData(somSelf); */
    M_WPPrgExtMethodDebug("M_WPPrgExt","wpprgextM_clsQueryModuleHandle");

    if (hmod == NULLHANDLE) {

       /*
        *   Retrieve registered pathname of our module (DLL) and query the
        *   module handle.
        */
       zsPathName = _somLocateClassFile(SOMClassMgrObject,
                                        SOM_IdFromString("WPPrgExt"),
                                        WPPrgExt_MajorVersion,
                                        WPPrgExt_MinorVersion);
       rc = DosQueryModuleHandle(zsPathName, &hmod);
    }

    return (hmod);
}

/*************************************************************************/
/*                                                                       */
/*                  Override Class Method Implementation                 */
/*                                                                       */
/*************************************************************************/

/*
 * 
 *  METHOD: wpclsInitData
 * 
 *  DESCRIPTION:
 * 
 *    Initialize the class data
 * 
 */

SOM_Scope void   SOMLINK wpprgextM_wpclsInitData(M_WPPrgExt *somSelf)
{

    /* M_WPPrgExtData *somThis = M_WPPrgExtGetData(somSelf); */
    M_WPPrgExtMethodDebug("M_WPPrgExt","wpprgextM_wpclsInitData");

    parent_wpclsInitData(somSelf);

    /* 
     * Get class title
     */

    if (!WinLoadString(WinQueryAnchorBlock(HWND_DESKTOP), 
                       _clsQueryModuleHandle(somSelf),  
                       ID_TITLE,        
                       sizeof(szWPPrgExtClassTitle),
                       szWPPrgExtClassTitle))
        strcpy(szWPPrgExtClassTitle, parent_wpclsQueryTitle(somSelf));
}

/*
 * 
 *  METHOD: wpclsUnInitData
 * 
 *  DESCRIPTION:
 * 
 *    Free any class data
 * 
 */

SOM_Scope void   SOMLINK wpprgextM_wpclsUnInitData(M_WPPrgExt *somSelf)
{
    /* M_WPPrgExtData *somThis = M_WPPrgExtGetData(somSelf); */
    M_WPPrgExtMethodDebug("M_WPPrgExt","wpprgextM_wpclsUnInitData");

    parent_wpclsUnInitData(somSelf);
}

/*
 *
 *  METHOD: wpclsQueryTitle                                
 *                                                         
 *  DESCRIPTION:
 *
 *    Return the string "Extended Program".
 *
 */

SOM_Scope PSZ   SOMLINK wpprgextM_wpclsQueryTitle(M_WPPrgExt *somSelf)
{
    /* M_WPPrgExtData *somThis = M_WPPrgExtGetData(somSelf); */
    M_WPPrgExtMethodDebug("M_WPPrgExt","wpprgextM_wpclsQueryTitle");

    /* 
     * Return the class title for a WPPrgExt
     */
    if (*szWPPrgExtClassTitle)
        return (szWPPrgExtClassTitle);
    else 
        return (parent_wpclsQueryTitle(somSelf));

}

/*************************************************************************/
/*                                                                       */
/*                   Non-method function implementation                  */
/*                                                                       */
/*************************************************************************/

MRESULT EXPENTRY FolderDlgProc(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   PFOLDER pFolder;
   MRESULT rc;

   switch(msg) {
      case WM_INITDLG:
         pFolder = (PFOLDER)_wpAllocMem((WPPrgExt *)mp2, sizeof(FOLDER), NULL);

         if (pFolder) {
            memset((PVOID)pFolder, 0, sizeof(FOLDER));
            pFolder->cb = sizeof(FOLDER);
            pFolder->somSelf = (WPPrgExt *)mp2;
            pFolder->closeFolder = _QueryFolderClose(pFolder->somSelf);
         }
         else 
            break;

         WinSetWindowPtr(hwndDlg, QWL_USER, pFolder);

         if (pFolder->closeFolder & CLOSENOTEBOOK)
            WinSendMsg(WinWindowFromID(hwndDlg, IDCHECK_CLOSENOTEBOOK), BM_SETCHECK, MPFROMSHORT(1), (MPARAM)0);
         else
            WinSendMsg(WinWindowFromID(hwndDlg, IDCHECK_CLOSENOTEBOOK), BM_SETCHECK, MPFROMSHORT(0), (MPARAM)0);

         if (pFolder->closeFolder & CLOSEPROGRAM)
            WinSendMsg(WinWindowFromID(hwndDlg, IDCHECK_CLOSEPROGRAM), BM_SETCHECK, MPFROMSHORT(1), (MPARAM)0);
         else
            WinSendMsg(WinWindowFromID(hwndDlg, IDCHECK_CLOSEPROGRAM), BM_SETCHECK, MPFROMSHORT(0), (MPARAM)0);

         return (MRESULT)TRUE;

      case WM_CLOSE:
         pFolder = WinQueryWindowPtr(hwndDlg, QWL_USER);
 
         if (pFolder == NULL) 
             break;

         _wpFreeMem(pFolder->somSelf, (PBYTE)pFolder);
         return (WinDefDlgProc(hwndDlg, msg, mp1, mp2));

      case WM_CONTROL:
         pFolder = WinQueryWindowPtr(hwndDlg, QWL_USER);

         if (pFolder == NULL) 
            break;

         switch (SHORT1FROMMP(mp1)) {

            case IDCHECK_CLOSENOTEBOOK:

               if (SHORT2FROMMP(mp1) == BN_CLICKED) {
                  rc = WinSendMsg(WinWindowFromID(hwndDlg, IDCHECK_CLOSENOTEBOOK), BM_QUERYCHECK, (MPARAM)0, (MPARAM)0);

                  if ((USHORT)rc == 1)
                     pFolder->closeFolder |= CLOSENOTEBOOK;
                  else if ((USHORT)rc == 0)
                     pFolder->closeFolder &= ~CLOSENOTEBOOK;

                  _SetFolderClose(pFolder->somSelf, pFolder->closeFolder);
               }

               break;
            case IDCHECK_CLOSEPROGRAM:

               if (SHORT2FROMMP(mp1) == BN_CLICKED) {
                  rc = WinSendMsg(WinWindowFromID(hwndDlg, IDCHECK_CLOSEPROGRAM), BM_QUERYCHECK, (MPARAM)0, (MPARAM)0);

                  if ((USHORT)rc == 1)
                     pFolder->closeFolder |= CLOSEPROGRAM;
                  else if ((USHORT)rc == 0)
                     pFolder->closeFolder &= ~CLOSEPROGRAM;

                  _SetFolderClose(pFolder->somSelf, pFolder->closeFolder);
               }

               break;

         }
      
         return (MRESULT)TRUE;
   }

   return (WinDefDlgProc(hwndDlg, msg, mp1, mp2));
} 
