/****************************************************************************\
*                                                                            *
* Figure 12                                                                  *
*                                                                            *
* WinSets,   Guy Eddon, 1993                                                 *
*                                                                            *
* MENU.C - This module handles most menu commands initiated by the user.     *
*                                                                            *
\****************************************************************************/

#include "winsets.h"

void winsets_command_new(HWND hwnd, int num_circles, char *selected_card,
   int ball_rad, int radius, int ledge, current_cards *visible,
   float x_ellipse_factor, float y_ellipse_factor,
   int *num_moves_left, BOOL *sizing, char *global_card_array_count,
   char *card_array, BOOL *paint_cards, int *time_left, int *current_score,
   BOOL *new_game_flag, HMENU hMainMenu, BOOL *paint_reverse_card)
   {
   HDC hdc;

   if(*new_game_flag == TRUE)
      return;

   EnableMenuItem(hMainMenu, IDM_UNDO, MF_GRAYED);

   *new_game_flag = TRUE;

   *paint_reverse_card = TRUE;

   *selected_card = (char)NULL;

   new_game(global_card_array_count, card_array);

   *time_left = -1;
   *current_score = 0;
   *num_moves_left = 0;

   hdc = GetDC(hwnd);

   *paint_cards = FALSE;

   ball_blue.current_hole = randomize_ball(num_circles, TRUE);
   ball_green.current_hole = randomize_ball(num_circles, FALSE);
   ball_red.current_hole = randomize_ball(num_circles, FALSE);
   ball_yellow.current_hole = randomize_ball(num_circles, FALSE);

   if(num_circles == 10)
      ball_pink.current_hole = randomize_ball(num_circles, FALSE);

   InitSpriteInfo(hdc, ball_green.hbmImg_color, ball_rad, radius,
      num_circles, ledge,  &ball_green, x_ellipse_factor, y_ellipse_factor);
   InitSpriteInfo(hdc, ball_red.hbmImg_color, ball_rad, radius, num_circles,
      ledge, &ball_red, x_ellipse_factor, y_ellipse_factor);
   InitSpriteInfo(hdc, ball_yellow.hbmImg_color, ball_rad, radius,
      num_circles, ledge, &ball_yellow, x_ellipse_factor, y_ellipse_factor);
   InitSpriteInfo(hdc, ball_blue.hbmImg_color, ball_rad, radius, num_circles,
      ledge, &ball_blue, x_ellipse_factor, y_ellipse_factor);

   if(num_circles == 10)
      InitSpriteInfo(hdc, ball_pink.hbmImg_color, ball_rad, radius,
         num_circles, ledge,   &ball_pink, x_ellipse_factor,
         y_ellipse_factor);
   
   visible->one_card_finished = TRUE;
   visible->two_card_finished = TRUE;
   visible->thr_card_finished = TRUE;

   ReleaseDC(hwnd, hdc);

   *sizing = TRUE;

   InvalidateRect(hwnd, NULL, TRUE);
   UpdateWindow(hwnd);
   }

void winsets_command_undo(HWND hwnd, int num_circles, int ball_rad,
   int radius, int ledge, float x_ellipse_factor, float y_ellipse_factor,
   int *num_moves_left, HINSTANCE ghInst, HMENU hMainMenu, RECT *win_rect)
   {
   HDC hdc;
   POINT pt = { global_last_ball_moved->bmX, global_last_ball_moved->bmY };
   int temp_current_hole_holder = global_last_ball_moved->current_hole;

   hdc = GetDC(hwnd);

   (*num_moves_left)++;
   display_moves_left(hdc, win_rect, *num_moves_left, FALSE, ghInst);

   ReleaseDC(hwnd, hdc);

   EnableMenuItem(hMainMenu, IDM_UNDO, MF_GRAYED);

   global_last_ball_moved->xPrev = global_last_ball_moved->bmX;
   global_last_ball_moved->yPrev = global_last_ball_moved->bmY;

   global_last_ball_moved->current_hole =
      global_last_ball_moved->previous_hole;
   global_last_ball_moved->previous_hole = temp_current_hole_holder;

   FinishSpriteAnimation(hwnd, NO_HOLE, ball_rad, radius, num_circles, ledge,
      global_last_ball_moved, &pt, x_ellipse_factor, y_ellipse_factor,
      win_rect, FALSE, TRUE);
   }

void winsets_command_four(HWND hwnd, int *num_circles, char *selected_card,
   int ball_rad, int radius, int ledge, current_cards *visible,
   float x_ellipse_factor, float y_ellipse_factor,
   int *num_moves_left, BOOL *sizing, BOOL *paint_cards, HMENU hMainMenu,
   HMENU hGameMenu, char *global_card_array_count, char *card_array,
   int *time_left, int *current_score, BOOL *new_game_flag,
   BOOL *paint_reverse_card)
   {
   HDC hdc;

   if((GetMenuState(hGameMenu, IDM_FOUR, MF_BYCOMMAND) & MF_CHECKED)
      == MF_CHECKED)
      return;

   WritePrivateProfileString(szAppName, "Holes", "8", fqfn);

   *num_circles = 8;

   *paint_reverse_card = TRUE;

   *new_game_flag = TRUE;

   EnableMenuItem(hMainMenu, IDM_UNDO, MF_GRAYED);

   *time_left = -1;
   *current_score = 0;
   *num_moves_left = 0;

   *paint_cards = FALSE;

   *selected_card = (char)NULL;

   new_game(global_card_array_count, card_array);

   visible->one_card_finished = TRUE;
   visible->two_card_finished = TRUE;
   visible->thr_card_finished = TRUE;

   ball_blue.current_hole = randomize_ball(*num_circles, TRUE);
   ball_green.current_hole = randomize_ball(*num_circles, FALSE);
   ball_red.current_hole = randomize_ball(*num_circles, FALSE);
   ball_yellow.current_hole = randomize_ball(*num_circles, FALSE);

   hdc = GetDC(hwnd);

   InitSpriteInfo(hdc, ball_green.hbmImg_color, ball_rad, radius,
      *num_circles, ledge,  &ball_green, x_ellipse_factor, y_ellipse_factor);
   InitSpriteInfo(hdc, ball_red.hbmImg_color, ball_rad, radius, *num_circles,
      ledge, &ball_red, x_ellipse_factor, y_ellipse_factor);
   InitSpriteInfo(hdc, ball_yellow.hbmImg_color, ball_rad, radius,
      *num_circles, ledge, &ball_yellow, x_ellipse_factor, y_ellipse_factor);
   InitSpriteInfo(hdc, ball_blue.hbmImg_color, ball_rad, radius,
      *num_circles, ledge, &ball_blue, x_ellipse_factor, y_ellipse_factor);

   ReleaseDC(hwnd, hdc);

   CheckMenuItem(hMainMenu, IDM_FOUR, MF_CHECKED);
   CheckMenuItem(hMainMenu, IDM_FIVE, MF_UNCHECKED);

   *sizing = TRUE;

   InvalidateRect(hwnd, NULL, TRUE);
   UpdateWindow(hwnd);
   }

void winsets_command_five(HWND hwnd, int *num_circles, char *selected_card,
   int ball_rad, int radius, int ledge, current_cards *visible,
   float x_ellipse_factor, float y_ellipse_factor,
   int *num_moves_left, BOOL *sizing, BOOL *paint_cards, HMENU hMainMenu,
   HMENU hGameMenu, char *global_card_array_count, char *card_array,
   int *time_left, int *current_score, BOOL *new_game_flag,
   BOOL *paint_reverse_card)
   { 
   HDC hdc;

   if((GetMenuState(hGameMenu, IDM_FIVE, MF_BYCOMMAND) & MF_CHECKED)
      == MF_CHECKED)
      return;

   WritePrivateProfileString(szAppName, "Holes", "10", fqfn);

   *num_circles = 10;

   *paint_reverse_card = TRUE;

   *new_game_flag = TRUE;

   EnableMenuItem(hMainMenu, IDM_UNDO, MF_GRAYED);

   *time_left = -1;
   *current_score = 0;
   *num_moves_left = 0;

   *paint_cards = FALSE;

   *selected_card = (char)NULL;

   new_game(global_card_array_count, card_array);

   visible->one_card_finished = TRUE;
   visible->two_card_finished = TRUE;
   visible->thr_card_finished = TRUE;

   ball_blue.current_hole = randomize_ball(*num_circles, TRUE);
   ball_green.current_hole = randomize_ball(*num_circles, FALSE);
   ball_red.current_hole = randomize_ball(*num_circles, FALSE);
   ball_yellow.current_hole = randomize_ball(*num_circles, FALSE);
   ball_pink.current_hole = randomize_ball(*num_circles, FALSE);

   hdc = GetDC(hwnd);

   InitSpriteInfo(hdc, ball_green.hbmImg_color, ball_rad, radius,
      *num_circles, ledge, &ball_green, x_ellipse_factor, y_ellipse_factor);
   InitSpriteInfo(hdc, ball_blue.hbmImg_color, ball_rad, radius,
      *num_circles, ledge, &ball_blue, x_ellipse_factor, y_ellipse_factor);
   InitSpriteInfo(hdc, ball_yellow.hbmImg_color, ball_rad, radius,
      *num_circles, ledge, &ball_yellow, x_ellipse_factor, y_ellipse_factor);
   InitSpriteInfo(hdc, ball_red.hbmImg_color, ball_rad, radius, *num_circles,
      ledge, &ball_red, x_ellipse_factor, y_ellipse_factor);
   InitSpriteInfo(hdc, ball_pink.hbmImg_color, ball_rad, radius,
      *num_circles, ledge, &ball_pink, x_ellipse_factor, y_ellipse_factor);

   ReleaseDC(hwnd, hdc);

   CheckMenuItem(hMainMenu, IDM_FIVE, MF_CHECKED);
   CheckMenuItem(hMainMenu, IDM_FOUR, MF_UNCHECKED);

   *sizing = TRUE;

   InvalidateRect(hwnd, NULL, TRUE);
   UpdateWindow(hwnd);
   }

void winsets_command_shape(HWND hwnd, WPARAM wParam, HMENU hMainMenu,
   int ball_rad, int radius, int num_circles, int ledge,
   float *x_ellipse_factor, float *y_ellipse_factor, BOOL *sizing)
   {
   HDC hdc = GetDC(hwnd);

   if(num_circles == 10)
      InitSpriteInfo(hdc, ball_pink.hbmImg_color, ball_rad, radius,
         num_circles, ledge, &ball_pink, *x_ellipse_factor,
         *y_ellipse_factor);

   InitSpriteInfo(hdc, ball_green.hbmImg_color, ball_rad, radius,
      num_circles, ledge, &ball_green, *x_ellipse_factor,
      *y_ellipse_factor);
   InitSpriteInfo(hdc, ball_red.hbmImg_color, ball_rad, radius,
      num_circles, ledge, &ball_red, *x_ellipse_factor,
      *y_ellipse_factor);
   InitSpriteInfo(hdc, ball_yellow.hbmImg_color, ball_rad, radius,
      num_circles, ledge, &ball_yellow, *x_ellipse_factor,
      *y_ellipse_factor);
   InitSpriteInfo(hdc, ball_blue.hbmImg_color, ball_rad, radius,
      num_circles, ledge, &ball_blue, *x_ellipse_factor,
      *y_ellipse_factor);

   ReleaseDC(hwnd, hdc);

   *sizing = TRUE;

   InvalidateRect(hwnd, NULL, TRUE);
   UpdateWindow(hwnd);
   }

