/****************************************************************************\
*                                                                            *
* Figure 8                                                                   *
*                                                                            *
* WinSets,   Guy Eddon, 1993                                                 *
*                                                                            *
* MISC.C - This module contains some miscellaneous functions.                *
*                                                                            *
\****************************************************************************/

#include "winsets.h"

void alphabetize_string(char *string)
   {
   char temp1, temp2;
   int count, outside_loop;

   for(outside_loop = 0; outside_loop < (signed int)strlen(string);
      outside_loop++)
      for(count = 0; count < (signed int)(strlen(string)-1); count++)
         {
         temp1 = string[count];
         temp2 = string[count+1];

         string[count] = (char)min(temp1, temp2);
         string[count+1] = (char)max(temp1, temp2);
         }
   }

void random_seed(void)
   {
   char buffer[10];
   struct tm *tp;
   time_t time_rand;
   int seed;

   time(&time_rand);
   tp = localtime(&time_rand);
   strftime(buffer, sizeof(buffer), "%S", tp);
   seed = atoi(buffer);
   srand(seed);
   }

int random_number(int max)
   {
   int random, result;

   random = rand();
   result = (int)((random / 32767.0) * (max - 1));

/* First time called returns 0 - After that returns between 0 and max - 1 */

   return result;
   }

int num_chr_in_str(const char *string, char locate)
   {
   int count = 0;

   while(*(string++))
      if(*string == locate)
         count++;

   return count;
   }

void draw_line(HDC hdc, int x1, int y1, int x2, int y2)
   {

#ifdef WIN32
   POINT dummy;

   MoveToEx(hdc, x1, y1, &dummy);
#else
   MoveTo(hdc, x1, y1);
#endif

   LineTo(hdc, x2, y2);
   }

void draw_ball(HDC hdc, int ball_rad, int x, int y)
   {
   Ellipse(hdc, x-ball_rad, y-ball_rad, x+ball_rad, y+ball_rad);
   }

void make_string_from_bowl(char *return_string, int num_circles)
   {
   int count;

   for(count = 0; count < num_circles; count++)
      {
      if(num_circles == 10)
         if(ball_pink.current_hole == count)
            {
            return_string[count] = 'P';
            continue;
            }

      if(ball_red.current_hole == count)
         {
         return_string[count] = 'R';
         continue;
         }

      if(ball_green.current_hole == count)
         {
         return_string[count] = 'G';
         continue;
         }

      if(ball_blue.current_hole == count)
         {
         return_string[count] = 'B';
         continue;
         }

      if(ball_yellow.current_hole == count)
         {
         return_string[count] = 'Y';
         continue;
         }

      return_string[count] = (char)32;
      }

   return_string[num_circles] = 0;
   }

BOOL compare_card_to_balls(const char *card_string, char *bowl_string)
   {
   char card_tokens[CARD_BALLS_TALL+1][CARD_BALLS_TALL+1];
   char bowl_tokens[CARD_BALLS_TALL+1][CARD_BALLS_TALL+1];

   memset(card_tokens, 0, (CARD_BALLS_TALL+1)*(CARD_BALLS_TALL+1));
   memset(bowl_tokens, 0, (CARD_BALLS_TALL+1)*(CARD_BALLS_TALL+1));

   tokenize_string(card_string, card_tokens, TRUE);
   tokenize_string(bowl_string, bowl_tokens, FALSE);

   alphabetize_entire_token(card_tokens);
   alphabetize_entire_token(bowl_tokens);

   return compare_tokens(card_tokens, bowl_tokens);
   }

void alphabetize_entire_token(
   char tokens[CARD_BALLS_TALL+1][CARD_BALLS_TALL+1])
   {
   int count;

   for(count = 0; count < CARD_BALLS_TALL+1; count++)
      alphabetize_string(tokens[count]);

   alphabetize_token(tokens);
   }

void alphabetize_token(char tokens[CARD_BALLS_TALL+1][CARD_BALLS_TALL+1])
   {
   char temp[CARD_BALLS_TALL+1];
   int count, outside_loop;

   for(outside_loop = 0; outside_loop < CARD_BALLS_TALL+1; outside_loop++)
      for(count = 0; count < (CARD_BALLS_TALL-1); count++)
         if(tokens[count][0] > tokens[count+1][0])
            {
            strcpy(temp, tokens[count]);
            strcpy(tokens[count], tokens[count+1]);
            strcpy(tokens[count+1], temp);
            }
   }

void tokenize_string(const char *string,
   char tokens[CARD_BALLS_TALL+1][CARD_BALLS_TALL+1],
   BOOL card_configuration)
   {
   char copy_string[MAX_BALLS+1];
   char *token;
   int count = 0;

   strcpy(copy_string, string);
   token = strtok(copy_string, " ");

   strcpy(tokens[count], token);

   while(token != NULL)
      {
      token = strtok(NULL, " ");

      if(token != NULL)
         strcpy(tokens[++count], token);
      }

   count++;

   if(string[strlen(string)-1] != (char)32 && string[0] != (char)32
      && card_configuration != TRUE)
      {
      strcat(tokens[0], tokens[count-1]);
      tokens[count-1][0] = 0;
      }
   }

BOOL compare_tokens(char card_tokens[CARD_BALLS_TALL+1][CARD_BALLS_TALL+1],
   char bowl_tokens[CARD_BALLS_TALL+1][CARD_BALLS_TALL+1])
   {
   int count;

   for(count = 0; count < CARD_BALLS_TALL + 1; count++)
      if(strcmp(card_tokens[count], bowl_tokens[count]) != 0)
         return FALSE;

   return TRUE;
   }

void display_moves_left(HDC hdc, RECT *rect, int num_moves_left,
   BOOL repaint_flag, HINSTANCE ghInst)
   {
   char num_moves_buffer[NORMAL_BUFFER];

   LoadString(ghInst, IDM_MOVES_LEFT, num_moves_buffer,
      sizeof(num_moves_buffer));
   wsprintf(num_moves_buffer, num_moves_buffer, num_moves_left);
   draw_status_bar_text(hdc, num_moves_buffer, rect, status_bar_height,
      repaint_flag, FIRST_STATUS_BAR_BOX);
   }

int get_random_card(int max, char *global_card_array_count, char *card_array)
   {
   char temp;

   do
      temp = (char)random_number(max);
      while(memchr(card_array, temp, FIVE_CARD_GAME) != NULL);

   card_array[(*global_card_array_count)++] = temp;

   return temp;
   }

void draw_holes(HDC hdc, HBRUSH hbr_color, int num_circles, int ball_rad,
   unsigned radius, int ledge, float x_ellipse_factor,
   float y_ellipse_factor)
   {
   int count;
   float pen_width = (float)(radius / 55);
   HPEN hWhitePen = CreatePen(PS_INSIDEFRAME, (int)((pen_width / 2) + 0.5),
      WHITE);
   HPEN hGrayPen = CreatePen(PS_INSIDEFRAME, (int)(pen_width), GRAY);
   HRGN hTopRgn = CreateRectRgn(0, 0, 0, 0);
   POINT pt;

   SelectObject(hdc, hbr_color);

   for(count = 0; count < num_circles; count++)
      {
      get_hole_coord(count, ball_rad, radius, num_circles, ledge,
         x_ellipse_factor, y_ellipse_factor, &pt);

      SelectObject(hdc, GetStockObject(NULL_BRUSH));

      SaveDC(hdc);

      SelectObject(hdc, hWhitePen);

      // Draw white part of the ellipse
      Ellipse(hdc,
         (int)(radius*x_ellipse_factor)-pt.x-ball_rad,
         (int)(radius*(y_ellipse_factor+BALL_ELLIPSE_FACTOR/2))
            -pt.y-ball_rad,
         (int)(radius*x_ellipse_factor)-pt.x+ball_rad,
         (int)(radius*(y_ellipse_factor-BALL_ELLIPSE_FACTOR/2))
            -pt.y+ball_rad);

      SetRectRgn(hTopRgn,
         (int)(radius*x_ellipse_factor)-pt.x-ball_rad,
         (int)(radius*(y_ellipse_factor+BALL_ELLIPSE_FACTOR/2))
            -pt.y-ball_rad,
         (int)(radius*x_ellipse_factor)-pt.x+ball_rad,
         (int)(radius*(y_ellipse_factor-BALL_ELLIPSE_FACTOR/1.15))
            -pt.y+ball_rad);

      SelectObject(hdc, hGrayPen);

      SelectObject(hdc, hTopRgn);

      // Draw dark gray part of the ellipse
      Ellipse(hdc,
         (int)(radius*x_ellipse_factor)-pt.x-ball_rad,
         (int)(radius*(y_ellipse_factor+BALL_ELLIPSE_FACTOR/2))
            -pt.y-ball_rad,
         (int)(radius*x_ellipse_factor)-pt.x+ball_rad,
         (int)(radius*(y_ellipse_factor-BALL_ELLIPSE_FACTOR/2))
            -pt.y+ball_rad);

      RestoreDC(hdc, -1);

      // Draw black outline of the ellipse
      Ellipse(hdc,
         (int)(radius*x_ellipse_factor)-pt.x-ball_rad,
         (int)(radius*(y_ellipse_factor+BALL_ELLIPSE_FACTOR/2))
            -pt.y-ball_rad,
         (int)(radius*x_ellipse_factor)-pt.x+ball_rad,
         (int)(radius*(y_ellipse_factor-BALL_ELLIPSE_FACTOR/2))
            -pt.y+ball_rad);
      }

   DeleteObject(hWhitePen);
   DeleteObject(hGrayPen);
   DeleteObject(hTopRgn);
   }

BOOL drop_ball(HWND hwnd, POINT *point, int ball_rad, unsigned radius,
   int num_circles, int ledge, SPRITE *ball_color, char *selected_card,
   current_cards *visible, RECT *rect, int ball_diam, float x_ellipse_factor,
   float y_ellipse_factor, int *current_score, int num_moves_left,
   HMENU hMainMenu)
   {
   int count;

   for(count = 0; count < num_circles; count++)
      if(is_ball_in_hole(hwnd, count, point, ball_rad, radius, num_circles,
         ledge, ball_color, x_ellipse_factor, y_ellipse_factor, rect))
         {
         global_last_ball_moved = ball_color;

         EnableMenuItem(hMainMenu, IDM_UNDO, MF_ENABLED);

         do_card_complete(hwnd, selected_card, num_circles, visible, rect,
            ball_diam, ledge, current_score, num_moves_left, hMainMenu);

         return TRUE;
         }

   FinishSpriteAnimation(hwnd, NO_HOLE, ball_rad, radius, num_circles, ledge,
      ball_color, point, x_ellipse_factor, y_ellipse_factor, rect, FALSE,
      FALSE);
   return FALSE;
   }

BOOL is_point_in_hole(HWND hwnd, int hole_number, POINT *point, int ball_rad,
   unsigned radius, int num_circles, int ledge, float x_ellipse_factor,
   float y_ellipse_factor)
   {
   POINT pt;
   HRGN hrgn;
   BOOL ret_val;

   get_hole_coord(hole_number, ball_rad, radius, num_circles, ledge,
      x_ellipse_factor, y_ellipse_factor, &pt);

   hrgn = CreateEllipticRgn(
      (int)((radius*x_ellipse_factor)-pt.x-(1.5*ball_rad)),
      (int)((radius*y_ellipse_factor)-pt.y-(2*ball_rad)),
      (int)((radius*x_ellipse_factor)-pt.x+(1.5*ball_rad)),
      (int)((radius*y_ellipse_factor)-pt.y+(1.5*ball_rad)));

   ret_val = PtInRegion(hrgn, point->x, point->y);

   DeleteObject(hrgn);

   return ret_val;
   }

BOOL is_a_ball_in_this_hole(int hole_number, int num_circles)
   {
   if(num_circles == 10)
      {
      if(ball_pink.current_hole   != hole_number &&
         ball_blue.current_hole   != hole_number &&
         ball_green.current_hole  != hole_number &&
         ball_yellow.current_hole != hole_number &&
         ball_red.current_hole    != hole_number)
         return FALSE;
      }
   else
      {
      if(ball_blue.current_hole   != hole_number &&
         ball_green.current_hole  != hole_number &&
         ball_yellow.current_hole != hole_number &&
         ball_red.current_hole    != hole_number)
         return FALSE;
      }

   return TRUE;
   }

BOOL is_ball_in_hole(HWND hwnd, int hole_number, POINT *point, int ball_rad,
   unsigned radius, int num_circles, int ledge, SPRITE *ball_color,
   float x_ellipse_factor, float y_ellipse_factor, RECT *win_rect)
   {
   BOOL ret_val;

   ret_val = is_point_in_hole(hwnd, hole_number, point, ball_rad, radius,
      num_circles, ledge, x_ellipse_factor, y_ellipse_factor);

   if(ret_val != 0)
      if(!is_a_ball_in_this_hole(hole_number, num_circles))
         {
         FinishSpriteAnimation(hwnd, hole_number, ball_rad, radius,
            num_circles, ledge, ball_color, point, x_ellipse_factor,
            y_ellipse_factor, win_rect, FALSE, FALSE);
         return TRUE;
         }

   return FALSE;
   }

void get_hole_coord(int hole, int ball_rad, unsigned radius, int num_circles,
   int ledge, float x_ellipse_factor, float y_ellipse_factor, POINT *pt)
   {
   double a, a_2, b, b_2, tangent, tangent_2, new_radius;

   a = (radius * y_ellipse_factor);
   if(a < 1)
      a = 1;
   a_2 = (a * a);
   b = (radius * x_ellipse_factor);
   if(b < 1)
      b = 1;
   b_2 = (b * b);
   tangent = (((2.0 * PI) / num_circles) * hole);
   tangent_2 = (tan(tangent) * tan(tangent));

   new_radius = a * b * sqrt((1.0 + tangent_2) / (b_2 + a_2 * tangent_2));

   pt->x = (int)(((new_radius - (ledge + (1.4 * ball_rad))) * sin(((2.0 * PI)
      / num_circles) * hole)) - (ball_rad / 2) * sin(tangent));
   pt->y = (int)((new_radius - (ledge + (1.4 * ball_rad))) * cos(((2.0 * PI)
      / num_circles) * hole));
   }

int randomize_ball(int num_circles, BOOL start_flag)
   {
   static char ball_config[MAX_BALLS];
   static int count;
   char temp;

   if(start_flag == TRUE)
      {   
      count = 0;
      memset(ball_config, -1, MAX_BALLS);
      }

   do
      temp = (char)random_number(num_circles + 1);
      while(memchr(ball_config, temp, MAX_BALLS) != NULL);

   ball_config[count] = temp;

   count++;

   return (int)temp;
   }

void initialize_ball(SPRITE *ball_color, BOOL start_flag, int num_circles)
   {
   ball_color->xPrev = 0;
   ball_color->yPrev = 0;
   ball_color->hbmImg_color = NULL;
   ball_color->bSelected = FALSE;
   ball_color->current_hole = randomize_ball(num_circles, start_flag);
   }

void new_game(char *global_card_array_count, char *card_array)
   {
   memset(card_array, -1, FIVE_CARD_GAME);
   *global_card_array_count = 0;
   }

void Meter(HWND hwnd, HDC hdc, RECT *meter_rect, int time_left,
   int meter_flag)
   {
   static RECT meter_rect_save;
   static int  total_time_left_save;

   if(time_left < 1)
      time_left = 1;

   switch(meter_flag)
      {
      case METER_INIT:
         CopyRect(&meter_rect_save, meter_rect);
         total_time_left_save = time_left;
         break;

      case METER_FILL:
         {
         HDC hdc_local;
         HBRUSH hBlueBrush, hOldBrush;
         int distance_to_fill;

         hdc_local = GetDC(hwnd);

         hBlueBrush = CreateSolidBrush(BLUE);
         hOldBrush = SelectObject(hdc_local, hBlueBrush);

         if(total_time_left_save == 0)
            distance_to_fill = meter_rect_save.right;
         else
            distance_to_fill = (meter_rect_save.left +
            (((meter_rect_save.right - meter_rect_save.left)
            * (total_time_left_save - (time_left-1))
            / total_time_left_save)));

         Rectangle(hdc_local, meter_rect_save.left, meter_rect_save.top,
            distance_to_fill, meter_rect_save.bottom);

         SelectObject(hdc_local, hOldBrush);
         DeleteObject(hBlueBrush);
         ReleaseDC(hwnd, hdc_local);
         }
         break;

      case METER_PAINT:
         {
         HBRUSH hBlueBrush, hOldBrush;
         int distance_to_fill;

         hOldBrush = SelectObject(hdc, GetStockObject(NULL_BRUSH));

         Rectangle(hdc, meter_rect_save.left, meter_rect_save.top,
            meter_rect_save.right, meter_rect_save.bottom);

         hBlueBrush = CreateSolidBrush(BLUE);
         SelectObject(hdc, hBlueBrush);

         if(total_time_left_save == 0)
            distance_to_fill = meter_rect_save.right;
         else
            distance_to_fill = (meter_rect_save.left +
            (((meter_rect_save.right - meter_rect_save.left)
            * (total_time_left_save - (time_left-1))
            / total_time_left_save)));

         Rectangle(hdc, meter_rect_save.left, meter_rect_save.top,
            distance_to_fill, meter_rect_save.bottom);

         SelectObject(hdc, hOldBrush);
         DeleteObject(hBlueBrush);
         }
         break;
      }
   }

void transform_coord(POINT *point, unsigned radius, float x_ellipse_factor,
   float y_ellipse_factor, int ball_rad)
   {
   point->x = (int)((((radius*x_ellipse_factor)-point->x-ball_rad
      + (radius*x_ellipse_factor)-point->x+ball_rad)) / 2);
   point->y = (int)((((radius*y_ellipse_factor)-point->y-(ball_rad*2.5)
      + (radius*y_ellipse_factor)-point->y+ball_rad)) / 2);
   }

