/****************************************************************************\
*                                                                            *
* Figure 13                                                                  *
*                                                                            *
* WinSets,   Guy Eddon, 1993                                                 *
*                                                                            *
* STATBAR.C - This module creates and manages the status bar.                *
*                                                                            *
\****************************************************************************/

#include "winsets.h"

void draw_status_bar(HDC hdc, RECT *rect, int height, BOOL repaint_flag,
   int box)
   {
   HBRUSH hOldBrush;
   HPEN hGrayPen, hOldPen;

   hGrayPen = CreatePen(PS_SOLID, 1, LT_GRAY);

   hOldBrush = SelectObject(hdc, GetStockObject(LTGRAY_BRUSH));
   hOldPen = SelectObject(hdc, hGrayPen);

   if(repaint_flag == FALSE)
      {
      RECT draw_rect = get_status_bar_coordinates(rect, box, height);
      Rectangle(hdc, draw_rect.left, draw_rect.top+1, draw_rect.right,
         draw_rect.bottom);
      }
   else
      {
      Rectangle(hdc, rect->left, rect->bottom, rect->right,
         rect->bottom+height);

      SelectObject(hdc, GetStockObject(BLACK_PEN));

      draw_line(hdc, rect->left, rect->bottom-1, rect->right,
         rect->bottom-1);

      draw_status_box(hdc, rect, FIRST_STATUS_BAR_BOX, height);
      draw_status_box(hdc, rect, SECOND_STATUS_BAR_BOX, height);
      draw_status_box(hdc, rect, THIRD_STATUS_BAR_BOX, height);
      }

   SelectObject(hdc, hOldBrush);
   SelectObject(hdc, hOldPen);

   DeleteObject(hOldPen);
   DeleteObject(hGrayPen);
   }

void draw_status_bar_text(HDC hdc, char *menu_buffer, RECT *rect, int height,
   BOOL repaint_flag, int box)
   {
   HRGN   hrgn;
   RECT   draw_rect;

   if(!status_bar_flag)
      return;

   if(repaint_flag)
      draw_status_bar(hdc, rect, height, TRUE, box);

   SaveDC(hdc);

   draw_rect = get_status_bar_coordinates(rect, box, height);

   hrgn = CreateRectRgn(draw_rect.left+3, draw_rect.top, draw_rect.right-3,
      draw_rect.bottom);

   SelectClipRgn(hdc, hrgn);

   draw_status_bar(hdc, rect, height, FALSE, box);

   SetBkMode(hdc, TRANSPARENT);

   TextOut(hdc, draw_rect.left+3, draw_rect.top+1, menu_buffer,
      strlen(menu_buffer));

   RestoreDC(hdc, -1);

   DeleteObject(hrgn);
   }

void fill_status_bar(HDC hdc, int value, RECT *rect, int height,
   BOOL repaint_flag, int box)
   {
   char menu_buffer[NORMAL_BUFFER];

   if(!status_bar_flag)
      return;

   switch(box)
      {
      case TIME_BOX:
         wsprintf(menu_buffer, "Time: %d", value);
         break;

      case SCORE_BOX:
         wsprintf(menu_buffer, "Score: %d", value);
         break;
      }

   draw_status_bar_text(hdc, menu_buffer, rect, height, repaint_flag, box);
   }

RECT get_status_bar_coordinates(RECT *win_rect, int box, int height)
   {
   RECT rect;

   switch(box)
      {
      case FIRST_STATUS_BAR_BOX:
         rect.left   = win_rect->left + HORIZONTAL_STATUSBAR_BORDER;
         rect.top    = win_rect->bottom + 2;
         rect.right  = (int)((win_rect->right/STATBAR_HELP_RATIO)
            -HORIZONTAL_STATUSBAR_BORDER);
         rect.bottom = win_rect->bottom+height-3;
         break;

      case SECOND_STATUS_BAR_BOX:
         rect.left   = (int)(win_rect->right/STATBAR_HELP_RATIO)
            -HORIZONTAL_STATUSBAR_BORDER+5;
         rect.top    = win_rect->bottom + 2;
         rect.right  = (int)(win_rect->right/STATBAR_HELP_RATIO)
            -HORIZONTAL_STATUSBAR_BORDER+(int)(((win_rect->right
            - ((win_rect->right/STATBAR_HELP_RATIO)
            -HORIZONTAL_STATUSBAR_BORDER+5)) - 6) / 2);
         rect.bottom = win_rect->bottom+height-3;
         break;

      case THIRD_STATUS_BAR_BOX:
         rect.left   = (int)(win_rect->right/STATBAR_HELP_RATIO)
            -HORIZONTAL_STATUSBAR_BORDER+5+(int)(((win_rect->right
            - ((win_rect->right/STATBAR_HELP_RATIO)
            -HORIZONTAL_STATUSBAR_BORDER+5)) - 6) / 2);
         rect.top    = win_rect->bottom + 2;
         rect.right  = (int)(win_rect->right/STATBAR_HELP_RATIO)
            -HORIZONTAL_STATUSBAR_BORDER+2*(int)(((win_rect->right
            - ((win_rect->right/STATBAR_HELP_RATIO)
            -HORIZONTAL_STATUSBAR_BORDER+5)) - 6) / 2);
         rect.bottom = win_rect->bottom+height-3;
         break;
      }

   return rect;
   }

void draw_status_box(HDC hdc, RECT *rect, int box, int height)
   {
   RECT draw_rect;
   HPEN hOldPen;
   HPEN hPenGray = CreatePen(PS_SOLID, 1, GRAY);

   draw_rect = get_status_bar_coordinates(rect, box, height);

   hOldPen = SelectObject(hdc, hPenGray);

   draw_line(hdc, draw_rect.left, draw_rect.top, draw_rect.right,
      draw_rect.top);
   draw_line(hdc, draw_rect.left, draw_rect.top, draw_rect.left,
      draw_rect.bottom);

   SelectObject(hdc, GetStockObject(WHITE_PEN));

   draw_line(hdc, draw_rect.left, draw_rect.bottom, draw_rect.right,
      draw_rect.bottom);
   draw_line(hdc, draw_rect.right, draw_rect.top, draw_rect.right,
      draw_rect.bottom+1);

   SelectObject(hdc, hOldPen);
   DeleteObject(hPenGray);
   }

