##############################################################################
#                                                                            #
# WinSets, Copyright (C) Guy Eddon, 1993                                     #
#                                                                            #
# WINSETS.MAK - This file maintains the WinSets project.                     #
#                                                                            #
##############################################################################

!include <ntwin32.mak>

all: winsets.exe winsets.hlp

winsets.exe : winsets.obj winsets.def winsets.rbj sprites.obj misc.obj \
        cards.obj statbar.obj messages.obj menu.obj popup.obj
     $(link) $(guiflags) -out:winsets.exe \
        winsets.obj sprites.obj messages.obj popup.obj menu.obj cards.obj \
        misc.obj statbar.obj winsets.rbj $(guilibs)

winsets.rbj: winsets.res
    cvtres -$(CPU) winsets.res -o winsets.rbj

winsets.res : winsets.rc winsets.h red.bmp pink.bmp blue.bmp green.bmp \
        yellow.bmp gray.bmp winsets.ico holder.bmp
     rc -r winsets.rc

winsets.obj : winsets.c winsets.h
     $(cc) $(cflags) $(cvars) winsets.c

messages.obj : messages.c winsets.h
     $(cc) $(cflags) $(cvars) messages.c

popup.obj : popup.c winsets.h
     $(cc) $(cflags) $(cvars) popup.c

menu.obj : menu.c winsets.h
     $(cc) $(cflags) $(cvars) menu.c

misc.obj : misc.c winsets.h
     $(cc) $(cflags) $(cvars) misc.c

statbar.obj : statbar.c winsets.h
     $(cc) $(cflags) $(cvars) statbar.c

sprites.obj : sprites.c winsets.h
     $(cc) $(cflags) $(cvars) sprites.c

cards.obj : cards.c winsets.h
     $(cc) $(cflags) $(cvars) cards.c

winsets.hlp : winsets.rtf winsets.hpj
     hc winsets

