/****************************************************************************\
*                                                                            *
* Figure 10                                                                  *
*                                                                            *
* WinSets, Copyright (C) Guy Eddon, 1993                                     *
*                                                                            *
* WINSETS.C - The main module; creates and manages the window and dialogs.   *
*                                                                            *
\****************************************************************************/

#include "winsets.h"

// Some globals...
int    current_score = 0;
int    time_left = -1;
int    num_moves_left;
int    status_bar_height;
char   fqfn[2*NORMAL_BUFFER];
char   szAppName[] = "WinSets";
RECT   global_win_rect;
BOOL   sound_flag;
BOOL   status_bar_flag;
DWORD  dwFlags;
SPRITE *global_last_ball_moved;

// WinSets starts here!
int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
   LPSTR lpszCmdParam, int nCmdShow)
   {
   MSG         msg;
   WNDCLASS    wndclass;
   HACCEL      hAccel;
   HWND        hwnd;

   // If first instance...
   if(!hPrevInstance)
      {
      wndclass.style         = CS_HREDRAW|CS_VREDRAW|CS_BYTEALIGNWINDOW;
      wndclass.lpfnWndProc   = WndProc;
      wndclass.cbClsExtra    = 0;
      wndclass.cbWndExtra    = 0;
      wndclass.hInstance     = hInstance;
      wndclass.hIcon         = LoadIcon(hInstance, szAppName);
      wndclass.hCursor       = LoadCursor(NULL, IDC_ARROW);
      wndclass.hbrBackground = CreateSolidBrush(DK_GREEN);
      wndclass.lpszMenuName  = szAppName;
      wndclass.lpszClassName = szAppName;

      // Register the main window class
      RegisterClass(&wndclass);
      }

#ifndef WIN32
   // For later use in determining the speed of ball animations
   dwFlags = GetWinFlags();
#endif

   // For later use in reading and writing the INI file
   GetModuleFileName(hInstance, fqfn, sizeof(fqfn));
   fqfn[strlen(fqfn)-1] = 'I';
   fqfn[strlen(fqfn)-2] = 'N';
   fqfn[strlen(fqfn)-3] = 'I';

   // Load the accelerators
   hAccel = LoadAccelerators(hInstance, szAppName);

   // Create the main window with default values
   hwnd = CreateWindow(szAppName,               // window class name
                       szAppName,               // window caption
                       WS_OVERLAPPEDWINDOW,     // window style
                       CW_USEDEFAULT,           // initial x position
                       CW_USEDEFAULT,           // initial y position
                       CW_USEDEFAULT,           // initial x size
                       CW_USEDEFAULT,           // initial y size
                       NULL,                    // parent window handle
                       NULL,                    // window menu handle
                       hInstance,               // program instance handle
                       NULL);                   // creation parameters

   // Get the window up there
   ShowWindow(hwnd, nCmdShow);
   UpdateWindow(hwnd);

   // A simple message loop...
   while(GetMessage (&msg, NULL, 0, 0))
      if(!TranslateAccelerator(hwnd, hAccel, &msg))
         {
         TranslateMessage(&msg);
         DispatchMessage(&msg);
         }

   return msg.wParam;
   }

// Callback for the about box
BOOL CALLBACK AboutDlgProc(HWND hDlg, UINT message, WPARAM wParam,
   LPARAM lParam)
   {
   switch (message)
      {
      case WM_INITDIALOG:
         return winsets_initdialog(hDlg);

      case WM_COMMAND:
         switch(wParam)
            {
            case IDOK:
            case IDCANCEL:
               EndDialog(hDlg, FALSE);
               return TRUE;
            }
         break;
      }
   return FALSE;
   }

// Callback for the scoring box
BOOL CALLBACK ScoreDlgProc(HWND hDlg, UINT message, WPARAM wParam,
   LPARAM lParam)
   {
   HDC hdc;
   static BOOL ok_to_exit = FALSE;
   static BOOL kill_focus = FALSE;
   static int bonus;
   char edit_buffer[NORMAL_BUFFER];

   switch (message)
      {
      case WM_INITDIALOG:
         {
         RECT dlg_rect;
         POINT point;
         int save_dlg_rect_top;

         kill_focus = FALSE;

         KillTimer(GetWindow(hDlg, GW_OWNER), (UINT)NULL);
         SetTimer(hDlg, (UINT)NULL, 50, NULL);

         bonus = num_moves_left*BONUS_FOR_MOVES_LEFT;

         wsprintf(edit_buffer, "%d", current_score);
         SetDlgItemText(hDlg, SCORE_CONTROL, edit_buffer);
         wsprintf(edit_buffer, "%d", time_left+1);
         SetDlgItemText(hDlg, TIME_CONTROL, edit_buffer);
         wsprintf(edit_buffer, "%d", bonus);
         SetDlgItemText(hDlg, BONUS_CONTROL, edit_buffer);

         GetWindowRect(GetDlgItem(hDlg, SCORE_GROUPBOX), &dlg_rect);
         point.x = dlg_rect.left;
         point.y = dlg_rect.top;
         ScreenToClient(hDlg, &point);
         dlg_rect.left = point.x;
         dlg_rect.top = point.y;

         point.x = dlg_rect.right;
         point.y = dlg_rect.bottom;
         ScreenToClient(hDlg, &point);
         dlg_rect.right = point.x;
         dlg_rect.bottom = point.y;

         save_dlg_rect_top = dlg_rect.top;

         dlg_rect.top = dlg_rect.bottom +
            ((dlg_rect.bottom-save_dlg_rect_top) / 5);
         dlg_rect.bottom = dlg_rect.top +
            ((dlg_rect.bottom-save_dlg_rect_top) / 4);

         Meter(hDlg, NULL, &dlg_rect, time_left+1, METER_INIT);

         return winsets_initdialog(hDlg);
         }

      case WM_TIMER:
         if((time_left+1) > 0)
            {
            time_left--;
            current_score++;

            wsprintf(edit_buffer, "%d", current_score);
            SetDlgItemText(hDlg, TOTAL_CONTROL, edit_buffer);

            Meter(hDlg, NULL, NULL, time_left+1, METER_FILL);
            }
         else
            {
            if(ok_to_exit == FALSE)
               {
               ok_to_exit = TRUE;

               current_score += bonus;

               wsprintf(edit_buffer, "%d", current_score);
               SetDlgItemText(hDlg, TOTAL_CONTROL, edit_buffer);

               EnableWindow(GetDlgItem(hDlg, IDOK), TRUE);
               if(kill_focus == FALSE)
                  SetFocus(GetDlgItem(hDlg, IDOK));

               hdc = GetDC(GetWindow(hDlg, GW_OWNER));

               fill_status_bar(hdc, time_left+1, &global_win_rect,
                  status_bar_height, FALSE, TIME_BOX);
               fill_status_bar(hdc, current_score, &global_win_rect,
                  status_bar_height, FALSE, SCORE_BOX);

               ReleaseDC(GetWindow(hDlg, GW_OWNER), hdc);
               }
            }
         return 0;

      case WM_SETFOCUS:
         SetFocus(GetDlgItem(hDlg, IDOK));
         kill_focus = FALSE;
         return 0;

      case WM_KILLFOCUS:
         kill_focus = TRUE;
         return 0;

      case WM_PAINT:
         {
         PAINTSTRUCT ps;
         hdc = BeginPaint(hDlg, &ps);

         Meter(hDlg, hdc, NULL, time_left+1, METER_PAINT);

         EndPaint(hDlg, &ps);
         }
         return 0;

      case WM_COMMAND:
         switch(wParam)
            {
            case IDOK:
            case IDCANCEL:
               if(ok_to_exit == TRUE)
                  {
                  KillTimer(hDlg, (UINT)NULL);
                  SetTimer(GetWindow(hDlg, GW_OWNER), (UINT)NULL, 1000,
                     NULL);

                  ok_to_exit = FALSE;
                  kill_focus = FALSE;

                  EndDialog(hDlg, FALSE);
                  return TRUE;
                  }
               return FALSE;
            }
         break;
      }
   return FALSE;
   }

// Callback for the main window
LRESULT CALLBACK WndProc(HWND hwnd, UINT message, WPARAM wParam,
   LPARAM lParam)
   {
// In case we need the window instance later...
#ifdef WIN32
   const HINSTANCE ghInst = (HINSTANCE)GetWindowLong(hwnd, GWL_HINSTANCE);
#else
   const HINSTANCE ghInst = GetWindowWord(hwnd, GWW_HINSTANCE);
#endif

   // For use with the status bar help lines...
   const HMENU          hMainMenu = GetMenu(hwnd);
   const HMENU          hGameMenu = GetSubMenu(hMainMenu, 0);
   const HMENU          hViewMenu = GetSubMenu(hMainMenu, 1);
   const HMENU          hHelpMenu = GetSubMenu(hMainMenu, 2);

   // A few statics...
   static HBRUSH        hGrayBrush;
   static HBRUSH        hHolderBrush;
   static BOOL          sizing = FALSE;
   static BOOL          paint_status_bar = FALSE;
   static BOOL          paint_cards = FALSE;
   static BOOL          has_box_been_up;
   static BOOL          new_game_flag = TRUE;
   static BOOL          paint_reverse_card = TRUE;
   static int           ball_rad;
   static int           ball_diam;
   static int           ledge;
   static int           num_circles;
   static int           nMenuID = FALSE;
   static char          selected_card = (char)NULL;
   static char          global_card_array_count;
   static char          card_array[FIVE_CARD_GAME];
   static float         x_ellipse_factor;
   static float         y_ellipse_factor;
   static unsigned      radius;
   static current_cards visible;

   // Handle these messages...
   switch(message)
      {
      case WM_CREATE:
         return winsets_create(hwnd, &num_circles, &visible, &hGrayBrush,
            ghInst, &global_card_array_count, card_array, &hHolderBrush,
            &x_ellipse_factor, &y_ellipse_factor,
            &sound_flag, &status_bar_height, &status_bar_flag);

      case WM_GETMINMAXINFO:
         return winsets_getminmaxinfo(lParam);

      case WM_TIMER:
         return winsets_timer(hwnd, &global_win_rect, &time_left);

      case WM_ENTERIDLE:
         return winsets_enteridle(hwnd, &global_win_rect, nMenuID,
            &paint_status_bar, ghInst);

      case WM_MENUSELECT:
         return winsets_menuselect(hwnd, lParam, wParam, &global_win_rect,
            hGameMenu, hHelpMenu, hViewMenu, &paint_status_bar, &nMenuID,
            num_moves_left, ghInst);

      case WM_SIZE:
         return winsets_size(hwnd, &global_win_rect, &sizing, &radius,
            &ledge, &ball_rad, &ball_diam, num_circles, x_ellipse_factor,
            y_ellipse_factor);

      case WM_COMMAND:
         return winsets_command(hwnd, wParam, &selected_card, &num_circles,
            ball_rad, radius, ledge, &x_ellipse_factor, &y_ellipse_factor,
            &visible, &paint_cards, &num_moves_left, &sizing,
            hMainMenu, hViewMenu, ghInst, &global_card_array_count,
            card_array, &time_left, &current_score, &new_game_flag,
            &sound_flag, &global_win_rect, &paint_reverse_card);

      case WM_PAINT:
         return winsets_paint(hwnd, &global_win_rect, ball_diam, ledge,
            hGrayBrush, num_moves_left, x_ellipse_factor,
            y_ellipse_factor, num_circles, &visible, radius, ball_rad,
            selected_card, &sizing, ghInst, time_left, current_score,
            paint_cards, hHolderBrush, new_game_flag, paint_reverse_card);

      case WM_LBUTTONDOWN:
         return winsets_lbuttondown(hwnd, lParam, &global_win_rect,
            ball_diam, ledge, &paint_cards, num_circles, &num_moves_left,
            &visible, &selected_card, ghInst, &global_card_array_count,
            card_array, &current_score, &time_left, &has_box_been_up,
            ball_rad, radius, x_ellipse_factor, y_ellipse_factor,
            &new_game_flag, hMainMenu, &paint_reverse_card);

      case WM_MOUSEMOVE:
         return winsets_mousemove(hwnd, lParam, &global_win_rect,
            num_circles);

      case WM_LBUTTONUP:
         return winsets_lbuttonup(hwnd, lParam, &num_moves_left, num_circles,
            ball_rad, radius, ledge, &selected_card, &global_win_rect,
            x_ellipse_factor, y_ellipse_factor, &visible, ball_diam,
            ghInst, &global_card_array_count, card_array, &current_score,
            &has_box_been_up, hMainMenu, &sizing,
            &paint_cards, &time_left, &new_game_flag, &paint_reverse_card,
            hGrayBrush);

      case WM_KEYDOWN:
         return winsets_keydown(hwnd, wParam, ball_rad, radius, num_circles,
            ledge, x_ellipse_factor, y_ellipse_factor, &global_win_rect,
            ball_diam, selected_card);

      case WM_SETFOCUS:
         return winsets_setfocus();

      case WM_KILLFOCUS:
         return winsets_killfocus();

      case WM_CLOSE:
         return winsets_close(hwnd, hGrayBrush, hHolderBrush);

      case WM_DESTROY:
         return winsets_destroy(hwnd);
      }

   // Return the message to DefWindowProc
   return DefWindowProc(hwnd, message, wParam, lParam);
   }

