/****************************************************************************\
*                                                                            *
* Figure 14                                                                  *
*                                                                            *
* WinSets, Copyright (C) Guy Eddon, 1993                                     *
*                                                                            *
* WINSETS.H - This file contains the WinSets definitions and declarations.   *
*                                                                            *
\****************************************************************************/

// Some header files...
#include <WINDOWS.H>

#ifndef RC_INVOKED
#include <MATH.H>
#include <STRING.H>
#include <TIME.H>
#include <STDLIB.H>
#include <STDIO.H>
#endif

/* System */
#define IDM_SYSMENU       999

/* Misc */
#define IDM_MOVES_LEFT    998

/* Game */
#define IDM_GAME          99
#define IDM_NEW           100
#define IDM_UNDO          101
#define IDM_FOUR          102
#define IDM_FIVE          103
#define IDM_EXIT          104

/* Options */
#define IDM_OPTIONS       299
#define IDM_SOUND         303
#define IDM_STATUS_BAR    304

/* Help */
#define IDM_HELP          199
#define IDM_CONTENTS      200
#define IDM_SEARCH        201
#define IDM_HELP_ON_HELP  202
#define IDM_ABOUT         203

#define HELP_TITLE           1000
#define CLICK_NO_MOVES_LEFT  1001
#define CLICK_SELECT_BALL    1002
#define CLICK_SELECT_CARD    1003
#define CLICK_REMEMBER_RULES 1004

#define SCORE_CONTROL     100
#define TIME_CONTROL      101
#define SCORE_GROUPBOX    102
#define BONUS_CONTROL     103
#define TOTAL_CONTROL     104

#define BONUS_FOR_MOVES_LEFT 1000

#define BLUE              RGB(0, 0, 255)
#define BLACK             RGB(0, 0, 0)
#define WHITE             RGB(255, 255, 255)
#define PINK              RGB(255, 0, 255)
#define GREEN             RGB(0, 255, 0)
#define DK_GREEN          RGB(0, 128, 0)
#define YELLOW            RGB(255, 255, 0)
#define RED               RGB(255, 0, 0)
#define GRAY              RGB(128, 128, 128)
#define LT_GRAY           RGB(192, 192, 192)

#define CARD_BALLS_TALL             5
#define PI                          3.14159
#define NUM_CARDS                   3
#define NO_HOLE                     1000
#define MAX_BALLS                   10
#define DUMMY                       100
#define FIVE_CARD_GAME              52
#define FOUR_CARD_GAME              30
#define HIGHLIGHT_BORDER            13
#define NORMAL_BUFFER               128
#define SECONDS_TO_FINISH           60
#define STATBAR_HELP_RATIO          1.5
#define HORIZONTAL_STATUSBAR_BORDER 10
#define PERSPECTIVE_SHADING         0.035
#define BALL_ELLIPSE_FACTOR         0.08
#define PERSPECTIVE_BALL_VIEW       1.75
#define X_MINIMUM_WINDOW_SIZE       425
#define Y_MINIMUM_WINDOW_SIZE       275

#define FIRST_STATUS_BAR_BOX        1
#define SECOND_STATUS_BAR_BOX       2
#define THIRD_STATUS_BAR_BOX        3
#define TIME_BOX                    SECOND_STATUS_BAR_BOX
#define SCORE_BOX                   THIRD_STATUS_BAR_BOX

#define SCORE_FINISHED_CARD         100

#define METER_INIT                  0
#define METER_FILL                  1
#define METER_PAINT                 2

// PTINRECT - a faster PtInRect
#define PTINRECT(r,p) \
(((r)->left <= (p).x) && ((r)->right > (p).x) && \
((r)->top <= (p).y) && ((r)->bottom > (p).y))

// INTRECT - a faster IntersectRect that just returns the condition
#define INTRECT(r1,r2) \
(((r1)->right >= (r2)->left) && \
((r1)->left < (r2)->right) && \
((r1)->bottom >= (r2)->top) && \
((r1)->top < (r2)->bottom))

typedef struct
   {
   int     current_hole;  // Current hole
   int     previous_hole; // Previous hole
   int     xPrev;         // Previous X location
   int     yPrev;         // Previous Y location
   int     bmX;           // Bitmap origin
   int     bmY;           // Bitmap origin
   int     bmWidth;       // Bitmap width
   int     bmHeight;      // Bitmap height
   BOOL    bSelected;     // Is ball selected
   HBITMAP hbmImg_color;  // Original bitmap
   HBITMAP hbmImage;      // Sprite's bitmap
   HBITMAP hbmBkg;        // What's behind our sprite
   } SPRITE;

typedef struct
   {
   int one_card;
   int two_card;
   int thr_card;
   BOOL one_card_finished;
   BOOL two_card_finished;
   BOOL thr_card_finished;
   } current_cards;

/* WINSETS.C */
extern SPRITE *global_last_ball_moved;
extern DWORD  dwFlags;
extern BOOL   sound_flag;
extern BOOL   status_bar_flag;
extern RECT   global_win_rect;
extern char   fqfn[2*NORMAL_BUFFER];
extern char   szAppName[];
extern int    status_bar_height;

/* CARDS.C */
extern const char win_four[30][8];
extern const char win_five[52][10];

/* SPRITES.C */
extern SPRITE ball_pink;
extern SPRITE ball_red;
extern SPRITE ball_green;
extern SPRITE ball_blue;
extern SPRITE ball_yellow;

/* WINSETS.C */
BOOL CALLBACK ScoreDlgProc(HWND hDlg, UINT message, WPARAM wParam,
        LPARAM lParam);
BOOL CALLBACK AboutDlgProc(HWND hDlg, UINT message, WPARAM wParam,
        LPARAM lParam);
LRESULT CALLBACK WndProc(HWND hwnd, UINT message, WPARAM wParam,
        LPARAM lParam);

void alphabetize_token(char tokens[CARD_BALLS_TALL+1][CARD_BALLS_TALL+1]);
void alphabetize_entire_token(
   char tokens[CARD_BALLS_TALL+1][CARD_BALLS_TALL+1]);

/* MISC.C */
BOOL is_ball_in_hole(HWND hwnd, int hole_number, POINT *point, int ball_rad,
        unsigned radius, int num_circles, int ledge, SPRITE *ball_color,
        float x_ellipse_factor, float y_ellipse_factor, RECT *win_rect);
BOOL is_a_ball_in_this_hole(int hole_number, int num_circles);
BOOL is_point_in_hole(HWND hwnd, int hole_number, POINT *point, int ball_rad,
        unsigned radius, int num_circles, int ledge, float x_ellipse_factor,
        float y_ellipse_factor);
BOOL drop_ball(HWND hwnd, POINT *point, int ball_rad, unsigned radius,
        int num_circles, int ledge, SPRITE *ball_color, char *selected_card,
        current_cards *visible, RECT *rect, int ball_diam,
        float x_ellipse_factor, float y_ellipse_factor, int *current_score,
        int num_moves_left, HMENU hMainMenu);
BOOL compare_tokens(char card_tokens[CARD_BALLS_TALL+1][CARD_BALLS_TALL+1],
        char bowl_tokens[CARD_BALLS_TALL+1][CARD_BALLS_TALL+1]);
BOOL compare_card_to_balls(const char *card_string, char *bowl_string);
void alphabetize_string(char *string);
void random_seed(void);
void draw_line(HDC hdc, int x1, int y1, int x2, int y2);
void draw_ball(HDC hdc, int ball_rad, int x, int y);
void make_string_from_bowl(char *return_string, int num_circles);
void display_moves_left(HDC hdc, RECT *rect, int num_moves_left,
        BOOL repaint_flag, HINSTANCE ghInst);
void get_hole_coord(int hole, int ball_rad, unsigned radius, int num_circles,
        int ledge, float x_ellipse_factor, float y_ellipse_factor,
        POINT *pt);
void draw_holes(HDC hdc, HBRUSH hbr_color, int num_circles, int ball_rad,
        unsigned radius, int ledge, float x_ellipse_factor,
        float y_ellipse_factor);
void tokenize_string(const char *string,
        char tokens[CARD_BALLS_TALL+1][CARD_BALLS_TALL+1],
        BOOL card_configuration);
void initialize_ball(SPRITE *ball_color, BOOL start_flag, int num_circles);
void new_game(char *global_card_array_count, char *card_array);
void transform_coord(POINT *point, unsigned radius, float x_ellipse_factor,
        float y_ellipse_factor, int ball_rad);
void Meter(HWND hwnd, HDC hdc, RECT *meter_rect, int time_left,
        int meter_flag);
int random_number(int max);
int num_chr_in_str(const char *string, char locate);
int get_random_card(int max, char *global_card_array_count,
       char *card_array);
int randomize_ball(int num_circles, BOOL start_flag);

/* CARDS.C */
BOOL clicked_on_reverse_card(int x, int y, int ball_diam, int ledge,
        RECT *rect);
void get_reverse_card_coord(RECT *rect, int ball_diam, int ledge,
        RECT *card_rect);
void get_card_coord(int card_number, RECT *rect, int ball_diam, int ledge,
        RECT *card_rect);
void draw_reverse_card(HDC hdc, RECT *rect, int ball_diam, int ledge,
        HBRUSH hGrayBrush);
void draw_card_finished(HWND hwnd, RECT *win_rect, int previous_card,
        int ball_diam, int edge_ledge, current_cards *visible);
void do_card_complete(HWND hwnd, char *current_card, int num_circles,
        current_cards *visible, RECT *rect, int ball_diam, int edge_ledge,
        int *current_score, int num_moves_left, HMENU hMainMenu);
void draw_card_highlight(HWND hwnd, int new_card, RECT *win_rect,
        int ball_diam, int edge_ledge);
void draw_card_unhighlight(HWND hwnd, RECT *win_rect, int previous_card,
        int ball_diam, int edge_ledge);
void draw_cards(HDC hdc, RECT *rect, int ball_diam, int ledge,
        HBRUSH hBrush);
void draw_card(HDC hdc, RECT *rect, int ball_diam, int ledge, int card_num);
void draw_card_configuration(PAINTSTRUCT *ps, HDC hdc, int card_number,
        const char *configuration, RECT *rect, int ball_diam, int ledge,
        int num_circles);
void draw_balls_on_card(HDC hdc, RECT *card_rect, const char *configuration,
        int ball_rad, int num_circles);
void plot_ball(HDC hdc, const char char_color, int current_ball_in_token,
        int token_length, RECT *card_rect, int ball_rad, int current_token,
        int number_of_tokens, int num_circles);
void draw_reverse_card_inverted(HDC hdc, RECT *rect, int ball_diam,
        int ledge);
int is_card_selected(int x, int y, RECT *card_rect);

/* SPRITES.C */
void InitSpriteInfo(HDC hdc, HBITMAP hbm, int ball_rad, unsigned radius,
        int num_circles, int ledge, SPRITE *ball_color,
        float x_ellipse_factor, float y_ellipse_factor);
void FinishSpriteAnimation(HWND hWnd, int hole_number, int ball_rad,
        unsigned radius, int num_circles, int ledge, SPRITE *ball_color,
        POINT *point, float x_ellipse_factor, float y_ellipse_factor,
        RECT *win_rect, BOOL make_noise_flag, BOOL speed_flag);
void DeleteSprite(SPRITE *ball_color);
void GetSprite(HDC hdc, SPRITE *ball_color);
void DrawSprite(HDC hdc, SPRITE *ball_color);
void AnimateSprite(HWND hWnd, SPRITE *ball_color, int ball_rad,
        unsigned radius, int num_circles, int ledge, float x_ellipse_factor,
        float y_ellipse_factor, RECT *win_rect);
void BeginSpriteAnimation(HWND, int, int, SPRITE *ball_color);
void MoveSprite(HWND, int, int, SPRITE *ball_color, RECT *win_rect);
BOOL IsSpriteSelected(int, int, SPRITE *ball_color, int ball_rad);

/* STATBAR.C */
RECT get_status_bar_coordinates(RECT *win_rect, int box, int height);
void draw_status_bar_text(HDC hdc, char *menu_buffer, RECT *rect, int height,
        BOOL repaint_flag, int box);
void draw_status_bar(HDC hdc, RECT *rect, int height, BOOL repaint_flag,
        int box);
void draw_status_box(HDC hdc, RECT *rect, int box, int height);
void fill_status_bar(HDC hdc, int value, RECT *rect, int height,
        BOOL repaint_flag, int box);

/* MESSAGES.C */
BOOL winsets_close(HWND hwnd, HBRUSH hGrayBrush, HBRUSH hHolderBrush);
BOOL winsets_destroy(HWND hwnd);
BOOL winsets_setfocus(void);
BOOL winsets_killfocus(void);
BOOL winsets_keydown(HWND hwnd, WPARAM wParam, int ball_rad, unsigned radius,
        int num_circles, int ledge, float x_ellipse_factor,
        float y_ellipse_factor, RECT *rect, int ball_diam,
        char selected_card);
BOOL winsets_lbuttonup(HWND hwnd, LPARAM lParam, int *num_moves_left,
        int num_circles, int ball_rad, int radius, int ledge,
        char *selected_card, RECT *rect, float x_ellipse_factor,
        float y_ellipse_factor, current_cards *visible,
        int ball_diam, HINSTANCE ghInst, char *global_card_array_count,
        char *card_array, int *current_score, BOOL *has_box_been_up,
        HMENU hMainMenu, BOOL *sizing,
        BOOL *paint_cards, int *time_left, BOOL *new_game_flag,
        BOOL *paint_reverse_card, HBRUSH hGrayBrush);
BOOL winsets_mousemove(HWND hwnd, LPARAM lParam, RECT *rect,
        int num_circles);
BOOL winsets_lbuttondown(HWND hwnd, LPARAM lParam, RECT *rect, int ball_diam,
        int ledge, BOOL *paint_cards, int num_circles, int *num_moves_left,
        current_cards *visible, char *selected_card, HINSTANCE ghInst,
        char *global_card_array_count, char *card_array, int *current_score,
        int *time_left, BOOL *has_box_been_up, int ball_rad, unsigned radius,
        float x_ellipse_factor, float y_ellipse_factor,
        BOOL *new_game_flag, HMENU hMainMenu,
        BOOL *paint_reverse_card);
BOOL winsets_paint(HWND hwnd, RECT *rect, int ball_diam, int ledge,
        HBRUSH hGrayBrush, int num_moves_left, float x_ellipse_factor,
        float y_ellipse_factor, int num_circles, current_cards *visible,
        int radius, int ball_rad, char selected_card, BOOL *sizing,
        HINSTANCE ghInst, int time_left, int current_score, BOOL paint_cards,
        HBRUSH hHolderBrush, BOOL new_game_flag, BOOL paint_reverse_card);
BOOL winsets_command(HWND hwnd, WPARAM wParam, char *selected_card,
        int *num_circles, int ball_rad, int radius, int ledge,
        float *x_ellipse_factor, float *y_ellipse_factor,
        current_cards *visible, BOOL *paint_cards, int *num_moves_left,
        BOOL *sizing, HMENU hMainMenu, HMENU hGameMenu, HINSTANCE ghInst,
        char *global_card_array_count, char *card_array, int *time_left,
        int *current_score, BOOL *new_game_flag,
        BOOL *sound_flag, RECT *win_rect, BOOL *paint_reverse_card);
BOOL winsets_size(HWND hwnd, RECT *rect, BOOL *sizing, unsigned *radius,
        int *ledge, int *ball_rad, int *ball_diam, int num_circles,
        float x_ellipse_factor, float y_ellipse_factor);
BOOL winsets_create(HWND hwnd, int *num_circles, current_cards *visible,
        HBRUSH *hGrayBrush, HINSTANCE ghInst, char *global_card_array_count,
        char *card_array, HBRUSH *hHolderBrush,
        float *x_ellipse_factor, float *y_ellipse_factor,
        BOOL *sound_flag, int *status_bar_height, BOOL *status_bar_flag);
BOOL winsets_menuselect(HWND hwnd, LPARAM lParam, WPARAM wParam, RECT *rect,
        HMENU hGameMenu, HMENU hHelpMenu, HMENU hViewMenu,
        BOOL *paint_status_bar, int *nMenuID, int num_moves_left,
        HINSTANCE ghInst);
BOOL winsets_enteridle(HWND hwnd, RECT *rect, int nMenuID,
        BOOL *paint_status_bar, HINSTANCE ghInst);
BOOL winsets_getminmaxinfo(LPARAM lParam);
BOOL winsets_timer(HWND hwnd, RECT *rect, int *time_left);
BOOL winsets_initdialog(HWND hDlg);

/* MENU.C */
void winsets_command_new(HWND hwnd, int num_circles, char *selected_card,
        int ball_rad, int radius, int ledge, current_cards *visible,
        float x_ellipse_factor, float y_ellipse_factor,
        int *num_moves_left, BOOL *sizing, char *global_card_array_count,
        char *card_array, BOOL *paint_cards, int *time_left,
        int *current_score, BOOL *new_game_flag, HMENU hMainMenu,
        BOOL *paint_reverse_card);
void winsets_command_undo(HWND hwnd, int num_circles, int ball_rad,
        int radius, int ledge, float x_ellipse_factor,
        float y_ellipse_factor, int *num_moves_left,
        HINSTANCE ghInst, HMENU hMainMenu, RECT *win_rect);
void winsets_command_four(HWND hwnd, int *num_circles, char *selected_card,
        int ball_rad, int radius, int ledge, current_cards *visible,
        float x_ellipse_factor, float y_ellipse_factor,
        int *num_moves_left, BOOL *sizing, BOOL *paint_cards,
        HMENU hMainMenu, HMENU hGameMenu, char *global_card_array_count,
        char *card_array, int *time_left, int *current_score,
        BOOL *new_game_flag, BOOL *paint_reverse_card);
void winsets_command_five(HWND hwnd, int *num_circles, char *selected_card,
        int ball_rad, int radius, int ledge, current_cards *visible,
        float x_ellipse_factor, float y_ellipse_factor,
        int *num_moves_left, BOOL *sizing, BOOL *paint_cards,
        HMENU hMainMenu, HMENU hGameMenu, char *global_card_array_count,
        char *card_array, int *time_left, int *current_score,
        BOOL *new_game_flag, BOOL *paint_reverse_card);
void winsets_command_shape(HWND hwnd, WPARAM wParam, HMENU hMainMenu,
        int ball_rad, int radius, int num_circles, int ledge,
        float *x_ellipse_factor, float *y_ellipse_factor, BOOL *sizing);

