 
        %=============================================================%
        %                                                             %
        %           Mini-lxico de castellano para GFU-LAB            %
        %                                                             %
        %=============================================================%
        
 %-------------------------%
 %     Clases lxicas      %
 %-------------------------%

 CLASS A :                                      % Adjectives
        U/subcat=<>
        U/sem/onto=stat.
 
 CLASS PRO : U/subcat=<>.                       % Personal Pronouns
 
 CLASS N : U/subcat=<>.                         % Nouns
 
 CLASS P :                                      % Prepositions
        U/subcat=<comp>
        U/sem = U/comp/sem.
 
 CLASS ADV : U/subcat=<>.                       % Adverbs

 % Nominal specifiers 
 
 CLASS SPE : 
        U/subcat=<dcomp>                % Los especificadores son ncleos
        U/num=U/dcomp/num               % Concordancia DET-N en gnero y
        U/gn=U/dcomp/gn                 % nmero
        U/sem=U/dcomp/sem.              % equivalencia semntica entre H y C

 % Partitives
 
 CLASS PTV :    
        U/subcat=<comp>      
        U/comp/head=de
        U/comp/comp/num=pl
        U/comp/comp/sem/def=+
        U/gn=U/comp/comp/gn  
        U/sem=U/comp/sem.            

 CLASS DEM (SPE) :                              % Demonstratives
        U/sem/def=+
        U/sem/deixis=prox.

 CLASS VERB :                                   % Main verbs
        U/voice=active
        U/vform=fin
        U/sem/arg1=U/subj/sem.

 CLASS AUX :                                    % Auxiliary verbs
        U/type=aux
        U/vform=fin
        U/voice=active
        U/subcat=<subj xcomp>
        U/xcomp/subj/head=NULL
        U/xcomp/subj/sem=U/subj/sem
        U/sem=U/xcomp/sem.

 CLASS VTR (VERB) :                             % Transitive verbs
        U/subcat=<subj obj>
        U/sem/arg2=U/obj/sem.
         
         %------------------------%                
         %       Templates        %
         %------------------------%

 @MsPl = U/gn=masc  
         U/num=pl.
        
 @MSg = U/gn=masc  
        U/num=sg.
        
 @FSg = U/gn=fem  
        U/num=sg.
        
 @FPl = U/gn=fem  
        U/num=pl.

   %----------------------------%
   %      Entradas lxicas      %
   %----------------------------%
 
 agricultor = N :
        U/head=agricultor
        @MSg
        U/sem/pred=farmer
        U/sem/onto=person.

 algunos = DET (SPE) : 
        U/head=alguno
        @MsPl
        U/sem/quant=exist.

 algunos = DET (PTV) : 
        U/head=alguno
        @MsPl
        U/sem/quant=exist.

 rboles = N :
        U/head=arbol
        @MsPl
        U/sem/pred=tree
        U/sem/onto=plant.

 comprado = V (VTR) : 
     U/head=comprar
     U/vform=prtc
     U/pt=datv
     U/sem/pred=buy
     U/sem/onto=activ 
     U/sem/arg1/onto=hum  
     U/sem/arg2/onto=concr.

 de = P : 
        U/subcat=<comp>
        U/head=de.

 derribado = V (VTR) : 
     U/head=derribar
     U/vform=prtc
     U/pt=datv
     U/sem/pred=pull_down
     U/sem/onto=activ 
     U/sem/arg1/onto=concr  
     U/sem/arg2/onto=concr.

 el  = DET (SPE) : 
        U/head=el
        @MSg
        U/sem/def=+.

 esta  = DET (DEM) : 
        U/head=este
        @FSg.

 ha = V (AUX) :
        U/head=haber
        U/xcomp/vform=prtc
        U/sem/aspect=perfective.

 la  = DET (SPE) : 
        U/head=el
        U/sem/def=+ 
        @FSg.

 los  = DET (SPE) : 
        U/head=el
        U/sem/def=+ 
        @MsPl.

 nuevo = A :
        U/head=nuevo
        @MSg
        U/sem/pred=new.
         
 plant = V (VTR) : 
       U/head=plantar
       U/tns=past
       U/subj/num=sg
       U/pt=ac
       U/sem/pred=plant
       U/sem/onto=fac
       U/sem/arg1/onto=hum
       U/sem/arg2/onto=plant.

 tarde = N :
        U/head=tarde
        @FSg
        U/sem/pred=evening
        U/sem/onto=sectmp.

 tormenta = N :
        U/head=tormenta
        @FSg
        U/sem/pred=storm
        U/sem/onto=fznat.

 tractor = N :
        U/head=tractor
        @MSg
        U/sem/onto=prodart
        U/sem/pred=tractor.

 trigo = N :
        U/head=trigo
        @MSg
        U/sem/onto=plant
        U/sem/pred=wheat.

 un  = DET (SPE) : 
        U/head=un
        U/sem/def=- 
        @MSg.
