/*********************************************************************/
/* Standard Include Files */

#include <dos.h>
#include <dir.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <alloc.h>
#include <bios.h>
#include <io.h>
#include <conio.h>
#include <ctype.h>
#include <fcntl.h>
#include <stdarg.h>
#include <process.h>

/**********************************************************************/
extern char *methods[];
extern char *versions[];
extern char *legal_values[];
/**********************************************************************/
#define VERSION "@?2AU@?C v1.16.04 (Beta) * Universal Archive Utilities * " __DATE__ " * (Public Domain)@?H\n"

/*********************************************************************/
/* Archive types */
/*****************/

enum ARC_TYPE
{
   NONARC,		 // 0
   ARC, 		 // 1
   ARC7,		 // 2
   ARJ, 		 // 3
   DWC, 		 // 4
   HA,			 // 5
   HAP, 		 // 6
   HPK, 		 // 7
   HYP, 		 // 8
   LBR, 		 // 9
   LZE, 		 // 10
   LZH, 		 // 11
   LZS, 		 // 12
   MD,			 // 13
   PAK, 		 // 14
   SQZ, 		 // 15
   ZIP, 		 // 16
   ZOO, 		 // 17

   MAX_TYPES
};

/*********************************************************************/
/* Support defines */
/*******************/
/* define as FALSE the ones you do not want to support, recompile */

#define SUPPORT_ARC TRUE
#define SUPPORT_ARJ TRUE
#define SUPPORT_DWC TRUE
#define SUPPORT_HA	TRUE
#define SUPPORT_HAP TRUE
#define SUPPORT_HPK TRUE
#define SUPPORT_HYP TRUE
#define SUPPORT_LBR TRUE
#define SUPPORT_LZE TRUE
#define SUPPORT_LZH TRUE
#define SUPPORT_LZS TRUE
#define SUPPORT_MD	TRUE
#define SUPPORT_PAK TRUE
#define SUPPORT_SQZ TRUE
#define SUPPORT_ZIP TRUE
#define SUPPORT_ZOO TRUE

#define SUPPORT_SELF TRUE

/*********************************************************************/
/* Defines used in most of the utilities */
/*****************************************/

#define FALSE	   0		 /* To help readability */
#define TRUE	   1

#define BYTE unsigned char

#define FLENGTH    80	   /* Limit on dir+file length */
#define CLENGTH    127	   /* Limit of a command to execute */
#define FILE_PREF  9	   /* File prefix size */
#define FILE_EXT   4	   /* File extension size */
#define FILE_SIZE  13	   /* File Size */
#define DESC_SIZE  150	   /* Max len of description */
#define ENV_SIZE   80	   /* Max environment variable size */
typedef int HANDLE; 	   /* Corresponding to a handle */

#define OFF 	   0x0001
#define ON		   0x0002
#define ALWAYS	   0x0004
#define LAST	   0x0008
#define FIRST	   0x0010
#define BENCH	   0x0020
#define ONLY	   0x0040

#define OPUS 1
#define RBBS 2
#define GT	 3

#define MAX_FLISTS 10

#define READ	   0
#define WRITE	   1
#define READ_WRITE 2
#define APPEND	   3

#define TEMP_DIR "AU94"
#define NOTHING  "Nothing to Do!\n"
#define USING112 "\nWarning: Using version 1.12 .cfg format\n\n"
#define PARAM_HEADING "@?7Command line parameters:\n" "========================\n@?H"

#define EVER ;;

#define Unused(x) (void)x;

#define MAX_ERRORS	 10 	 /* Maximum number of diff errors */

#define CANT_EXECUTE 99

/*********************************************************************/
#define IMAGE_MEMORY 90000L  /* Amount of memory core takes up */

/*********************************************************************/
/* Structures used in most of the utilities */
/********************************************/

typedef struct LIST LIST;
struct LIST
{
   char *data;
   LIST *next;
};

typedef struct LISTPTR LISTPTR;
struct LISTPTR
{
   LIST *head;
   LIST *tail;
};

typedef struct
{
	int year;
	unsigned char month;
	unsigned char day;
} DATE;

typedef struct
{
	char name[120]; 		  /* Long for names on other systems */
	char path[120];
	long packed_size;
	long unpacked_size;
	long crc;
	unsigned char method;	  /* Archive Method for individual file, ie Distill, Implode, etc */
	DATE date;
	unsigned char hour;
	unsigned char min;
	unsigned char sec;
	BYTE encrypted; 		  /* Password encrypted TRUE/FALSE */
} ARC_RECORD;

typedef struct
{
	HANDLE	 file;
	BYTE	 isFirst;
	ARC_TYPE type;
	BYTE	 is_self;
	int 	 version;		   /* Archive version, determination as it proceed */
	long	 pos;
	long	 trailer_pos;	   /* Internal information needed */
	int 	 rec_number;
	int 	 hold_n;		   /* DWC/LBR specific variable to hold number of files */
} ARC_FILE;

#define HEADER_RED	 0	  /* Redirection */
#define HEADER_AT	 1	  /* @ file */
#define HEADER_FILE  2	  /* File */

typedef struct
{
	char *name;
	char extension[4];
	char strict_ext;
	char unarc_partials;
	BYTE crc;
	char *unarc;
	char *arc;
	char *del;
	char *view;
	char *test;
	char *header;
	char *unarc_path;
	char *unarc_no_path;
	char *arc_path;
	char *arc_no_path;
	char *yes_queries;
	char header_method;
	int  memoryNeeded;				/* Memory in K needed to run */
	BYTE break_err; 				/* User aborts errorlevel */
} PACKAGE;

typedef struct
{
	char allow_rename;
	char *curVal;
	char curOpt[30];

	char dirs_only; 				 // Process directories only
	char simulate;					 // Simulation mode
	char show_execute;				 // Show executed commands
	char smart; 					 // Smart Mode
	char pause; 					 // Pause On/Off
	char date_retain;				 // first or last date
	char self_extracts; 			 // Self extractors
	char sub_dirs;					 // Process sub dirs
	char no_extra;					 // No extraneous printing
	char no_disp_dirs;				 // If true, directorys are not printed
	char unarc_paths;				 // Unarc into archive paths
	char retest;					 // Retest suspicious archives
	char recurse;					 // Recursive unarcs
	char delete_behind; 			 // Delete archive after unarcing
	char warn_non_dos;				 // Warn if non dos files names inside archive
	char warn_path; 				 // Warn if path inside archive
	char answer_y;					 // Automated process
	char scan_self; 				 // Scan self extracts
	char cfg_file[FLENGTH]; 		 // Configuration file to use
	int  cfg_line;					 // line number in cfg
	char debug; 					 // debug mode
	char *def_file_spec;			 // Environment variable containing file spec

	char cur_directory[FLENGTH];
	char source_directory[FLENGTH];
	char old_source_dir[FLENGTH];
	char dest_directory[FLENGTH];
	char old_dest_dir[FLENGTH];
	char last_dir[FLENGTH]; 		 // When changes, display dir
	char *argv0;					 // argv[0], used for the .exe path

	char output[FLENGTH];

	char partial[FLENGTH];
	char look_through[FILE_SIZE];

	char will_process[1000][FILE_SIZE];
	LISTPTR dont_touch;
	int  wp_count;

	int  number_processed;
	int  number_changed;

	LISTPTR process_list;

	char flist[MAX_FLISTS][FLENGTH];
	char append_flist[MAX_FLISTS];
	char force_mode;
	char description[DESC_SIZE];
	char desc_file[FILE_SIZE];
	int  flist_pos;
	char flist_log[FLENGTH];
	HANDLE	flist_log_file;

	char problem_log[FLENGTH];
	HANDLE problem_file;

	char action_log[FLENGTH];
	HANDLE action_file;

	PACKAGE package[MAX_TYPES];

	LISTPTR bad_list[MAX_ERRORS];
	int bad_count[MAX_ERRORS];

	char rename_to[FLENGTH];		 // What to rename it to if test fails
	int  quick_test;				 // do quicktest TRUE/FALSE

	int num_processed[20];			 // Used by unarc
	char y_file[80];

	BYTE  colorized;				 // Colorized printouts
	BYTE  current_color;			 // Current Color

	char  scanner[FLENGTH];
	int   SC_NoVirus_EL;			 // No virus errorlevel
	int   SC_Virus_EL;				 // Virus errorlevel
	int   scannerMemNeeded; 		 // Memory needed for the scanner

	long  memStart; 				 // Starting amount of memory left

	char  **env;					 // Points to local environment
	char  env_var[ENV_SIZE];		 // Environment variable for result
	char  env_cont[CLENGTH];		 // value to assign it to

	void   *info;					 // Latch for local structure
} AU;

extern AU *glob_au;

/*********************************************************************/
/* Function Prototypes */
/***********************/

/* Main's */

int main_add(AU *au, int, char *[]);
int main_compare(AU *, int, char *[]);
int main_convert(AU *, int, char *[]);
int main_delete(AU *, int, char *[]);
int main_dir(AU *, int, char *[]);
int main_dupes(AU *, int, char *[]);
int main_find(AU *, int, char *[]);
int main_fixcr(AU *, int, char *[]);
int main_header(AU *, int, char *[]);
int main_orphan(AU *, int, char *[]);
int main_patch(AU *, int, char *[]);
int main_redate(AU *, int, char *[]);
int main_scan(AU *, int, char *[]);
int main_size(AU *, int, char *[]);
int main_strip(AU *, int, char *[]);
int main_sweep(AU *, int, char *[]);
int main_test(AU *au, int, char *[]);
int main_unarc(AU *, int, char *[]);
int main_view(AU *, int, char *[]);
int main_whatis(AU *, int, char *[]);

int unarc(AU *, char *, char *, LISTPTR *, int, BYTE);
int scan_one_file(AU *au, char *);
int test(AU *, char *);
int redate_file(AU *, char *);

void ReadGlobalCFGInfo(AU *, char *, char *, void (*)(AU *, HANDLE, char *, int *));

int control_break(void);
void set_ctrl_brk(void);

/* Util.LIB *********************************************/

typedef enum
{
	PARSE_SINGLE_OPTION,
	PARSE_PARAM_OPTION,
	PARSE_FILESPEC,
	PARSE_POST_CHECK
} PARSE_TYPE;

#define PARSE_PARAMS AU *, char, char *, PARSE_TYPE

void generic_parse_comm_line(AU *, int, char *[], BYTE (*)(PARSE_PARAMS));

ARC_TYPE get_format(AU *, char *, ARC_FILE *);

int arc_file_init(AU *, ARC_FILE *, char *);
void arc_file_deinit(AU *, ARC_FILE *);

int  get_file_line(AU *, HANDLE, char *),
	 get_file_line2(HANDLE, char *),
	 get_file_word(HANDLE, char *),
	 get_record(AU *, ARC_FILE *, ARC_RECORD *),
	 get_value(AU *, unsigned),
	 get_file_int(HANDLE),
	 get_file_string(HANDLE, char *),
	 process_at_file(AU *, LISTPTR *, char *),
	 process_files(AU *, int (*)(AU *, char *)),
	 count_process_files(AU *),
	 ask_continue(void),
	 display_bad_arcs(AU *au),
	 is_dos_name(char *),
	 rename_strict(AU *, PACKAGE *, char *, char *),
	 rename_strict_back(char *, char *),
	 clean_paths(AU *, LISTPTR *),
	 get_next_file_name(AU *, HANDLE, char *, int *);

unsigned short crc16(AU *, char *);
unsigned long  crc32(AU *, char *);

long get_file_long(HANDLE),
	 days_diff(DATE *, DATE *);


void check_for_key(void),
	 press_any_key(AU *au),
	 cd(AU *, char *, char *x=NULL),
	 split_string(char *, char *),
	 append_backslash(char *),
	 add_to_list(AU *, LISTPTR *, char *),
	 destroy_list(LISTPTR *),
	 fix_flist(AU *, char *, char *),
	 add_to_flist(AU *, char *, int),
	 add_to_bad_list(AU *, char *, char *, BYTE errorlevel=0, int level=0),
	 split_file(char *, char *, char *),
	 build_fname(char *, char *, char *),
	 fill_list_from_BBS(AU *, char *),
	 fix_path(char *),
	 get_ns(AU *, ARC_FILE *, LISTPTR *, LISTPTR *, LISTPTR *, LISTPTR *, LISTPTR *),
	 substitute_macros(char *, char *, char *, char *, char *),
	 date_add(DATE *, DATE *, long),
	 get_full_file_name(AU *, char *, char *),
	 au_invalid_option(AU *, char *, char),
	 au_syntax_message(AU *, char *),
	 au_opt_filespec_message(AU *),
	 au_filespec_message(AU *),
	 au_param_heading(AU *),
	 au_standard_opt_header(AU *, char *, char *),
	 au_invalid_cfg_option(AU *, char *, char *, int),
	 subst_environ(AU *, char *),
	 act_log_printf(AU *au, char *format, ...),
	 fdate_to_date(DATE *, struct ffblk *),
	 check_threshold(AU *, int, BYTE);

char ok_to_process(AU *, char *),
	 wildcard_compare(AU *, char *, char *),
	 fill_file_array(char *);

char *left_pad(char *, int),
	 *right_pad(char *, int),
	 *ltrim(char *),
	 *rtrim(char *),
	 *fit_mask(char *,char *),
	 *date_to_string(DATE *),
	 *hms_to_string(int, int, int),
	 *percent_string(long, long),
	 *safe_string_copy(char *, char *, int, BYTE);

HANDLE opencfg(AU *, char *);

void *au_malloc(AU *, int);
void *au_calloc(AU *, int, int);
char *string_save(AU *, char *);

BYTE archive_is_old(int);
BYTE file_is_not_optimal(int);
BYTE file_is_stored(int);
BYTE archive_is_optimal(AU *, char *, ARC_FILE *);
BYTE find_ext(AU *, char *);

/* Ibmdos.LIB ***********************************************/

char   my_getch(),
	   my_toupper(char);


char   *my_itoa(int),
	   *my_ltoa(long),
	   *keyboard_buffer(char *);

HANDLE au_open(AU *, char *, int access = O_RDONLY | O_BINARY);

int    my_getc(HANDLE),
	   my_getc_1(HANDLE),
	   my_atoi(char *),
	   execute(AU *, char *, char *, char *, int),
	   alter_env(AU *, char *, char *[]);

BYTE   is_stdout(void);
BYTE   is_next_control_s(void);

void   reset_buffer_pos(void);

void   my_write(HANDLE,char *),
	   my_putch(char);

void   string_replace(char *, char *, char *);

void   au_printf(AU *, char *, ...);
void   au_printf_c(AU *, char, char *, ...);
void   au_printf_error(AU *, char *, ...);

void   get_file_time(AU *, char *, struct ftime *);
void   set_file_time(AU *, char *, struct ftime *);

long   my_fpos(HANDLE);

