// CONVERT.CPP								 1		  1    6666
// Dave Harris								11		 11   6
// Compiled using Borland C++ ver 3.1	   1 1		1 1   6666
// 03-03-94 								 1	 ..   1   6   6
//										   11111 .. 11111  666
////////////////////////////////////////////////////////////////////////

#include "au.hpp"

#define PROGRAM "CONVERT"  // Name of module
/**************************************************************************/

#define MAX_LEVELS 10

typedef struct
{
	char summary;				   // Disk savings/time summary on/off
	char keep_smallest; 		   // keep the smallest on/off
	char keep_old;				   // keep the old archive ON/OFF/BENCH
	char convert_old;			   // convert old files of same type
	char convert_non_optimal;	   // convert non optimal files of same type
	char convert_regardless;	   // convert regardless.
	char log_filename[FLENGTH];    // log_file
	char log_append;			   // log_append
	char archive_type;			   // type to convert to
	char archive_ext[5];		   // type to convert to extension
	char recurse;				   // recurse on/off
	int  num_convert;			   // convert em all as default
	int  threshold; 			   // If number to convert exceeds, then warn

	char ramdrive[FLENGTH]; 	   // Ram Drive
	long ramdrive_size;

	HANDLE log_file;			   // Log file handle

	char before[FILE_SIZE]; 	   // File Name before it changed

	long savings[MAX_TYPES];
	long e_savings[MAX_TYPES];
	int  b_per_sect;

	LISTPTR execute_before;
	LISTPTR execute_during;
	LISTPTR execute_after;

	long time_spent[MAX_TYPES];
	long start_time;
	long end_time;

	int  archives_not_processed;
	BYTE erase_dest;

	LISTPTR paths[MAX_LEVELS];
} CONVERT_INFO;

static int convert_process(AU *, char *, char *, char *, int);

/**/
static void get_relative_path(char *relative_path, char *sub_path,
							  char *full_path)
{
	int len;
	char sp[FLENGTH];
	char fp[FLENGTH];

	strcpy(sp, sub_path);
	strcpy(fp, full_path);

	append_backslash(sp);
	append_backslash(fp);

	len = strlen(sp);
	if (strnicmp(sp, fp, len) == 0)
		strcpy(relative_path, fp+len);
	else
		strcpy(relative_path, fp);
	return;
}
/**/
static long get_file_size(char *file_name)
{
	struct ffblk ffblk; 		  // directory entry structure
	if (!findfirst(file_name, &ffblk, 0))
		return ffblk.ff_fsize;
	else
		return 0;
}
/**/
static BYTE compare_extensions(char *file1, char *file2)
{
	char *ptr1, *ptr2;

	ptr1 = strchr(file1, '.');
	ptr2 = strchr(file2, '.');
	if (ptr1 == NULL && ptr2 == NULL)
		return TRUE;
	if (ptr1 == NULL && ptr2 != NULL)
		return FALSE;
	if (ptr1 != NULL && ptr2 == NULL)
		return FALSE;
	return (stricmp(ptr1, ptr2) == 0);
}
/**/
static void execute_list(AU *au, char *file_name, LISTPTR *listPtr)
{
	LIST *el;
	char temp[CLENGTH];

	for (el = listPtr->head; el != NULL; el = el->next)
	{
		if (file_name == NULL)
			strcpy(temp, el->data);
		else
			substitute_macros(temp, el->data, NULL, NULL, file_name);
		system(temp);
//		  execute(au, temp, au->output, NULL, 0);
	}
	Unused(au);
	return;
}
/**/
static int convert_one(AU *au, char *sourceDir, char *destDir, LISTPTR *paths,
					   char *file_name, int type, int level)
{
	char	 temp_arc[FLENGTH];
	char	 new_arc[FLENGTH];
	char	 relative_path[FLENGTH];
	char	 temp[CLENGTH];
	char	 exec[CLENGTH];
	char	*ptr;
	int 	 retCode = 0;
	PACKAGE *package;
	LIST	*el;
	long	 old_size, new_size, temp_time1, temp_time2;
	struct	 ftime ftime_hold;
	CONVERT_INFO *in = (CONVERT_INFO *)au->info;

	package = &au->package[type];

	build_fname(temp_arc, sourceDir, "AU94.");
	strcat(temp_arc, package->extension);

	strcpy(temp, file_name);
	ptr = strchr(temp, '.');
	if (ptr != NULL)
		*ptr = '\0';
	build_fname(new_arc, sourceDir, temp);
	strcat(new_arc, ".");
	strcat(new_arc, package->extension);

	substitute_macros(temp, package->arc,
		 au->unarc_paths == ON ? package->arc_path : package->arc_no_path,
		 NULL, temp_arc);

	cd(au, destDir);
	execute_list(au, NULL, &in->execute_during);

	for (el = paths->head; el != NULL; el = el->next)
	{
		get_relative_path(relative_path, destDir, el->data);
		if (relative_path[0] != '\0')
			append_backslash(relative_path);
		sprintf(exec, "%s %s*.*", temp, relative_path);
		if (!au->no_extra)
			au_printf(au, "    @?6Adding @?B%s*.* @?6to @?1%s@?H\n", relative_path, new_arc);
		if (!au->simulate)
		{
			time(&temp_time1);
			retCode = execute(au, exec, au->output, NULL, package->memoryNeeded);
			time(&temp_time2);
			in->time_spent[0] += temp_time2-temp_time1;

			if (retCode != 0)
				break;
		}
	}
	cd(au, sourceDir);
	if (retCode == 0)
	{
		if (au->date_retain == ON)
			get_file_time(au, file_name, &ftime_hold);

		old_size = get_file_size(file_name);
		new_size = get_file_size(temp_arc);

		if (in->keep_smallest == ON)
		{
			if (old_size < new_size)
			{
				unlink(temp_arc);
				return 0;
			}
		}

		if (in->keep_old == OFF || compare_extensions(file_name, new_arc))
			unlink(file_name);							/* Delete old */

		rename(temp_arc, new_arc);	   /* Rename AU94.xxx to file_name.xxx */

		if (au->date_retain == ON)
			set_file_time(au, new_arc, &ftime_hold);
		else if (au->date_retain != OFF)
			redate_file(au, new_arc);

		in->savings[0]+=old_size - new_size;
		in->e_savings[0]+=(old_size+in->b_per_sect-(old_size % in->b_per_sect)) -
						  (new_size+in->b_per_sect-(new_size % in->b_per_sect));

		if (level == 0)
		{
			split_file(new_arc, temp, temp);
			fix_flist(au, file_name, temp);
		}
		execute_list(au, new_arc, &in->execute_after);

	}
	Unused(level);

	return 0;
}
/**/
static int recurse(AU *au, char *path, int level)
{
	struct ffblk ffblk; 		  // directory entry structure
	LISTPTR file_list;
	LIST *el;
	char holdCurDir[FLENGTH];
	char curDir[FLENGTH];
	char destDir[FLENGTH];
	ARC_FILE arcFile;

	cd(au, path, holdCurDir);
	getcwd(curDir, FLENGTH);
	build_fname(destDir, curDir, TEMP_DIR);
	mkdir(TEMP_DIR);

	memset(&file_list, '\0', sizeof(LISTPTR));
	if (!findfirst("*.*", &ffblk, 0))
	{
		do
		{
			add_to_list(au, &file_list, ffblk.ff_name);
		}  while (!findnext(&ffblk));
	}

	for (el = file_list.head; el != NULL; el = el->next)
	{
		 if (convert_process(au, path, destDir, el->data, level) < 0)
			return -1;
	}
	destroy_list(&file_list);
	cd(au, curDir, NULL);
	rmdir(TEMP_DIR);
	cd(au, holdCurDir, NULL);
	return 0;
}
/**/
static int convert_process(AU *au, char *sourceDir, char *destDir,
						   char *file_name, int level)
{
	LIST	 *el;
	int 	 retCode = 0;
	int 	 type;
	int 	 optimal, old;
	ARC_FILE arcFile;
	CONVERT_INFO *in = (CONVERT_INFO *)au->info;

	if (!ok_to_process(au, file_name))
		return 0;

	/***************************************************/
	arc_file_init(au, &arcFile, file_name);
	if (in->archive_type == 0)
		type = arcFile.type;
	else
		type = in->archive_type;

	if (arcFile.type > 0 && arcFile.type == type && in->convert_regardless == OFF)
	{
		optimal = archive_is_optimal(au, file_name, &arcFile);
		arc_file_deinit(au, &arcFile);
		if (optimal < 0)
			return -1;
		old = archive_is_old(arcFile.version);
		if (in->convert_old == OFF)
		{
			in->archives_not_processed++;
			return 0;
		}
		if (!old && (optimal || !in->convert_non_optimal))
		{
			in->archives_not_processed++;
			return 0;
		}
	}
	else
		arc_file_deinit(au, &arcFile);
	if (arcFile.type == 0)
		return 0;
	/***************************************************/

	execute_list(au, file_name, &in->execute_before);

	if (level == 0)
	{
		if (!au->no_extra)
			au_printf(au, "@?6Converting @?1%s@?H\n", file_name);
		act_log_printf(au, "   + CONVERT : %s", file_name);

		au->number_processed++;
	}
	if (!au->self_extracts && arcFile.is_self == TRUE)
		return 0;

	memset(&in->paths[level], '\0', sizeof(LISTPTR));
	if (unarc(au, file_name, destDir, &in->paths[level], 0, FALSE) == TRUE)
	{
		add_to_list(au, &in->paths[level], destDir);
		for (el = in->paths[level].head; el != NULL; el = el->next)
		{
			if (in->recurse == ON && level < MAX_LEVELS-1)
			{
				if (recurse(au, el->data, level+1) != 0)
				{
					retCode = -1;
					break;
				}
			}
		}
		retCode = convert_one(au, sourceDir, destDir, &in->paths[level], file_name, type,
							  level);
	}
	clean_paths(au, &in->paths[level]);
	return retCode;
}
/**/
static int convert(AU *au, char *file_name)
{
	check_for_key();

	return convert_process(au, au->source_directory, au->dest_directory,
						   file_name, 0);
}
/**/
static void ReadCFGInfo(AU *au, HANDLE file, char *cfg_file, int *cfg_line)
{
	char string[200],
		 string2[200],
		 string3[200];
	CONVERT_INFO *in = (CONVERT_INFO *)au->info;

	for(EVER)
	{
		if (get_file_line(au, file, string)==EOF)
			break;

		split_string(string, string2);
		split_string(string, string3);

		if (string2[0] == '\0')
			continue;

		strcpy(au->curOpt, string2);
		au->curVal = string3;
		switch (toupper(string2[1]) << 8 | toupper(string2[0]))
		{
			case 'BE':                                          // Begin
				return;
			case 'AR':                                          // Archive_Type
				if (isdigit(string[0]))
					in->archive_type = atoi(string);
				else
					safe_string_copy(in->archive_ext, string3, 5, FALSE);
				break;
			case 'CO':                                          // Convert_Old
				if (stricmp(string2, "CONVERT_OLD") == 0)
					in->convert_old = get_value(au, OFF | ON);
				else if (stricmp(string2, "CONVERT_NON_OPTIMAL") == 0)                                           // Convert_non
					in->convert_non_optimal = get_value(au, OFF | ON);
				else
					in->convert_regardless = get_value(au, OFF | ON);
				break;
			case 'DA':                                          // Date_Retain
				au->date_retain = get_value(au, OFF | ON | FIRST | LAST);
				break;
			case 'DO':                                          // Dont_process
				add_to_list(au, &au->dont_touch, string3);
				break;
			case 'EX':                                          // Execute
				if (stricmp(string2, "EXECUTE_BEFORE") == 0)
				{
					sprintf(string2, "%s %s", string3, string);
					add_to_list(au, &in->execute_before, string2);
				}
				else if (stricmp(string2, "EXECUTE_DURING") == 0)
				{
					sprintf(string2, "%s %s", string3, string);
					add_to_list(au, &in->execute_during, string2);
				}
				else
				{
					sprintf(string2, "%s %s", string3, string);
					add_to_list(au, &in->execute_after, string2);
				}
			case 'KE':                                          // Keep_old
				if (stricmp(string2,"keep_old") == 0)
					in->keep_old = get_value (au, OFF | ON | BENCH);
				else if (stricmp(string2,"keep_smallest") == 0)
					in->keep_smallest = get_value (au, OFF | ON);
				break;
			case 'LO':                                          // Log_File
				if (stricmp(string3,"+append")==0)
				{
					split_string(string,string3);
					in->log_append = TRUE;
				}
				else
					in->log_append = FALSE;

				if (!strstr(string3,":") && !strstr(string3,"\\"))
				{
					strcpy(in->log_filename, au->cur_directory);
					append_backslash(in->log_filename);
				}
				else
					in->log_filename[0] = '\0';

				strcat(in->log_filename, string3);
				break;
			case 'PA':                                          // Paths
				au->unarc_paths = get_value(au, OFF | ON);
				break;
			case 'RA':                                          // Ram_drive
				strcpy(in->ramdrive, string3);
				break;
			case 'RE':                                          // Recurse
				in->recurse = get_value(au, OFF | ON);
				break;
			case 'SE':                                          // Self_extract
				au->self_extracts = get_value(au, OFF | ON);
				break;
			case 'SU':                                          // Summary
				in->summary = get_value(au, OFF | ON);
				break;
			case 'TH':                                          // Threshold
				in->threshold = atoi(string3);
				break;
			case 'WA':
				if (stricmp(string2, "WARN_NON_DOS")==0)
					au->warn_non_dos = get_value(au, OFF | ON);
				else
					au->warn_path = get_value(au, OFF | ON);
				break;
			case 'WO':                                          // Work_directory
				strcpy(au->dest_directory, string3);
				break;
			default:
				au_invalid_cfg_option(au, string2, cfg_file, *cfg_line);
		}
	}
}
/**/
static BYTE parse_comm_line(AU *au, char option, char *cur_argv,
							PARSE_TYPE type)
{
	CONVERT_INFO *in = (CONVERT_INFO *)au->info;

	switch (type)
	{
	case PARSE_PARAM_OPTION:
		switch (option)
		{
		case 'A':
			in->archive_type = 0;
			in->archive_ext[0] = '\0';
			if (isdigit(cur_argv[0]))
				in->archive_type = atoi(cur_argv);
			else
				safe_string_copy(in->archive_ext, cur_argv, 5, FALSE);
			break;
		case 'D':                 /* Delete behind on/off */
			au->date_retain = get_value(au, OFF | ON | FIRST | LAST);
			break;
		case 'R':                 /* Recursive on/off */
			in->recurse = get_value(au, OFF | ON);
			break;
		case 'U':
			in->summary = get_value(au, OFF | ON);
			break;
		case 'X':
			au->self_extracts = get_value(au, OFF | ON);
			break;
		case 'K':
			if (toupper(*cur_argv) == 'S')
			{
				strcpy(au->curOpt, "-KS");
				au->curVal = cur_argv+1;
				in->keep_smallest = get_value(au, OFF | ON);
			}
			else if (toupper(*cur_argv) == 'O')
			{
				strcpy(au->curOpt, "-KO");
				au->curVal = cur_argv+1;
				in->keep_old = get_value(au, OFF | ON);
			}
			break;
		case 'V':
			if (toupper(*cur_argv) == 'O')
			{
				strcpy(au->curOpt, "-VO");
				au->curVal = cur_argv+1;
				in->convert_old = get_value(au, OFF | ON);
			}
			else if (toupper(*cur_argv) == 'N')
			{
				strcpy(au->curOpt, "-VN");
				au->curVal = cur_argv+1;
				in->convert_non_optimal = get_value(au, OFF | ON);
			}
			else if (toupper(*cur_argv) == 'R')
			{
				strcpy(au->curOpt, "-VR");
				au->curVal = cur_argv+1;
				in->convert_regardless = get_value(au, OFF | ON);
			}
			break;
		case 'P':
			if (toupper(*cur_argv) == 'A')
			{
				strcpy(au->curOpt, "-PA");
				au->curVal = cur_argv+1;
				au->unarc_paths = get_value(au, OFF | ON);
			}
			break;
		case 'N':
			in->num_convert    = atoi(cur_argv);
			break;
		case 'W':
			if (toupper(*cur_argv) == 'P')
			{
				strcpy(au->curOpt, "-WP");
				au->curVal = cur_argv+1;
				au->warn_path = get_value(au, OFF | ON);
			}
			else if (toupper(*cur_argv) == 'N')
			{
				strcpy(au->curOpt, "-WN");
				au->curVal = cur_argv+1;
				au->warn_non_dos = get_value(au, OFF | ON);
			}
			break;
		case 'L':
		   if (cur_argv[0] == '+')
		   {
			  cur_argv++;
			  in->log_append = TRUE;
		   }
		   else
			  in->log_append = FALSE;

		   if (!strstr(cur_argv,":") && !strstr(cur_argv,"\\"))
		   {
			  strcpy(in->log_filename, au->cur_directory);
			  append_backslash(in->log_filename);
		   }
		   else
			  in->log_filename[0] = '\0';

		   strcat(in->log_filename, cur_argv);
		   break;
		case '?':
			au_syntax_message(au, "Convert");
			au_printf(au,
			   "[@?3options@?H] [@?1[src path\\]filespec@?H]\n\n");
			au_param_heading(au);
			au_printf(au,
			   "@?3-A@?Hn                  use Archiving type (number or ext)\n"
			   "@?3-D@?Hon|off|last|first  Date_retain\n"
			   "@?3-R@?Hon|off             Recurse\n"
			   "@?3-KO@?Hon|off            Keep Old archive if of different extension\n"
			   "@?3-KS@?Hon|off            Keep Smallest\n"
			   "@?3-X@?Hon|off             convert self eXtracts\n"
			   "@?3-VO@?Hon|off            convert Old archives of same type\n"
			   "@?3-VN@?Hon|off            convert Non optimal archives of same type\n"
			   "@?3-VR@?Hon|off            convert Regardless\n"
			   "@?3-WP@?Hon|off            Warn if archive contains Paths\n"
			   "@?3-WN@?Hon|off            Warn if archive contains Non-DOS file names\n"
			   "@?3-N@?Hx                  x Number of converts before halting\n"
			   "@?3-U@?Hon|off             sUmmary\n"
			   "@?3-L@?H[+]<File>          Log file\n");
			exit (0);
		default:
			au_invalid_option(au, PROGRAM, option);
		}
		return TRUE;
	case PARSE_POST_CHECK:
		/* Must delay search until whole .cfg is parsed */
		if (in->archive_ext[0] != '\0')
			in->archive_type = find_ext(au, in->archive_ext);
		return TRUE;
	}
	return FALSE;
}
/**/
static void summary(AU *au)
{
	CONVERT_INFO *in = (CONVERT_INFO *)au->info;
	int num_arcs = 1;
	int i;
	int e_mins, e_secs;
	long elapsed_time;

	if (!au->no_extra)
	{
		au_printf(au, "@?7");

		au_printf(au, "\nConversion Summary:\n");
		au_printf(au, "+========+==========+============+==========+\n");
		au_printf(au, "|  Arc   | Savings  | Effective  |   Time   |\n");
		au_printf(au, "| Method | in bytes |  Savings   | Min:Sec  | \n");
		au_printf(au, "+========+==========+============+==========+\n");

		for (i=0; i<num_arcs; i++)
		{
			e_mins = in->time_spent[i]/60;
			e_secs = in->time_spent[i]-e_mins*60;

			au_printf(au, "|  %3s   | ", au->package[in->archive_type].extension);
			au_printf(au, "%8ld | %8ld   |  ", in->savings[i], in->e_savings[i]);
			au_printf(au, "%3d:%02d  |\n", e_mins, e_secs);
			if (i < num_arcs-1)
				au_printf(au, "|--------+----------+------------+----------+\n");
		}
		au_printf(au, "+========+==========+============+==========+\n");
		elapsed_time = in->end_time - in->start_time;
		e_mins = elapsed_time/60;
		e_secs = elapsed_time-e_mins*60;
		au_printf(au, "Total Elapsed time = %d:%02d\n", e_mins, e_secs);
		au_printf(au, "Files Converted = %d\n", au->number_processed);
		if (in->archives_not_processed > 0)
		{
			au_printf(au, "Files that didn't need to be converted = %d\n",
						in->archives_not_processed);
		}
		au_printf(au, "@?G");
	}
}
/**/
static void end_program(void)
{
	CONVERT_INFO *in = (CONVERT_INFO *)glob_au->info;
	int i;

	for (i=MAX_LEVELS-1; i>=0; i--)
	{
		/* Remove any left over paths if dearchive failes */
		clean_paths(glob_au, &in->paths[i]);
	}
	if (in->erase_dest)
	{
		cd(glob_au, glob_au->dest_directory);
		system("echo Y | del *.* >NUL");
		cd(glob_au, glob_au->cur_directory);
		rmdir(glob_au->dest_directory);
	}
	return;
}
/**/
int main_convert(AU *au, int argc, char *argv[])
{
	int   i;
	int   fh;
	CONVERT_INFO *in;
	struct dfree dfree;

	in = (CONVERT_INFO *)au_malloc(au, sizeof(CONVERT_INFO));
	memset(in, '\0', sizeof(CONVERT_INFO));
	au->info = in;
	in->num_convert   = -1;
	in->threshold	  = -1;
	in->archive_type  = 0;
	in->keep_old	  = OFF;
	in->keep_smallest = OFF;

	au->allow_rename = FALSE;
	au->recurse = FALSE;		   /* For Unarc's sake */

	atexit(end_program);

	time(&in->start_time);

	ReadGlobalCFGInfo(au, au->cfg_file, PROGRAM, ReadCFGInfo);
	generic_parse_comm_line(au, argc, argv, parse_comm_line);

	if (au->dest_directory[0] != '\0')
	{
		cd(au, au->dest_directory, au->old_dest_dir);	 /* make sure it exists */
		getcwd(au->dest_directory, FLENGTH);
		cd(au, au->cur_directory);
	}
	else
		build_fname(au->dest_directory, au->cur_directory, TEMP_DIR);

	check_threshold(au, in->threshold, FALSE);

	if (in->archive_type == 0)
	{
		au_printf_c(au, 15, "Files will retain their existing archive type\n");
		if (!ask_continue())
			exit(0);
	}

	getdfree(0, &dfree);
	in->b_per_sect = dfree.df_bsec;

	mkdir(au->dest_directory);
	in->erase_dest = TRUE;
	process_files(au, convert);
	rmdir(au->dest_directory);
	in->erase_dest = FALSE;

	time(&in->end_time);
	if (summary)
		summary(au);

	return 0;
}

