// FIND.CPP 								 1		  1    6666
// Dave Harris								11		 11   6
// Compiled using Borland C++ ver 3.1	   1 1		1 1   6666
// 03-03-94 								 1	 ..   1   6   6
//										   11111 .. 11111  666
////////////////////////////////////////////////////////////////////////

#include "au.hpp"

/*********************************************************************/
/* Define Statements */
/*********************/

#define PROGRAM "FIND"    // Name of module

/*********************************************************************/

typedef struct
{
	char match_pattern[32];
	int  match_regular;
	int  number_matched;
	long number_checked;

	char find_non_dos;
	char find_paths;
	char one_per_archive;
	char quit_after_first;
} FIND_INFO;

/**/
static void find_one(AU *au, char *file_name, ARC_FILE *arcFile)
{
	int ret_code;
	ARC_RECORD record;
	FIND_INFO *in = (FIND_INFO *)au->info;

	au->number_processed++;
	for (;;)
	{
		ret_code = get_record(au, arcFile, &record);
		if (ret_code == EOF)
			break;
		else if (ret_code == -2)
		{
			add_to_bad_list(au, au->source_directory, file_name);
			return;
		}
		in->number_checked++;
		if (wildcard_compare(au, record.name, in->match_pattern))
		{
			if ((in->find_non_dos == 0 ||
				 (in->find_non_dos == ON  && !is_dos_name(record.name)) ||
				 (in->find_non_dos == OFF && is_dos_name(record.name))
				) &&
				(in->find_paths == 0 ||
				 (in->find_paths == ON	&& record.path[0] != '\0') ||
				 (in->find_paths == OFF && record.path[0] == '\0')
				)
			   )
			{
				char string[FLENGTH];
				build_fname(string, au->source_directory, file_name);
				if (in->one_per_archive == ON)
					au_printf(au, "@?1%s@?H\n", string);
				else
					au_printf(au, "@?1%s@?H : @?B%s@?H\n", string, record.name);
				if (in->quit_after_first == ON)
				{
					au->cur_directory[0] = '\0';
					exit(0);
				}
				in->number_matched++;
				if (in->one_per_archive == ON)
					return;
			}
		}
	}
}
/**/
static int find(AU *au, char *file_name)
{
	ARC_FILE arcFile;
	FIND_INFO *in = (FIND_INFO *)au->info;

	check_for_key();

	if ((in->match_regular == ON || in->match_regular == ONLY)
		&& wildcard_compare(au, file_name, in->match_pattern))
	{
		char string[FLENGTH];
		build_fname(string, au->source_directory, file_name);
		au_printf(au, "@?1%s@?H\n", string);
		if (in->quit_after_first == ON)
		{
			au->cur_directory[0] = '\0';
			exit(0);
		}
		in->number_matched++;
	}

	if (in->match_regular != ONLY)
	{
		arc_file_init(au, &arcFile, file_name);
		if (arcFile.type > 0)
			find_one(au, file_name, &arcFile);
		else if (in->match_regular == ON)
			au->number_processed++;
		arc_file_deinit(au, &arcFile);
	}
	return 0;
}
/**/
static BYTE parse_comm_line(AU *au, char option, char *cur_argv,
							PARSE_TYPE type)
{
	FIND_INFO *in = (FIND_INFO *)au->info;

	switch (type)
	{
	case PARSE_PARAM_OPTION:
		switch (option)
		{
		case 'P':
			if (toupper(*cur_argv) == 'A')
			{
				strcpy(au->curOpt, "-PA");
				au->curVal = cur_argv+1;
				in->find_paths = get_value(au, OFF | ON);
			}
			break;
		case 'R':
			in->match_regular = get_value(au, OFF | ON | ONLY);
			break;
		case 'Q':
			in->quit_after_first = get_value(au, OFF | ON);
			break;
		case 'N':
			in->find_non_dos = get_value(au, OFF |ON);
			break;
		case 'M':
			in->one_per_archive = get_value(au, OFF |ON);
			break;
		case '?':
			au_syntax_message(au, "Find");
			au_printf(au,
			   "[@?3options@?H] [@?1filespec(s)@?H] @?Bmatch_pattern@?H\n\n");
			au_param_heading(au);
			au_printf(au,
				"@?3-R@?Hon|off|only    match Regular Files\n"
				"@?3-M@?Hon|off         Mention only the archive file\n"
				"@?3-Q@?Hon|off         Quit After first and change to found directory\n"
				"\n"
				"@?7Filters on the searches:\n"
				"------------------------\n"
				"@?3-N@?Hon|off         Find Non-dos file names\n"
				"@?3-PA@?Hon|off        Find archive files with paths\n");
			exit (0);
		default:
			au_invalid_option(au, PROGRAM, option);
		}
		return TRUE;
	case PARSE_FILESPEC:
		if (in->match_pattern[0] != '\0')
			add_to_list(au, &au->process_list, in->match_pattern);
		strcpy(in->match_pattern, cur_argv);
		return TRUE;
	case PARSE_POST_CHECK:
		if (in->match_pattern[0] == '\0')
		{
			au_printf_error(au, "No match pattern specified");
			exit(1);
		}
		return TRUE;
	}
	return FALSE;
}
/**/
int main_find(AU *au, int argc, char *argv[])
{
	FIND_INFO *in;

	in = (FIND_INFO *)au_malloc(au, sizeof(FIND_INFO));
	memset(in, '\0', sizeof(FIND_INFO));
	au->info = in;
	in->match_regular = OFF;

	ReadGlobalCFGInfo(au, au->cfg_file, PROGRAM, NULL);
	generic_parse_comm_line(au, argc, argv, parse_comm_line);
	process_files(au, find);

	if (!au->no_extra)
	{
		au_printf_c(au, 15, "\nFiles Searched = %d\n", au->number_processed);
		if (in->match_regular != ONLY)
			au_printf_c(au, 15, "Internal files = %ld\n", in->number_checked);
		au_printf_c(au, 15, "Matches        = %d\n", in->number_matched);
	}

	return 0;
}

