// FIXCR.CPP								 1		  1    6666
// Dave Harris								11		 11   6
// Compiled using Borland C++ ver 3.1	   1 1		1 1   6666
// 03-03-94 								 1	 ..   1   6   6
//										   11111 .. 11111  666
////////////////////////////////////////////////////////////////////////

#include "au.hpp"
#include <time.h>

#define PROGRAM "FIXCR"   // Name of module
/*********************************************************************/

#define BUF_SIZE 256
#define TMP_FILE "FIXCR.TMP"

typedef struct
{
	char tmp_file[FLENGTH];
} FIXCR_INFO;

/**/
static void buffered_write(HANDLE file, char ch, char *buffer, int *pos)
{
	if (ch == -1)	/* Write the string even if not full */
	{
		if (write(file, buffer, *pos) != *pos)
		{
			fprintf(stderr, "\aWrite Error %d\n", errno);
			exit(1);
		}
		*pos = 0;
	}
	else
	{
		buffer[*pos] = ch;
		(*pos)++;
		if (*pos == BUF_SIZE)
		{
			if (write(file, buffer, *pos) < 0)
			{
				fprintf(stderr, "\aWrite Error %d\n", errno);
				exit(1);
			}
			*pos = 0;
		}
	}
}
/**/
static int fixcr(AU *au, char *file_name)
{
	HANDLE in_file, out_file;
	int  ch, ch2;
	int  opt;
	int  modified = FALSE;
	int  binary_ok = FALSE; 	/* File is binary, but user answered yes */
	char buffer[BUF_SIZE];
	int  pos = 0;
	FIXCR_INFO *in = (FIXCR_INFO *)au->info;

	if (!au->no_extra)
		printf("@?6Processing @?1%s@?H\n", file_name);

	in_file = au_open(au, file_name, O_RDONLY | O_BINARY);
	if (in_file < 0)
		return -1;

	out_file = au_open(au, in->tmp_file, O_RDWR | O_BINARY | O_CREAT);
	if (out_file < 0)
	{
		close(in_file);
		return -1;
	}

	ch = my_getc(in_file);
	for (;;)
	{
		if (ch == EOF)
			break;

		if (((ch < 32 && ch != 26 && ch != '\n' && ch != '\r' && ch != '\t'
			  && ch != ' ' && ch != '\0') ||
			 ch > 127) && !binary_ok)
		{
			fprintf(stderr, "File %s appears to be a binary file.  Still fix it Y/N:",
					file_name);
			opt = toupper(my_getch());
			fprintf(stderr, "\n");
			if (opt != 'Y')
			{
				modified = FALSE;
				break;
			}
			else
				binary_ok = TRUE;
		}

		ch2 = my_getc(in_file);

		if (ch == '\r' && ch2 != '\n' || ch == '\n')
		{
			buffered_write(out_file, '\r', buffer, &pos);
			buffered_write(out_file, '\n', buffer, &pos);
			ch = ch2;
			modified = TRUE;
		}
		else if (ch == '\r' && ch2 == '\n')
		{
			buffered_write(out_file, '\r', buffer, &pos);
			buffered_write(out_file, '\n', buffer, &pos);
			ch = my_getc(in_file);
		}
		else
		{
			buffered_write(out_file, ch, buffer, &pos);
			ch = ch2;
		}
	}
	buffered_write(out_file, -1, buffer, &pos);
	close(out_file);
	close(in_file);
	if (modified)
	{
		unlink(file_name);
		rename(in->tmp_file, file_name);
		au->number_changed++;
	}
	else
		unlink(in->tmp_file);

	au->number_processed++;
	return 0;
}
/**/
static BYTE parse_comm_line(AU *au, char option, char *cur_argv,
							PARSE_TYPE type)
{
	Unused(cur_argv);

	switch (type)
	{
	case PARSE_PARAM_OPTION:
		switch (option)
		{
		case '?':
			au_standard_opt_header(au, "FIXcr", NULL);
			exit(0);
		default:
			au_invalid_option(au, PROGRAM, option);
		}
		return TRUE;
	}
	return FALSE;
}
/**/
static void end_program(void)
{
	FIXCR_INFO *in = (FIXCR_INFO *)glob_au->info;

	unlink(in->tmp_file);
	return;
}

/**/
int main_fixcr(AU *au, int argc, char *argv[])
{
	FIXCR_INFO *in;

	in = (FIXCR_INFO *)au_malloc(au, sizeof(FIXCR_INFO));
	memset(in, '\0', sizeof(FIXCR_INFO));
	au->info = in;

	generic_parse_comm_line(au, argc, argv, parse_comm_line);

	build_fname(in->tmp_file, au->cur_directory, TMP_FILE);
	atexit(end_program);   /* Remove temporary if it dies */

	process_files(au, fixcr);

	if (!au->no_extra)
		au_printf_c(au, 15, "\nFiles Processed = %d\n", au->number_processed);

	if (au->number_processed > 0)
	{
		if (!au->no_extra)
			au_printf_c(au, 15, "Files Modified  = %d\n", au->number_changed);
	}

	return 0;
}

