#include "..\au.hpp"

/*****************************************************************************/
static void *mem_search(char *string, unsigned int *seg, unsigned int *off,
						unsigned int max_seg)
{
	void *ptr;
	int len;
	register unsigned int seg2, off2;

	seg2 = *seg;
	off2 = *off;

	seg2 += off2 / 16;
	off2 = off2 % 16;
	off2 = 0;

	len = strlen(string);

	while (seg2 < max_seg)
	{
//		  while (off2 < 16)
//		  {
			ptr = MK_FP(seg2, off2);
			if (memcmp(ptr, string, len) == 0)
			{
				*seg = seg2;
				*off = off2;
				return ptr;
//			  }
//			  off2++;
		}
		seg2++;
//		  off2 = 0;
	}
	return NULL;
}
/******************************************************************************/
static char *find_envblock(char *env[], unsigned int *seg, unsigned int *off,
						   unsigned int max_seg)
{
	char *ptr;
	char *ptr2;
	int i;

	for (;;)
	{
around:
		ptr = (char *)mem_search(env[0], seg, off, max_seg);
		if (ptr == NULL)
			return NULL;
		ptr2 = ptr + strlen(env[0]) + 1;

		i=1;
		while (env[i] != NULL)
		{
			if (*(ptr2-1) != '\0' || strncmp(ptr2, env[i], strlen(env[i])) != 0)
			{
				*seg = FP_SEG(ptr2);
				*off = FP_OFF(ptr2);
				goto around;
			}
			ptr2 = ptr2 + strlen(env[i]) + 1;
			i++;
		}
		*seg = FP_SEG(ptr2);
		*off = FP_OFF(ptr2);
		if (*ptr2 != '\0' || *(ptr2-1) != '\0')
			goto around;
		return ptr;
	}
}
/**************************************************************************/
static int split_into_var_cont(char *var_cont, char *var, char *cont)
{
	char temp[200];
	char *ptr;

	strcpy(temp, var_cont);
	ptr = strchr(temp, '=');
	if (ptr == NULL)
		return -1;
	*ptr = '\0';
	strcpy(var, temp);
	strupr(var);
	strcpy(cont, ptr+1);
	return 0;
}
/**************************************************************************/
static int get_next_var(char *var, char *cont, char **mem_ptr)
{
	char temp[200];
	if (**mem_ptr == '\0')
		return FALSE;
	strcpy(temp, *mem_ptr);
	*mem_ptr += strlen(temp) + 1;
	split_into_var_cont(temp, var, cont);
	return TRUE;
}
/**************************************************************************/
static void uppercase_var(char *var_cont)
{
	char *ptr;

	ptr = strchr(var_cont, '=');
	if (ptr == NULL)
		return;
	*ptr = '\0';
	strupr(var_cont);
	*ptr = '=';
	return;
}
/**************************************************************************/
static int change_variable(char *var_cont, char *mem_ptr)
{
	char var[80], var2[80];
	char cont[150], cont2[120];
	char *mem_ptr2, *mem_save;
	int diff;

	uppercase_var(var_cont);

	if (split_into_var_cont(var_cont, var, cont) < 0)
		return -1;

	mem_save = mem_ptr;
	while (get_next_var(var2, cont2, &mem_ptr) == TRUE)
	{
		if (strcmp(var, var2) == 0)
		{
			diff = strlen(cont) - strlen(cont2);

			mem_ptr2 = mem_ptr;
			while (get_next_var(var2, cont2, &mem_ptr2) == TRUE)
			{
			}
			if (diff > 0)
				memmove(mem_save+diff, mem_save, mem_ptr2 - mem_save+1);
			else
				memmove(mem_save, mem_save-diff, mem_ptr2 - (mem_save-diff)+1);
			strcpy(mem_save, var_cont);
			return 0;
		}
		mem_save = mem_ptr;
	}
	/* append to the end if it isn't found */
	strcpy(mem_ptr, var_cont);
	mem_ptr[strlen(var_cont) + 1] = '\0';
	return 0;
}
/**************************************************************************/
int alter_env(AU *au, char *var_cont, char *env[])
{
	char *ptr;
	char *last_ptr, *second_last_ptr;
	unsigned int seg = 0;
	unsigned int off = 0;

	if (env[0][0] == '\0')
	{
		au_printf_error(au, "Need at least one environment variable for reference");
		return -1;
	}
	last_ptr = NULL;
	second_last_ptr = NULL;
	for (;;)
	{
		ptr = find_envblock(env, &seg, &off, FP_SEG(env));
		if (ptr == NULL)
			break;
		second_last_ptr = last_ptr;
		last_ptr = ptr;
	}
	if (second_last_ptr != NULL)
	{
		return change_variable(var_cont, second_last_ptr);
	}
	return -1;
}

#if 0
/**************************************************************************/
int main(int argc, char *argv[], char *env[])
{
	char temp[80];
	scanf("%s", temp);

	return alter_env(temp, env);
}
#endif
