#include "..\au.hpp"
#include <fcntl.h>
#include <sys\stat.h>
#include <errno.h>

/******************************************************************/
HANDLE au_open(AU *au, char *filename, int access)		  /* Replace C's open */
{
	HANDLE handle;
	char string[200];

	if (access & O_CREAT)
		handle = open(filename, access, S_IWRITE|S_IREAD);
	else
		handle = open(filename, access);

	if (handle == -1)
	{
		if (_doserrno == ENOENT)	  /* file simply missing */
			return -1;

		sprintf(string, "Error opening '%s',", filename);
		if (_doserrno == ENOPATH)
		{
			au_printf_error(au, "%s %s", string, "Illegal Path");
			return -1;
		}
		else if (_doserrno == EMFILE)
			au_printf_error(au, "%s %s", string, "Too Many Files Open");
		else if (_doserrno == EACCES)
			au_printf_error(au, "%s %s", string, "Permission Denied");
		exit(1);
	}
	reset_buffer_pos();
	return handle;
}
