#include "..\au.hpp"

/***************************************************************************/
static void display_setcolor(AU *au, char color)
{
	if (color >= '0' && color <= '7')
		au->current_color = color - 48 + 8;
	else
		au->current_color = color - 'A';

	return;
}
/***************************************************************************/
static void display_onechar(AU *au, char c)
{
//	  BYTE savecolor;

	if (c != '\n' && c != '\r' && c != '\a')
	{
		_BL = au->current_color;
		_AL = ' ';
		_AH = 0x09;
		_BH = 0;
		_CX = 1;
		__int__(0x10);
	}
#if 0
	else if (c == '\n')   /* Print spaces to the end to clean up color stuff */
	{
		savecolor = au->current_color;
		au->current_color = 0;
		for (;;)
		{
			_BH = 0;
			_AH = 0x03;
			__int__(0x10);
			if (_DL == 0)
				break;

			display_onechar(au, ' ');
		}
		au->current_color = savecolor;
		return;
	}
#endif

	_BL = au->current_color;
	_AL = c;
	_AH = 0x0e;
	_BH = 0;
	_CX = 1;
	__int__(0x10);

#if 0
	/* not sure why this is necessary, but without it the attribute seems
	   to bleed into the next line */
	if (c != '\n' && c != '\r' && c != '\a')
	{
		_BL = 7;
		_AL = ' ';
		_AH = 0x09;
		_BH = 0;
		_CX = 264;
		__int__(0x10);
	}
#endif
}
/***************************************************************************/
static void display_string(AU *au, char *string)
{
	while (*string != '\0')
	{
		if (*string == '@' && *(string+1) == '?')
		{
			display_setcolor(au, *(string+2));
			string+=3;
		}
		else
		{
			if (au->colorized)
			{
				if (*string == '\n')
					display_onechar(au, '\r');
				display_onechar(au, *string);
			}
			else
				putchar(*string);

			if (*string == '\n')                 /* Check for control S */
			{
				if (is_next_control_s())
				{
					my_getch();    /* Get control S */
					my_getch();    /* Wait for yet another character */
				}
			}
			string++;
		}
	}
}
/***************************************************************************/
static void au_printfv(AU *au, char *format, va_list plist)
{
	char string[2000];

	vsprintf(string, format, plist);
	display_string(au, string);
}
/***************************************************************************/
void au_printf(AU *au, char *format, ...)
{
	va_list plist;

	va_start(plist, format);
	au_printfv(au, format, plist);
	va_end(plist);

	return;
}
/***************************************************************************/
static void au_printf_cv(AU *au, char color, char *format, va_list plist)
{
	BYTE color_hold;

	color_hold = au->current_color;
	au->current_color = color;
	au_printfv(au, format, plist);
	au->current_color = color_hold;
}
/***************************************************************************/
void au_printf_c(AU *au, char color, char *format, ...)
{
	va_list plist;

	va_start(plist, format);
	au_printf_cv(au, color, format, plist);
	return;
}
/***************************************************************************/
void au_printf_error(AU *au, char *format, ...)
{
	va_list plist;

	au_printf(au, "\a");

	va_start(plist, format);
	au_printf_cv(au, 12, format, plist);
	au_printf(au, "\n");
	va_end(plist);
	return;
}
