// REDATE.CPP								 1		  1    6666
// Dave Harris								11		 11   6
// Compiled using Borland C++ ver 3.1	   1 1		1 1   6666
// 03-03-94 								 1	 ..   1   6   6
//										   11111 .. 11111  666
////////////////////////////////////////////////////////////////////////

/* Need to better organize this so that the from_outside flag is not
   necessary */

#include "au.hpp"
#include <time.h>

#define PROGRAM "REDATE"  // Name of module
/*********************************************************************/

typedef struct
{
	int  num_days;			 // Number of days to let age before processing
	char change_time;		 // change time as well as date
	char allow_future;
	DATE maxd;
	int  max_hour, max_min, max_sec;
	date datep;
	BYTE from_outside;
} REDATE_INFO;

/**/
static void rebuild_date(AU *au, HANDLE file, char *file_name)
{
	struct ftime ftime_hold;
	int different;
	DATE date;
	REDATE_INFO *in = (REDATE_INFO *)au->info;

	if (!in->from_outside)
		au_printf(au, "@?1%-*s@?H", FILE_SIZE+2, file_name); // display file name

	if (in->maxd.year == -1)
	{
		add_to_bad_list(au, au->source_directory, file_name);
		return;
	}
	if (in->maxd.year > in->datep.da_year ||
		(in->maxd.year == in->datep.da_year &&
		 (in->maxd.month > in->datep.da_mon || (in->maxd.month == in->datep.da_mon &&
		  in->maxd.day > in->datep.da_day)
	   )))
	{
		if (in->allow_future == OFF)
		{
			add_to_bad_list(au, au->source_directory, file_name, 0, 3);
			in->maxd.year  = in->datep.da_year;
			in->maxd.month = in->datep.da_mon;
			in->maxd.day   = in->datep.da_day;
		}
	}
	getftime(file, &ftime_hold);	/* so we can keep the time the same */
	different = ftime_hold.ft_day	!= in->maxd.day ||
				ftime_hold.ft_month != in->maxd.month ||
				ftime_hold.ft_year	!= in->maxd.year-1980;
	if (in->change_time == ON)
	{
		different = different || ftime_hold.ft_hour != in->max_hour  ||
								 ftime_hold.ft_min	!= in->max_min	 ||
								 ftime_hold.ft_tsec != in->max_sec/2;
	}

	ftime_hold.ft_day	= in->maxd.day;
	ftime_hold.ft_month = in->maxd.month;
	ftime_hold.ft_year	= in->maxd.year-1980;
	if (in->change_time == ON)
	{
		ftime_hold.ft_hour = in->max_hour;
		ftime_hold.ft_min  = in->max_min;
		ftime_hold.ft_tsec = in->max_sec / 2;
	}
	if (!au->simulate)
	{
		if (different)
		{
			setftime(file, &ftime_hold);
			if (!in->from_outside)
			{
				fix_flist(au, file_name, file_name);
				au->number_changed++;
			}
		}
	}

 // display new date

	if (!in->from_outside)
	{

		au_printf(au, "%s", date_to_string(&in->maxd));
		if (in->change_time == ON)
		{
			au_printf(au, " ");
			au_printf(au, "%s", hms_to_string(in->max_hour, in->max_min, in->max_sec));
		}

		if (different)
		{
			if (au->simulate)
				au_printf(au, " (Would be changed)");
			else
				au_printf(au, " (Changed)");
		}
		au_printf(au, "\n");
	}
}
/**/
static void set_max(AU *au, ARC_RECORD *r)
{
	REDATE_INFO *in = (REDATE_INFO *)au->info;

	if (au->date_retain == LAST)
	{
		if (r->date.year > in->maxd.year)
			goto assign;

		if (r->date.year == in->maxd.year)
		{
			if (r->date.month > in->maxd.month)
				goto assign;
			if (r->date.month == in->maxd.month)
			{
				if ((long)r->date.day*24*60*60 + (long)r->hour*60*60 +
						  (long)r->min*60 + (long)r->sec >
					(long)in->maxd.day*24*60*60 + (long)in->max_hour*60*60 +
						  (long)in->max_min*60 + (long)in->max_sec)
				{
					goto assign;
				}
			}
		}
	}
	else
	{
		if (r->date.year < in->maxd.year)
			goto assign;

		if (r->date.year == in->maxd.year)
		{
			if (r->date.month < in->maxd.month)
				goto assign;
			if (r->date.month == in->maxd.month)
			{
				if ((long)r->date.day*24*60*60 + (long)r->hour*60*60 + (long)r->min*60 +
						  (long)r->sec <
					(long)in->maxd.day*24*60*60 + (long)in->max_hour*60*60 + (long)in->max_min*60 +
						  (long)in->max_sec)
				{
					goto assign;
				}
			}
		}
	}
	return;

 assign:
	in->maxd.year  = r->date.year;
	in->maxd.month = r->date.month;
	in->maxd.day   = r->date.day;
	in->max_hour   = r->hour;
	in->max_min    = r->min;
	in->max_sec    = r->sec;

	return;
}
/**/
static void redate_one(AU *au, char *file_name, ARC_FILE *arcFile)
{
	ARC_RECORD record;
	int ret_code;
	REDATE_INFO *in = (REDATE_INFO *)au->info;

	if (!in->from_outside)
		au->number_processed++;

	for (;;)
	{
		ret_code = get_record(au, arcFile, &record);
		if (ret_code == EOF)
			break;
		else if (ret_code == -2)
		{
			in->maxd.year = -1;
			return;
		}
		else if (ret_code == -3)
			return;
		set_max(au, &record);
	}
	rebuild_date(au, arcFile->file, file_name);
	return;
}
/**/
static void init_date(AU *au)
{
	REDATE_INFO *in = (REDATE_INFO *)au->info;

	if (au->date_retain == LAST)
	{
		in->maxd.year = in->maxd.month = in->maxd.day = in->max_hour =
		in->max_min = in->max_sec = 0;
	}
	else
	{
		in->maxd.year = in->maxd.month = in->maxd.day = in->max_hour =
		in->max_min = in->max_sec = 999;
	}
}
/**/
static int redate(AU *au, char *file_name)
{
	ARC_FILE arcFile;
	struct ffblk ffblk;
	DATE date1, date2;
	REDATE_INFO *in = (REDATE_INFO *)au->info;

	check_for_key();

	findfirst(file_name, &ffblk, 0);

	date1.year	= in->datep.da_year;
	date1.month = in->datep.da_mon;
	date1.day	= in->datep.da_day;
	fdate_to_date(&date2, &ffblk);
	if (in->num_days <= 0 || days_diff(&date2, &date1) >= in->num_days)
	{
		init_date(au);

		arc_file_init(au, &arcFile, file_name);
		if (arcFile.type > 0)
			redate_one(au, file_name, &arcFile);
		arc_file_deinit(au, &arcFile);
	}
	return 0;
}
/**/
static void ReadCFGInfo(AU *au, HANDLE file, char *cfg_file, int *cfg_line)
{
	REDATE_INFO *in = (REDATE_INFO *)au->info;

	for(EVER)
	{
		char string[200],
			 string2[200],
			 string3[200];

		if (get_file_line(au, file, string)==EOF)
			break;

		split_string(string, string2);
		split_string(string, string3);

		if (string2[0] == '\0')
			continue;

		strcpy(au->curOpt, string2);
		au->curVal = string3;
		switch (toupper(string2[1]) << 8 | toupper(string2[0]))
		{
			case 'BE':                                          // Begin
				return;
			case 'AG':
				in->num_days = atoi(string3);
				break;
			case 'TI':
				in->change_time = get_value(au, OFF | ON);
				break;
			case 'AL':
				in->allow_future = get_value(au, OFF | ON);
				break;
			default:
				au_invalid_cfg_option(au, string2, cfg_file, *cfg_line);
		}
	}
}
/**/
static BYTE parse_comm_line(AU *au, char option, char *cur_argv,
							PARSE_TYPE type)
{
	REDATE_INFO *in = (REDATE_INFO *)au->info;

	switch (type)
	{
	case PARSE_PARAM_OPTION:
		switch (option)
		{
		case 'X':
			au->self_extracts = get_value(au, OFF | ON);
			break;
		case 'D':
			au->date_retain = get_value(au, FIRST | LAST);
			break;
		case 'A':
			in->num_days = atoi(cur_argv);
			break;
		case 'T':
			in->change_time = get_value(au, OFF | ON);
			break;
		case 'L':
			in->allow_future = get_value(au, OFF | ON);
			break;
		case '?':
			au_standard_opt_header(au, "Redate",
			   "@?3-X@?Hon|off         process self eXtracts\n"
			   "@?3-T@?Hon|off         change Time too\n"
			   "@?3-L@?Hon|off         aLlow future dates\n"
			   "@?3-D@?Hlast|first     Date as\n"
			   "@?3-A@?Hn              let Age n days before processing\n");
			exit(0);
		default:
			au_invalid_option(au, PROGRAM, option);
		}
		return TRUE;
	}
	return FALSE;
}
/**/
int redate_file(AU *au, char *file_name)
{
	REDATE_INFO *in;
	void *old_info;

	in = (REDATE_INFO *)au_malloc(au, sizeof(REDATE_INFO));
	memset(in, '\0', sizeof(REDATE_INFO));

	old_info = au->info;
	au->info = in;
	in->change_time  = ON;
	in->allow_future = ON;
	in->from_outside = TRUE;

	redate(au, file_name);
	au->info = old_info;
	return 0;
}
/**/
int main_redate(AU *au, int argc, char *argv[])
{
	char string[120];
	HANDLE file;
	REDATE_INFO *in;

	in = (REDATE_INFO *)au_malloc(au, sizeof(REDATE_INFO));
	memset(in, '\0', sizeof(REDATE_INFO));
	au->info = in;
	in->change_time  = OFF;
	in->allow_future = OFF;

	getdate(&in->datep);				  // Current date */

	au->allow_rename = FALSE;			 // no sense since unarcers not called
	au->date_retain = LAST; 			 // as a default
	ReadGlobalCFGInfo(au, au->cfg_file, PROGRAM, ReadCFGInfo);
	generic_parse_comm_line(au, argc, argv, parse_comm_line);
	process_files(au, redate);

	if (!au->no_extra)
		au_printf_c(au, 15, "\nFiles Processed = %d\n", au->number_processed);

	if (au->number_processed > 0)
	{
		if (!au->no_extra)
			au_printf_c(au, 15, "Files Modified  = %d\n", au->number_changed);
	}

	return 0;
}

