// TEST.CPP 								 1		  1    6666
// Dave Harris								11		 11   6
// Compiled using Borland C++ ver 3.1	   1 1		1 1   6666
// 03-03-94 								 1	 ..   1   6   6
//										   11111 .. 11111  666
////////////////////////////////////////////////////////////////////////

#include "au.hpp"

/*********************************************************************/
/* Define Statements */
/*********************/

#define PROGRAM "TEST"    // Name of module

/*********************************************************************/

/**/
static BYTE archive_has_password(AU *au, char *file_name)
{
	ARC_FILE arcFile;
	BYTE ret_code = FALSE;
	ARC_RECORD record;

	check_for_key();

	arc_file_init(au, &arcFile, file_name);
	for (;;)
	{
		if (get_record(au, &arcFile, &record) != 0)
			break;
		if (record.encrypted)
		{
			ret_code = TRUE;
			break;
		}
	}

	arc_file_deinit(au, &arcFile);
	return ret_code;
}
/**/
static int test_one(AU *au, char *file_name, PACKAGE *package)
{
	char string[FLENGTH];	 /* build the dos commands in the string */
	int  did_rename;
	int  ret_value;

	if (!au->no_extra)
		au_printf(au, "@?6Testing @?1%s@?H\n", file_name);
	act_log_printf(au, "   + TEST    : %s", file_name);

	if (package->test == NULL)
	{
		au_printf_error(au, "No testing method specified for %s\n", file_name);
		press_any_key(au);
		return 0;
	}

	did_rename = rename_strict(au, package, au->source_directory, file_name);

	au->number_processed++;

	substitute_macros(string, package->test, NULL, NULL, file_name);

	if (!au->simulate)
	{
		ret_value = execute(au, string, au->output, NULL, package->memoryNeeded);

		if (did_rename)
			rename_strict_back(au->source_directory, file_name);

		if (ret_value > 0)
		{
			if (archive_has_password(au, file_name))
				add_to_bad_list(au, au->source_directory, file_name, ret_value, 5);
			else
			{
				if (au->rename_to[0] != '\0')
				{
					rename(file_name, fit_mask(file_name, au->rename_to));
					fix_flist(au, file_name, fit_mask(file_name, au->rename_to));
				}

				add_to_bad_list(au, au->source_directory, file_name, ret_value, 1);
			}
			return -1;
		}
	}
	return 0;
}
/**/
static void quick_test_one(AU *au, char *file_name, ARC_FILE *arcFile)
{
	int ret_code;
	ARC_RECORD record;

	if (!au->no_extra)
		au_printf(au, "@?6Quick Testing @?1%s@?H\n", file_name);
	act_log_printf(au, "   + TEST -Q : %s", file_name);
	au->number_processed++;

	for (;;)
	{
		ret_code = get_record(au, arcFile, &record);
		if (ret_code == EOF)
			break;
		else if (ret_code == -2)
		{
			add_to_bad_list(au, au->source_directory, file_name, 0);
			return;
		}
	}
}
/**/
int test(AU *au, char *file_name)
{
	ARC_FILE arcFile;

	check_for_key();

	arc_file_init(au, &arcFile, file_name);
	if (au->quick_test)
	{
		if (arcFile.type > 0)
			quick_test_one(au, file_name, &arcFile);
		arc_file_deinit(au, &arcFile);
	}
	else
	{
		arc_file_deinit(au, &arcFile);
		if (arcFile.type > 0)
			return test_one(au, file_name, &au->package[arcFile.type]);
	}
	return 0;
}
/**/
static void ReadCFGInfo(AU *au, HANDLE file, char *cfg_file, int *cfg_line)
{
	char string[200],
		 string2[200],
		 string3[200];

	for(EVER)
	{
		if (get_file_line(au, file, string)==EOF)
			break;

		split_string(string, string2);
		split_string(string, string3);

		if (string2[0] == '\0')
			continue;

		strcpy(au->curOpt, string2);
		au->curVal = string3;
		switch (toupper(string2[1]) << 8 | toupper(string2[0]))
		{
			case 'BE':                                          // Begin
				return;
			case 'PA':
				au->pause = get_value(au, OFF | ON);
				break;
			case 'RE':
				strcpy(au->rename_to, string3);
				break;
			default:
				au_invalid_cfg_option(au, string2, cfg_file, *cfg_line);
		}
	}
}
/**/
static BYTE parse_comm_line(AU *au, char option, char *cur_argv,
							PARSE_TYPE type)
{
	Unused(cur_argv);

	switch (type)
	{
	case PARSE_SINGLE_OPTION:
		if (option == 'Q')
		{
			au->quick_test = TRUE;
			return TRUE;
		}
		return FALSE;
	case PARSE_PARAM_OPTION:
		switch (option)
		{
			case 'P':
				au->pause = get_value(au, OFF | ON);
				break;
			case '?':
				au_standard_opt_header(au, "Test",
					"@?3-Q@?H               Quick Test\n"
					"@?3-P@?Hon|off         Pause after bad archive found\n");
				exit (0);
			default:
				au_invalid_option(au, PROGRAM, option);
		}
		return TRUE;
	}
	return FALSE;
}
/**/
int main_test(AU *au, int argc, char *argv[])
{
	ReadGlobalCFGInfo(au, au->cfg_file, PROGRAM, ReadCFGInfo);
	generic_parse_comm_line(au, argc, argv, parse_comm_line);
	process_files(au, test);

	if (!au->no_extra)
		au_printf_c(au, 15, "\n\nFiles Tested = %d\n", au->number_processed);

	/* Prevent recursion when disp_bad_arcs is later called */
	au->quick_test = FALSE;

	return 0;
}

