#include "..\au.hpp"
/**************************************************************************/
int clean_paths(AU *au, LISTPTR *paths)
{
	int   largest;
	int   len;
	LIST *save;
	LIST *el;

	/* kill all the files and directories behind */
	for (el = paths->head; el != NULL; el = el->next)
	{
		cd(au, el->data);
		system("echo Y | del *.* >NUL");

		/* Null out destination directory */
		if (el->next == NULL)
			el->data[0] = '\0';
	}
	cd(au, au->source_directory);

	/* Remove the directories, largest first */
	for(EVER)
	{
		save = NULL;
		largest = 0;
		for (el = paths->head; el != NULL; el = el->next)
		{
			if (el->data[0] != '\0')
			{
				len = strlen(el->data);
				if (len > largest)
				{
					largest = len;
					save = el;
				}
			}
		}
		if (save == NULL)
			break;

		rmdir(save->data);
		save->data[0] = '\0';
	}
	destroy_list(paths);
	return 0;
}
