#include "..\au.hpp"

/**************************************************************************/
void generic_parse_comm_line(AU *au, int argc, char *argv[],
							 BYTE (*parse_func)(PARSE_PARAMS))
{
	char *cur_argv;
	BYTE files_only = FALSE;
	char string[128];

	for (int i=0; i<argc; i++)
	{
		strcpy(string, argv[i]);
		subst_environ(au, string);
		cur_argv=string;
		if (cur_argv[0] == '\0')
			continue;

		/* dash option */
		if ((cur_argv[0]=='-' || cur_argv[0]=='/') && !files_only)
		{
			char option = toupper(cur_argv[1]);

			if (option == '-' || option == '/')
			{
				files_only = TRUE;
				continue;
			}
			if (option == '#')
			{
				fill_list_from_BBS(au, cur_argv+2);
				continue;
			}
			if (parse_func(au, option, "", PARSE_SINGLE_OPTION))
				continue;

			if (cur_argv[2]=='\0')    /* parameter continues on next */
			{
				strcpy(string, argv[++i]);
				subst_environ(au, string);
				cur_argv=string;
			}
			else
				cur_argv+=2;		  /* advance it 2 characters */

			au->curOpt[0] = '-';
			au->curOpt[1] = option;
			au->curOpt[2] = '\0';
			au->curVal = cur_argv;

			parse_func(au, option, cur_argv, PARSE_PARAM_OPTION);
		}
		else if (cur_argv[0] == '@' && access(cur_argv, 0x00) != 0)
			process_at_file(au, &au->process_list, cur_argv+1);
		else
		{
			if (!parse_func(au, '\0', cur_argv, PARSE_FILESPEC))
				add_to_list(au, &au->process_list, cur_argv);
		}
	}
	parse_func(au, '\0', NULL, PARSE_POST_CHECK);
}

