#include "..\au.hpp"

/*************************************************************************/
static void printf_bar(AU *au, int n)
{
	int i;

	for (i=0; i < n; i++)
	{
		au_printf_c(au, i % 6 + 9, "-");
	}
}
/*************************************************************************/
static int process_dir(AU *au, int (*func)(AU *, char *), char *file_spec,
					   char sub_dirs)
{
	struct ffblk ffblk; 		  // directory entry structure
	int count=0;
	int len;
	char hold_dir[FLENGTH];
	LISTPTR file_list;
	LIST *el;

	if (!au->no_extra && !au->no_disp_dirs)
	{
		if (strcmp(au->last_dir, au->source_directory) != 0)
		{
			len = (72 - strlen(au->source_directory)) / 2;
			printf_bar(au, len);
			au_printf_c(au, 15, " Dir: %s ", au->source_directory);
			printf_bar(au, len);
			au_printf(au, "\n");
			strcpy(au->last_dir, au->source_directory);
		}
	}
	memset(&file_list, '\0', sizeof(LISTPTR));

	/* gather the file names first */

	if (!findfirst("*.*", &ffblk, 0))
	{
		do
		{
			if (strstr(ffblk.ff_name, ".")==NULL)
				strcat(ffblk.ff_name, ".");
			if (wildcard_compare(au, ffblk.ff_name, file_spec))
			{
				len = strlen(ffblk.ff_name);
				if (ffblk.ff_name[len-1] == '.')
					ffblk.ff_name[len-1] = '\0';
				if (au->dirs_only)
				{
					func(au, ffblk.ff_name);
					count++;
					break;
				}
				add_to_list(au, &file_list, ffblk.ff_name);
			}
		}  while (!findnext(&ffblk));
	}

	/* process */

	for (el = file_list.head; el != NULL; el = el->next)
	{
		func(au, el->data);
		count++;
	}
	destroy_list(&file_list);


	if (sub_dirs)
	{
		if (!findfirst("*.*", &ffblk, FA_DIREC))
		{
			do
			{
				if (ffblk.ff_attrib & FA_DIREC)
				{
					if (ffblk.ff_name[0] != '.')
					{
						fix_flist(au, NULL, NULL);
						cd(au, ffblk.ff_name, hold_dir);
						getcwd(au->source_directory, FLENGTH);
						count += process_dir(au, func, file_spec, sub_dirs-1);
						cd(au, hold_dir);
					}
				}
			}  while (!findnext(&ffblk));
		}
	}
	fix_flist(au, NULL, NULL);
	return count;
}
/*************************************************************************/
static int add_def_file_spec_to_list(AU *au, char *string)
{
	char string2[200], string3[200];

	strcpy(string2, string);
	for (;;)
	{
		split_string(string2, string3);
		ltrim(string2);
		rtrim(string2);

		if (string3[0] == '\0')
			break;

		if (string3[0] == '-' && string3[1] == '#')
		{
			fill_list_from_BBS(au, string3+2);
		}
		else if (string3[0] == '@' && access(string3, 0x00) != 0)
		{
			process_at_file(au, &au->process_list, string3+1);
		}
		else
			add_to_list(au, &au->process_list, string3);
	}
	return 0;
}
/*************************************************************************/
int process_files(AU *au, int (*func)(AU *, char *))
{
	LIST *el;
	char file_spec[FLENGTH];
	char hold_dir[FLENGTH];
	int count=0;
	int inside_count=0;

	if (au->process_list.head == NULL)
	{
		if (au->def_file_spec == NULL || au->def_file_spec[0] == '\0')
			goto Nothing;
		add_def_file_spec_to_list(au, au->def_file_spec);
//		  add_to_list(au, &au->process_list, "*.*");
	}

	for (el = au->process_list.head; el != NULL; el = el->next)
	{
		split_file(el->data, au->source_directory, file_spec);
		/* Change to cur_directory first in case source_directory is relative
		   to it */
		cd(au, au->cur_directory);
		cd(au, au->source_directory, hold_dir);

		if (chdir(file_spec) == 0)
			strcpy(file_spec, "*.*");

		if (file_spec[0]=='\0')
			strcpy(file_spec, "*.*");

		if (!strstr(file_spec, "."))
			strcat(file_spec, ".*");

		getcwd(au->source_directory, FLENGTH);
		inside_count += process_dir(au, func, file_spec, au->sub_dirs);
		if (inside_count == 0 && !au->no_extra && !au->dirs_only)
			au_printf_error(au, "No files matching %s", el->data);

		count += inside_count;
		cd(au, hold_dir);
	}
Nothing:
	if (count == 0 && !au->no_extra && !au->dirs_only)
		au_printf_c(au, 4, NOTHING);
	return count;
}

static int _count;

/**************************************************************************/
static int count_file(AU *au, char *file)
{
	_count++;
	Unused(au);
	Unused(file);
	return 0;
}
/**************************************************************************/
int count_process_files(AU *au)
{
	char old_sub_dirs = au->sub_dirs;
	BYTE old_no_disp_dirs = au->no_disp_dirs;

	_count = 0;
	au->sub_dirs = FALSE;
	au->no_disp_dirs = TRUE;
	process_files(au, count_file);
	au->sub_dirs = old_sub_dirs;
	au->no_disp_dirs = old_no_disp_dirs;

	return _count;
}
