#include "..\au.hpp"

/*****************************************************************************/
void check_threshold(AU *au, int threshold, BYTE ignoreSecond)
{
	int   num_to_process;

	if (threshold >= 0)
	{
		num_to_process = count_process_files(au);
		if (num_to_process == 0)
		{
			au_printf_c(au, 15, NOTHING);
			exit(0);
		}
		if (num_to_process > threshold && !ignoreSecond)
		{
			au_printf_error(au, "Threshold of %d files Exceeded, %d pending process",
				   threshold, num_to_process);
			if (!ask_continue())
				exit(0);
		}
	}
	return;
}
