{
   Cx, CXSUB example program.
   Copyright (c) 1990-1994 Eugene Nelson, Four Lakes Computing.
}

program  Cxf; uses cx, cxsub, crt;

{$F+}    {Required, do not change}


type ARECORD = record
   quiet       :boolean;
   interrupted :boolean
end;

var   j        :integer;
      method   :CXINT;
      bsize    :CXINT;
      tsize    :CXINT;
      ret      :CXINT;
      test     :boolean;
      extract  :boolean;
      s        :string[200];
      iname    :string[200];
      oname    :string[200];
      rec      :ARECORD;

{-------------------------------------------------------------------------}
procedure USAGE;
begin
   writeln('usage: cxf [options] infile [outfile]');
   writeln('   -1    compress infile to outfile using CX_METHOD1');
   writeln('   -2    compress infile to outfile using CX_METHOD2');
   writeln('   -3    compress infile to outfile using CX_METHOD3');
   writeln('   -c    compress infile to outfile using CX_METHODC');
   writeln('   -d    compress infile to outfile using CX_METHODD');
   writeln('   -x    decompress (extract) infile to outfile');
   writeln('   -i    test integrity of infile');
   writeln('   -b[n] buffer size (in K) when compressing (default CX_MAX_BUFFER)');
   writeln('   -t[n] temporary size (in K) when compressing (default CX_C_MAXTEMP)');
   writeln('   -q    quiet, no progress information');
   writeln('');
   writeln('   Examples:');
   writeln('      cxf -1 -b63 -t63 cx.doc cfile.dat');
   writeln('      cxf -i cfile.dat');
   writeln('      cxf -x cfile.dat dfile.dat');
   Halt;
end;


{-------------------------------------------------------------------------}
function callback(p: pointer): integer;
type pARECORD = ^ARECORD;
var   rec:  pARECORD;
begin
   rec:= pARECORD(p);

   if not rec^.quiet
      then write('.');

   if KeyPressed
   then begin
      rec^.interrupted:= True;
      callback:= -1;    {any non-zero return will work}
   end
   else
      callback:= 0;
end;

{The following is a dummy callback which may be used instead of callback}
{-------------------------------------------------------------------------}
function dcallback(p: pointer): integer;
begin
   dcallback:= 0;
end;

{-------------------------------------------------------------------------}
begin
   method:= 0;
   test:= False;
   extract:= False;
   iname:= '';
   oname:= '';
   bsize:= CX_MAX_BUFFER;
   tsize:= CX_C_MAXTEMP;
   rec.quiet:= False;
   rec.interrupted:= False;

   writeln('Cx Test Program, Copyright (c) 1990-1994 Four Lakes Computing');
   writeln('   Ŀ');
   writeln('   The evaluation object code runs MUCH slower than the object code');
   writeln('   that may be purchased.  Run TEST.EXE for EXACT speed and size   ');
   writeln('   measurements.                                                   ');
   writeln('   ');

   for j:= 1 to ParamCount
   do begin
      s:= ParamStr(j);
      if (s[1] = '-') and (Length(s) >= 2)
      then begin
         case s[2] of
            '1': method:= CX_METHOD1;
            '2': method:= CX_METHOD2;
            '3': method:= CX_METHOD3;
            'c', 'C': method:= CX_METHODC;
            'd', 'D': method:= CX_METHODD;
            'q', 'Q': rec.quiet:= TRUE;
            'i': test:= True;
            'x': extract:= True;

            't', 'T':
            begin
               val(Copy(s, 3, 200), tsize, ret);
               if tsize < 1 then tsize:= 1;
               if tsize > 63 then tsize:= 63;
               tsize:= tsize * 1024;
            end;

            'b', 'B':
            begin
               val(Copy(s, 3, 200), bsize, ret);
               if bsize < 1 then bsize:= 1;
               if bsize > 63 then bsize:= 63;
               bsize:= bsize * 1024;
            end;

            else USAGE;
         end;
      end
      else begin
         if Length(iname) = 0
            then iname:= s
            else oname:= s;
      end;
   end;

   if Length(iname) = 0
      then USAGE;

   if (method <> 0) and (Length(oname) = 0)
      then USAGE;
      
   if extract and (Length(oname) = 0)
      then USAGE;

   if not test and not extract and (method = 0)
      then USAGE;

   writeln('Press any key to stop.');

   if test
      then ret:= cx_decompress_file('', iname, callback, @rec)
   else if (extract)
      then ret:= cx_decompress_file(oname, iname, callback, @rec)
   else if method <> 0
      then ret:= cx_compress_file(oname, iname, method, bsize, tsize, callback, @rec);

   writeln('');

   if rec.interrupted
      then writeln('Interrupted.')
      else if ret = 0
         then writeln('Ok.')
         else begin
            write('ERROR: ');
            writeln(cx_error_message(ret));
         end;
end.
