#include <wnddb.h>
#include <stdlib.h>
#include <time.h>

#include "wndex.h"

const unsigned char faces[6] = { 4, 6, 8, 10, 12, 20 };

unsigned char test = 0, die = 6, dice = 2;
unsigned int times = 100, rolls[100];

INSTANCE_CLASS hinst;

DBFUNC RunTest(HWND hwnd, WORD message, WORD wparam, LONG lparam){
  int i, j;
  char string[3] = "  ";
  DIALOGBOXWINDOW_CLASS dbw(hwnd);
  switch(message){
    case WM_INITDIALOG:
      for(i = j = 0; i < 6; i++){
        if(faces[i] / 10) string[0] = '0' + faces[i] / 10;
        string[1] = '0' + faces[i] % 10;
        dbw.ListboxAdd(IDD_List, string);
        if(die == faces[i]) j = i;
      }
      dbw.ListboxSetsel(IDD_List, j);
      dbw.CheckRadio(IDD_One, IDD_Four, IDD_One + dice - 1);
      dbw.SetInt(IDD_Times, times);
      if(times < 10 || times > 10000) dbw.DisableOK();
      return TRUE;
    case WM_COMMAND:
      switch(wparam){
        case IDD_Times:
          i = dbw.GetInt(IDD_Times);
          if(i < 10 || i > 10000) dbw.DisableOK();
          else dbw.EnableOK();
          return TRUE;
        case IDOK:
          die = faces[dbw.ListboxGetsel(IDD_List)];
          for(i = IDD_One; i < IDD_Four; i++) if(dbw.IsButtonChecked(i)) break;
          dice = i - IDD_One + 1;
          times = dbw.GetInt(IDD_Times);
          test = 1;
          dbw.End(1);
          return TRUE;
        case IDCANCEL:
          dbw.End(0);
          return TRUE;
      }
      return FALSE;
  }
  return FALSE;
}

DBFUNC HelpAbout(HWND hwnd, WORD message, WORD wparam, LONG lparam){
  HBITMAP hbm;
  RECT rect;
  BITMAP_CLASS bc;
  BASEWINDOW_CLASS bwc;
  DIALOGBOXWINDOW_CLASS dbw(hwnd);
  switch(message){
    case WM_INITDIALOG:
      return TRUE;
    case WM_PAINT:
      bwc.Set(dbw.GetItem(IDD_Bitmap));
      bwc.Invalidate(TRUE);
      bwc.Update();
      bwc.GetClientRect(&rect);
      hbm = hinst.LoadBitmap("ILLINOIS");
      bc.Get(bwc.Get());
      bc.Setup(hbm);
      bc.Stretch(rect.right, rect.bottom);
      bc.Cleanup();
      DeleteObject(hbm);
      bc.Release();
      return FALSE;
    case WM_COMMAND:
      switch(wparam){
        case IDOK:
          dbw.End(1);
          return TRUE;
      }
      return FALSE;
  }
  return FALSE;
}

int FileRead(HWND hwnd){
  int i = FALSE;
  if(-1 == (fc.Open(fc.Getfilename(), OF_READ | OF_REOPEN))){
    fc.FileMessage(hwnd, MF_READERROR);
    return FALSE;
  }
  if(fc.ReadWORD() != WNDEXID) fc.FileMessage(hwnd, MF_TYPEERROR);
  else{
    test = fc.ReadBYTE();
    die = fc.ReadBYTE();
    dice = fc.ReadBYTE();
    times = fc.ReadWORD();
    fc.ReadBuffer((LPSTR)rolls, sizeof(rolls));
    i = TRUE;
  }
  fc.Close();
  return i;
}

int FileWrite(HWND hwnd, int flag){
  if(flag) if(IDNO == fc.FileMessage(hwnd, MF_REPLACE)) return FALSE;
  if(-1 == (fc.Open(fc.Getfilename(), OF_CREATE | OF_REOPEN))){
    fc.FileMessage(hwnd, MF_WRITEERROR);
    return FALSE;
  }
  fc.WriteWORD(WNDEXID);
  fc.WriteBYTE(test);
  fc.WriteBYTE(die);
  fc.WriteBYTE(dice);
  fc.WriteWORD(times);
  fc.WriteBuffer((LPSTR)rolls, sizeof(rolls));
  fc.Close();
  return TRUE;
}

WNDPROC WndProc(HWND hwnd, UINT message, UINT wparam, LONG lparam){
  int i, j, k, l;
  float x, y;
  RECT rect;
  BRUSHPEN_CLASS bc;
  DIALOGBOX_CLASS dbc(hinst.Get(), hwnd);
  DIALOGBOXWINDOW_CLASS dbw(hwnd);
  switch(message){
    case WM_CREATE:
      randomize();
      return FALSE;
    case WM_DESTROY:
      PostQuitMessage(0);
      return FALSE;
    case WM_CLOSE:
      DestroyWindow(hwnd);
      return FALSE;
    case WM_PAINT:
      if(IsIconic(hwnd) == NULL){
        bc.Begin(hwnd);
        bc.SelectSolid(WHITE);
        bc.Rectangle();
        bc.SelectDelete();
        if(test){
          dbw.GetClientRect(&rect);
          j = (die - 1) * dice + 1;
          for(i = k = 0; i < j; i++) if(rolls[i] > k) k = rolls[i];
          x = (float)(rect.right - rect.left) / j;
          y = (float)(rect.bottom - rect.top) / k;
          bc.SelectSolid(BLUE);
          if(x < 2) l = 0;
          else if(x < 4) l = 1;
          else l = 2;
          for(i = 0; i < j; i++) bc.Rectangle(rect.left + i * x + l,
           rect.top + (k - rolls[i]) * y, rect.left + wmax(i * x + l + 1,
           (i + 1) * x - l), rect.top + k * y);
          bc.SelectDelete();
        }
        bc.End();
      }
      return FALSE;
    case WM_COMMAND:
      switch(wparam){
        case IDM_FileOpen:
	  fc.Setcaption("File Open");
	  fc.Setdefaultspec("*.wex");
	  i = fc.FileOpen(hwnd);
	  if(i){
            i = FileRead(hwnd);
            if(i) test = 2;
            else test = 0;
            dbw.Invalidate();
            dbw.SendMessage(WM_PAINT);
          }
          return FALSE;
        case IDM_FileSave:
          if(test != 1) return FALSE;
        case IDM_FileSaveas:
          if(test == 0) return FALSE;
	  fc.Setcaption("File Save as");
	  fc.Setdefaultspec("*.wex");
	  fc.Getfilespec()[0] = 0;
	  i = fc.FileSaveas(hwnd);
	  if(i){
            if(i != 2) i = 0;
            i = FileWrite(hwnd, i);
            if(i) test = 2;
          }
          return FALSE;
        case IDM_FileExit:
          dbw.SendMessage(WM_CLOSE);
          return FALSE;
        case IDM_Runtest:
          i = dbc.DialogBox((FARPROC)RunTest, "RUNTESTDB");
          if(i){
            for(i = 0; i < 100; i++) rolls[i] = 0;
            for(i = 0; i < times; i++){
              for(j = k = 0; j < dice; j++) k += random(die) + 1;
              rolls[k - dice]++;
            }
            dbw.Invalidate();
            dbw.SendMessage(WM_PAINT);
          }
          return FALSE;
        case IDM_HelpAbout:
          i = dbc.DialogBox((FARPROC)HelpAbout, "HELPABOUTDB");
          return FALSE;
      } break;
    default: return DefWindowProc(hwnd, message, wparam, lparam);
  }
}

int PASCAL WinMain(HANDLE hinstance, HANDLE hprevinstance,
 LPSTR lpszcmdparam, int ncmdshow){
  int i;
  static char applicationname[] = "wndex";
  WND_CLASS wndclass(hinstance, applicationname, WndProc);
  WINDOWACCEL_CLASS window(hinstance, applicationname);
  wndclass.style(CS_HREDRAW | CS_VREDRAW);
  wndclass.LoadIcon();
  wndclass.lpszMenuName();
  if(!hprevinstance) wndclass.Register();
  fc.Setapplicationname("Wndlib example");
  hinst.Set(hinstance);
  fc.Sethinstance(hinstance);
  window.lpWindowName(fc.Getapplicationname());
  window.Display();
  window.LoadAccelerators();
  while(window.TestMessage()) { window.AccelMessage(); }
  return window.GetmsgwParam();
}