;
;--------------------------------------------------------------------;
;ROUTINE: RBBSDESQ            AUTHOR:  R. Molinelli                  ;
;                                      P.O. Box 961                  ;
;                                      Levittown, NY  11756          ;
;                                                                    ;
;DATE:  January 30, 1993      VERSION: 1.0                           ;
;                                                                    ;
;FUNCTION: This routine supports calls from MICROSOFT PDS BASIC      ;
;          Version 7.x or Microsoft Quick BASIC Version 4.5          ;
;          compilers to DOS interrupt 21 to find the version of      ;
;          DESQview that RBBS-PC is being run under.                 ;
;                                                                    ;
;            CALL RBBSDESQ (AX%,BX%)                                 ;
;                                                                    ;
;          where AX% and BX% are 16-bit binary data items (i.e.      ;
;          integer variables) and should be as follows:              ;
;                                                                    ;
; Offset   Variable    Description of Variable                       ;
;                                                                    ;
; BP+8        AX% = major version number of DESQview that RBBS-PC is ;
;                   running under.  (Zero if not present)            ;
;                                                                    ;
; BP+6        BX% = minor version number of DESQview that RBBS-PC is ;
;                   running under.                                   ;
;                                                                    ;
;         AX% and BX% will return zero if DESQview not present       ;
;                                                                    ;
;====================================================================;
; ROUTINE: CKSHARE            AUTHOR:  R. Molinelli                  ;
;                                      P.O. Box 261                  ;
;                                      Levittown, NY  11756-0913     ;
;                                                                    ;
; DATE: October 2, 1993       VERSION 1.0                            ;
;                                                                    ;
; FUNCTION:  Checks to see if DOS's Share is loaded.                 ;
;                                                                    ;
;            CALL CKSHARE (AX%)                                      ;
;                                                                    ;
;  where AX% is a 16 bit binary data item (i.e. integer variable)    ;
;  and should be as follows:                                         ;
;                                                                    ;
; Offset   Variable    Description of Variable                       ;
;                                                                    ;
; BP+6        AX% = indicates if share is loaded.  Zero indicates    ;
;                   share NOT loaded.                                ;
;                                                                    ;
;--------------------------------------------------------------------;
RBBSDVW  SEGMENT PUBLIC 'CODE'
         ASSUME CS:RBBSDVW
         PUBLIC RBBSDESQ
;
RBBSDESQ  PROC   FAR           ;Far Call
          PUBLIC RBBSDESQ
          PUSH   BP            ;Save base pointer register
          MOV    BP,SP         ;Setup to address off of base pointer
          PUSH   BX            ;Save BX
          PUSH   CX            ;Save CX
          PUSH   DX            ;Save DX
          MOV    CX,'DE'       ;Setup for call
          MOV    DX,'SQ'
          MOV    AX,2B01H
          INT    21H           ;Issue DOS Interrupt 21
          CMP    AL,0FFH       ;was call invalid?
          JE     NO_DESQ       ;then no DESQview
          MOV    AX,BX
          JMP    DONEDV
NO_DESQ:  SUB    AX,AX         ;set DESQview Version 0
DONEDV:   MOV    DI,[BP+8]     ;Get address of AX%
          MOV    [DI],AH       ;Put value of major DESQ version in AX%
          MOV    DI,[BP+6]     ;Get address of BX%
          MOV    [DI],AL       ;Put value of minor DESQ version in B%
          POP    DX            ;Restore DX
          POP    CX            ;Restore CX
          POP    BX            ;Restore BX
          POP    BP            ;Restore base pointer register
          RET    4             ;Return and remove the 2 parameters from stack
RBBSDESQ  ENDP
;
         PUBLIC CKSHARE
;
CKSHARE   PROC   FAR           ;Far Call
          PUBLIC CKSHARE
          PUSH   BP            ;Save base pointer register
          MOV    BP,SP         ;Setup to address off of base pointer
          PUSH   AX            ;Save AX
          PUSH   BX            ;Save BX
          PUSH   CX            ;Save CX
          PUSH   DX            ;Save DX
          MOV    AX,1000H      ;Setup for call
          INT    2FH           ;Issue DOS Interrupt 2F
          CMP    AL,0FFH
          JE     DONECK        ;SHARE detected
          SUB    AX,AX         ;NO SHARE
DONECK:   MOV    DI,[BP+6]     ;Get address of BX%
          MOV    [DI],AL       ;Put AL in B%
          POP    DX            ;Restore DX
          POP    CX            ;Restore CX
          POP    BX            ;Restore BX
          POP    AX            ;Restore AX
          POP    BP            ;Restore base pointer register
          RET    2             ;Return and remove the parameter from stack
CKSHARE   ENDP
RBBSDVW   ENDS
          END

