;==========================================================
; DDMOD.LSP Copyright 1993 by Looking Glass Microproducts
;==========================================================
; Adds Attribute Editing to DDMODIFY command. 
;=============================================================
(defun C:DDMOD (/ ERROR OLD-ERROR NOTRANS ITEM ITEMS COPYAT 
                  ATTUPD ESEL ENAME ENT TENAME TEXTENT SS1)
   ;==========================================================
   ; Error Handler
   (defun ERROR (S)
      (if (not
             (member
                S
                '("Function cancelled" "console break")
             )
          )
         (princ S)
      )
      (command "_undo" "_end")
      (princ)
   )
   ;==========================================================
   ; Disallow transparent invocation of routine.
   ;==========================================================
   (defun NOTRANS ()
      (cond
         ((zerop (logand (getvar "cmdactive") (+ 1 2 4 8))))
         ((alert
             "This command may not be invoked transparently."
          )
         )
      )
   )
   ;==========================================================
   ; Item from association list
   ;==========================================================
   (defun ITEM (A B) (cdr (assoc A B)))
   ;==========================================================
   ; Return the enumerated items in alist
   ;==========================================================
   (defun ITEMS (NLIST ALIST / SUBENT BLIST)
      (foreach N (reverse NLIST)
         (if (setq SUBENT (assoc N ALIST))
            (setq
               BLIST (cons SUBENT BLIST)
            )
         )
      )
      BLIST
   )
   ;==========================================================
   ; Copy attribute as a text entity
   ;==========================================================
   (defun COPYAT (ATTENT)
      (setq
         ;-------------------------------------------
         ; vertical flag is group 73 for text and 74 for
         ; attributes
         ATTENT (subst
                   (cons 73 (ITEM 74 ATTENT))
                   (assoc 73 ATTENT)
                   ATTENT
                )
         ;------------------------------------------
         ; grab the rest
         ATTENT (append
                   '((0 . "TEXT"))
                   (ITEMS
                      '(1   ; Text value
                         6   ; Linetype
                         7   ; Text style
                         8   ; Layer
                         10  ; Insertion point
                         11  ; Alignment point
                         39  ; thickness
                         40  ; height
                         41  ; relative X scale factor
                         50  ; Rotation angle
                         51  ; Obliquing angle
                         62  ; Color
                         67  ; Paper Space Flag
                         71  ; Text generation flags
                         72  ; Horiz. Justification type
                         73  ; Vert. Justification type
                         210 ; Extrusion direction
                      )
                      ATTENT
                   )
                )
      )
      (entmake ATTENT)
   )
   ;==========================================================
   ; Update attribute from text entity
   ;==========================================================
   (defun ATTUPD (ATTENT TEXTENT)
      (entmod
         (append
            (list
               (assoc -1 ATTENT)           ; entity name
               (assoc 0 ATTENT)            ; ATTRIB
               (assoc 2 ATTENT)            ; tag
               (assoc 70 ATTENT)           ; flags
               (cons 74 (ITEM 73 TEXTENT)) ; vertical just
            )
            (cddr TEXTENT)
         )
      )
   )
   ;==========================================================
   ; Body of c:ddmod  
   ;==========================================================
   (if (NOTRANS)
      (progn
         (setvar "cmdecho" 0)
         (command "_undo" "_group")
         (setq
            OLD-ERROR *error*
            *error*   ERROR
            SS1       (ssget "I")
            ESEL      (if (and SS1 (= 1 (sslength SS1)))
                         (list
                            (ssname SS1 0)
                            '(0 0 0)
                         )
                      )
            SS1       nil
         )
         (cond
            ((and
                (not DDMODIFY)
                (princ "\nInitializing...")
                (not
                   (load "ddmodify" nil)
                )
             )
               (alert "DDMODIFY.LSP:  Can't load file.")
            )
            ((not
                (or
                   ESEL
                   (setq
                      ESEL (nentsel
                              "\nSelect object to modify: "
                           )
                   )
                )
             )
               (princ "\nNothing selected.")
            )
            ((= 4 (length ESEL)) ; entity inside block
               (DDMODIFY (last (last ESEL)))
            )
            ((progn
                (setq ENAME (car ESEL) ENT (entget ENAME))
                (= "ATTRIB" (ITEM 0 ENT))
             )
               (COPYAT ENT)
               (setq TENAME (entlast))
               (DDMODIFY TENAME)
               (setq TEXTENT (entget TENAME))
               (ATTUPD ENT TEXTENT)
               (entdel TENAME)
               (entupd ENAME)
            )
            ((= "VERTEX" (ITEM 0 ENT))
               (while (progn
                         (setq
                            ENAME (entnext ENAME)
                            ENT   (entget ENAME)
                         )
                         (/= "SEQEND" (ITEM 0 ENT))
                      )
               )
               (setq ENAME (ITEM -2 ENT))
               (DDMODIFY ENAME)
            )
            (t (DDMODIFY ENAME))
         )
         (command "_undo" "_end")
      )
   )
   (princ)
)
(princ
   (strcat
      "  DDMOD.LSP v1.0 (Copyright 1993 by "
      "Looking Glass Microproducts) loaded."
   )
)
(princ)
