; TIP975.LSP: TAP-SEC.LSP   Draw Holes to Scale   (c)1994, John K. Sherman

(defun rtd (b)
  (* 180.0 (/ b pi))
)
(defun taperr (msg)
  (setq *error* temperr)
  (princ msg)
  (setvar "CLAYER" CLY)
  (setvar "OSMODE" OSM)
  (setvar "CMDECHO" CMD)
  (setvar "SNAPANG" OSN)
  (setvar "SNAPMODE" SNM)
  (princ)
)
(defun CBS ()
  (setq PT0 PT1)
  (setq PT1 (list
    (+ (car PT1) (* (cos ANG) DIAM))
    (+ (cadr PT1)(* (sin ANG) DIAM))))
  (command "layer" "s" "H" "")
  (command "INSERT" "C-BORE" PT0 DIAM CBD (rtd ANG))
)
(defun CLEAR ()
  (setvar "SNAPANG" ANG)
  (command "ARRAY" HS "" "R" 2 "" (/ CH 2))
  (command "ARRAY" HS "" "R" 2 "" (/ (- CH) 2))
  (command "ERASE" HS "")
  (command "LINE" PT3 PT4 "")
  (setq CLN (ENTLAST))
  (command "MOVE" CLN "" PT1 PT2)
  (setvar "SNAPANG" OSN)
)
(defun THRU ()
  (command "OSNAP" "INT")
  (prompt "\nOSNAP set to INT ")
  (setq PT1 (getpoint "\nStart point: ")) (terpri)
  (command "OSNAP" "INT,PER")
  (prompt "\nOSNAP set to INT, PER ")
  (setq PT2 (getpoint PT1
      "\nPick INTersection of or opposite side of material: "))
  (terpri)
  (setq ANG (angle PT1 PT2))
)
(defun POINTS ()
  (command "layer" "s" "H" "")
  (command "LINE" PT1 PT2 "")
  (setq HS (ENTLAST))
  (setq BR (/ DIAM 2))
  (setq TD (/ (- DIAM RD) 2))
  (setq PT3 (list
   (- (car PT1) (* (sin ANG) BR))
   (+ (cadr PT1)(* (cos ANG) BR))))
  (setq PT4 (list
   (+ (car PT1) (* (sin ANG) BR))
   (- (cadr PT1)(* (cos ANG) BR))))
  (setq PT5 (list
   (+ (car PT3) (* (COS ANG) P))
   (+ (cadr PT3)(* (SIN ANG) P))))
  (setq PT5 (list
   (+ (car PT5) (* (sin ANG) TD))
   (- (cadr PT5)(* (cos ANG) TD))))
  (setq PT6 (list
   (+ (car PT4) (* (COS ANG) P))
   (+ (cadr PT4)(* (SIN ANG) P))))
  (setq PT6 (list
   (- (car PT6) (* (sin ANG) TD))
   (+ (cadr PT6)(* (cos ANG) TD))))
)
(defun SIDES ()
  (command "OSNAP" "NONE")
  (command "COPY" HS "" PT1 PT3)
  (command "COPY" HS "" PT1 PT4)
  (command "ERASE" HS "")
)
(defun THDS ()
  (command "OSNAP" "NONE")
  (setq D (distance PT1 PT2))
  (setq TQY (/ D P))
  (setq TQF (fix TQY))
  (setq RM (rem TQF 2))
  (if (= RM 1)
    (setq TQE (1+ TQF))
    (setq TQE TQF)
  )
  (setq TQH (/ TQE 2))
  (command "LINE" PT3 PT4 "")
  (setq LTL (ENTLAST))
  (setvar "SNAPANG" ANG)
  (setq PT7 (list
    (+ (car PT1) (* (cos ANG) (* P 2)))
    (+ (cadr PT1)(* (sin ANG) (* P 2)))))
  (command "COPY" LTL "" PT1 PT7)
  (setq TQD (- (- TQF TQH) 1))
  (setq TQ 0)
  (while (< TQ TQD)
    (setq PT7 (list
      (+ (car PT7) (* (cos ANG) (* P 2)))
      (+ (cadr PT7)(* (sin ANG) (* P 2)))))
    (command "COPY" LTL "" PT1 PT7)
    (setq TQ (1+ TQ))
  )
  (command "LINE" PT5 PT6 "")
  (setq STL (ENTLAST))
  (setq PT7 (list
    (+ (car PT1) (* (cos ANG) P))
    (+ (cadr PT1)(* (sin ANG) P))))
  (setq D2 (* P 2))
  (setq PT8 (list
    (+ (car PT7) (* (cos ANG) (* P 2)))
    (+ (cadr PT7)(* (sin ANG) (* P 2)))))
  (command "COPY" STL "" PT7 PT8)
  (while (< D2 (- D (* P 3)))
    (setq PT8 (list
      (+ (car PT8) (* (cos ANG) (* P 2)))
      (+ (cadr PT8)(* (sin ANG) (* P 2)))))
    (command "COPY" STL "" PT7 PT8)
    (setq D2 (+ D2 (* P 2)))
  )
  (setvar "SNAPANG" OSN)
  (if (= OPN 4)
    (command "COPY" LTL "" PT1 PT2)
  )
  (command "ERASE" LTL "")
)
(defun BLIND ()
  (command "OSNAP" "INT")
  (prompt "\nOSNAP set to INT ")
  (setq PT1 (getpoint "\nStart point for BLIND SECTION view: "))
  (command "OSNAP" "INT")
  (princ "\nOSNAP set to INT ")
  (setq D (getdist PT1 
             "\nEnter thread depth or pick bottom of thread: "))
  (terpri)
  (command "OSNAP" "NEA")
  (princ "\nOSNAP set to NEA ") (terpri)
  (setq ANG (getangle PT1 "Enter or pick angle: "))
  (setq PT2 (list
    (+ (car PT1) (* (cos ANG) D))
    (+ (cadr PT1)(* (sin ANG) D))))
  (setq ANG (angle PT1 PT2))
  (command "INSERT" "DRILL-PT" PT2 RD "" (rtd ANG))
)
(defun DC ()
  (command "OSNAP" "CEN,INT")
  (prompt "\nOSNAP set to CEN, INT ")
  (setq CPT (getpoint "\nCenter for circles: "))
  (cond
    ((= OPN 1)(CLH) (CLT))
    ((= OPN 2)(CLC))
    ((= OPN 3)(CLC) (CLCB))
    ((= OPN 4)(CLH) (CLT))
  )
)
(defun CLCB ()
  (command "layer" "s" "0" "")
  (command "circle" CPT "d" CBD)
)
(defun CLC ()
  (command "layer" "s" "0" "")
  (command "circle" CPT "d" CH)
)
(defun CLH ()
  (command "layer" "s" "H" "")
  (command "circle" CPT "d" DIAM)
)
(defun CLT ()
  (command "layer" "s" "0" "")
  (command "circle" CPT "d" RD)
)
(defun PLAN ()
  (initget 0 "Y N")
  (setq ANS (getkword
           "\nDo you want circles in PLAN view? Y/<N>: "))
  (if (or (= ANS "N") (= ANS nil))
    (princ)
    (DC)
  )
)
(defun C:TAPSEC  (/ ANG ANS BR CBD CH CLN CLY CMD CPT D DIAM D2 HS
             LTL OMD OPN OSM OSN P PT0 PT1 PT2 PT3 PT4 PT5 PT6 PT7
                  PT8 RD RM SNM STL TD TPI TQ TQD TQE TQF TQH TQY)
  (setq temperr *error* *error* taperr)
  (setq CLY (getvar "CLAYER"))
  (setq OSM (getvar "OSMODE"))
  (setq CMD (getvar "CMDECHO"))
  (setq OMD (getvar "ORTHOMODE"))
  (setq OSN (getvar "SNAPANG"))
  (setq SNM (getvar "SNAPMODE"))
  (setvar "OSMODE" 0)
  (setvar "CMDECHO" 0)
  (setvar "ORTHOMODE" 0)
  (setvar "SNAPMODE" 0)
  (if (not (tblsearch "LTYPE" "HIDDEN"))
    (command "LINETYPE" "LOAD" "HIDDEN" "" "")
    (command "LAYER" "M" "H" "C" "MAGENTA" "H" "LT"
                                     "HIDDEN" "H" "")
  )
  (if (tblsearch "LAYER" "H") (command "layer" "s" "H" "")
                              (command "layer" "m" "H" "c"
                               "6" "" "")
  )
  (if (not *DIAM) (setq *DIAM 0.375))
  (princ "\nBolt diameter:< ")
  (princ *DIAM)
  (setq DIAM (getreal "> "))
  (if (not DIAM) (setq DIAM *DIAM)
                 (setq *DIAM DIAM)
  )
  (cond
    ((< DIAM 0.2500)(EXIT))
    ((= DIAM 0.2500)(setq TPI 20 RD 0.188 CBD 0.4375 CH 0.281))
    ((= DIAM 0.3125)(setq TPI 18 RD 0.244 CBD 0.5312 CH 0.344))
    ((= DIAM 0.3750)(setq TPI 16 RD 0.298 CBD 0.6250 CH 0.406))
    ((= DIAM 0.4375)(setq TPI 14 RD 0.350 CBD 0.7188 CH 0.469))
    ((= DIAM 0.5000)(setq TPI 13 RD 0.406 CBD 0.8125 CH 0.531))
    ((> DIAM 0.5000)(EXIT))
  )
  (setq P (/ 1.0 TPI))
  (graphscr)
  (prompt "1=Thru: 2=Clearance: 3=C'Bore w/Clearance: 4=Blind: ")
  (setq OPN (getreal "\nEnter option number: "))
  (cond
    ((= OPN 1) (THRU) (POINTS) (SIDES) (THDS) (PLAN))
    ((= OPN 2) (THRU) (POINTS) (CLEAR) (PLAN))
    ((= OPN 3) (THRU) (CBS) (POINTS) (CLEAR) (PLAN))
    ((= OPN 4) (BLIND) (POINTS) (SIDES) (THDS) (PLAN))
  )
  (setvar "CLAYER" CLY)
  (setvar "OSMODE" OSM)
  (setvar "CMDECHO" CMD)
  (setvar "ORTHOMODE" OMD)
  (setvar "SNAPANG" OSN)
  (setvar "SNAPMODE" SNM)
  (setq temperr *error*)
  (princ)
)

