; *********************************************************
; BLINE.LSP
; Copyright Barry R. Bowen 1993
; ---------------------------------------------------------
; Variables:
; ANG   = Angle in radians from PT1 to PT2
; BPT   = Beginning point for first line segment
; DIST  = Line segement length
; EL    = Last entity
; HT    = Text height
; HTX   = Half the text height
; PT1   = First line segement start point
; PT2   = First line segement end point
; TX    = Text added to line segement
; TLGTH = String length of text for break distance
; ---------------------------------------------------------

(defun C:BLINE (/ ANG BPT DIST PT1 PT2 EL HT HTX TX TLGTH)
  (V3)
  (setq PT1 (getpoint "\nStart Point: ")
        BPT PT1
        PT2 (getpoint PT1 "\nEnd Point: ")
        ANG (angle PT1 PT2))
  (command "line" PT1 PT2 "")
  (setq EL (entlast)
        DIST (getdist PT1 "\nSegement Length: "))
  (if (= HT nil) (setq TXHT 0.2) (setq TXHT HT))
  (setq HT (getreal (strcat "\nText Height<" (rtos TXHT 2 2) ">: ")))
  (if (= HT nil) (setq HT TXHT))
  (setq HTX (/ HT 2.0)
        TX (getstring "\nText Added To Line: ")
        TLGTH (strlen TX)
        HTX (* HTX TLGTH))
  (doline)
  (while PT2 (cntline))
  (V4)
)

; ----------------------- DOLINE----------------------------
(defun doline (/ IN EN ELIST PT PTA PTB)
  (command "measure" PT1 DIST)
  (S3 EL)
  (if (= ANG pi) (setq ANG 0))
  (if (= ANG (D270)) (setq ANG (D90)))
  (setq IN 0 EN (ssname SS1 IN))
  (while EN
    (setq ELIST (entget EN)
          PT (cdr (assoc 10 ELIST))
          PTA (polar PT (+ ANG pi) HTX)
          PTB (polar PT ANG HTX))
    (entdel EN)
    (command "break" PT "f" PTA PTB)
    (command "text" "m" PT HT (angtos ANG) TX)
    (setq IN (1+ IN) EN (ssname SS1 IN))
  )
)

; ----------------------- CUTLINE---------------------------
(defun CNTLINE (/ ANG EL)
  (setq PT1 PT2 PT2 (getpoint PT1 "\nNext Point: "))
  (if (/= PT2 nil)
   (progn
    (command "line" PT1 PT2 "")
    (setq ANG (angle PT1 PT2)
          EL (entlast))
    (doline)
  ))
)

(defun D90 () (* pi 0.5))

(defun D270 () (* pi 1.5))

; ------------------------- S3 -----------------------------
(defun S3 (EVAR1)
  (setq SS1 (ssadd) EN1 (entnext EVAR1))
  (while EN1
    (setq SS1 (ssadd EN1 SS1)
          EN1 (entnext EN1))
  )
)

; ------------------------ V3.LSP --------------------------
(defun V3 ()
  (setq BM (getvar "blipmode"))
  (setvar "blipmode" 0)
  (setvar "cmdecho" 0)
  (command "undo" "group")
)

; ------------------------ V4.LSP --------------------------
(defun V4 (/ BA)
  (setvar "blipmode" BM)
  (command "undo" "end")
  (prompt "\n")
  (setq BA "Program Completed. . . . .")
)

(prompt "\nBLINE loaded!")
(princ)

