; TIP882A:  SPRINGHH.LSP (C)1993, James Obermyer
; Parametric Springs

(defun C:SPRINGHH (/ OD MD WD A A1 A2 A3 A4
          N N1 PTCH PTCHO2 TWOPI PIO2 WO2 PC3
          PC2 PC1 MA P1 P2 P3 P4 P5 P6 P7 P8 P9 PC2T
          DIST DIST2 MPIO2 TANNA Q1 Q2 Q3 Q4 PH AR1
          AR2 AR3 AR4 X1 XE A3R D1 PR P1R P2R P3R
          P4R P5R P6R P7R P8R P9R P10R P1E P9E SP
          SPR EHR A270 P1E EHR)
     (setvar "lunits" 2)
     (defun dtr (A) (* PI (/ A 180.0)))
     (defun tana (A) (/ (sin A) (cos A)))
     (setq P0 (getpoint "\nLocate Start  "))
     (princ "\nOutside Diameter <")
     (princ OD*)(princ "> ")
     (setq OD (getdist))(if (= OD NIL)
     (setq OD OD*)(setq OD* OD))
     (princ "\nWire Diameter <")
     (princ WD*)(princ "> ")
     (setq WD (getdist))(if (= WD NIL)
     (setq WD WD*)(setq WD* WD))
     (princ "\nPitch  <")
     (princ PTCH*)(princ "> ")
     (setq PTCH (getdist))(if (= PTCH NIL)
     (setq PTCH PTCH*)(setq PTCH* PTCH))
     (princ "\nNumber of Turns <")
     (princ N1*)(princ "> ")
     (setq N1 (getreal))(if (= N1 NIL)
     (setq N1 N1*)(setq N1* N1))
     (prompt "Left hook  ")
     (prompt "**************************")
     (princ "\n1st Radius for Hook  <")
     (princ R2*)(princ "> ")
     (setq R2 (getdist))(if (= R2 NIL)
     (setq R2 R2*)(setq R2* R2))
     (princ "\nLength of Straight Part of Hook  <")
     (princ SP*)(princ "> ")
     (setq SP (getdist))(if (= SP NIL)
     (setq SP SP*)(setq SP* SP))
     (if (= 0 SP)(setq SP 1.0E-07))
     (princ "\nLength of End of Hook  <")
     (princ EH*)(princ "> ")
     (setq EH (getdist))(if (= EH NIL)
     (setq EH EH*)(setq EH* EH))
     (if (= 0 EH)(setq EH 1.0E-07))
     (prompt "Right hook  ")
     (prompt "**************************")
     (princ "\n1st Radius for Hook  <")
     (princ R2R*)(princ "> ")
     (setq R2R (getdist))(if (= R2R NIL)
     (setq R2R R2R*)(setq R2R* R2R))
     (princ "\nLength of Straight Part of Hook  <")
     (princ SPR*)(princ "> ")
     (setq SPR (getdist))(if (= SPR NIL)
     (setq SPR SPR*)(setq SPR* SPR))
     (if (= 0 SPR)(setq SPR 1.0E-7))
     (princ "\nLength of End of Hook  <")
     (princ EHR*)(PRINC "> ")
     (setq EHR (getdist))(if (= EHR NIL)
     (setq EHR EHR*)(setq EHR* EHR))
     (if (= 0 EHR)(setq EHR 1.0E-07))
     (setq WO2 (/ WD 2.0))
     (setq MD (- OD WD))
     (setq PTCHO2 (/ PTCH 2.0))
     (setq Q1 (/ PTCHO2 (- OD WD)))
     (setq A (ATAN Q1))
     (setq A1 (+ PI A))
     (setq A2 (- PI A))
     (setq TWOPI (+ PI PI))
     (setq PIO2 (/ PI 2.0))
     (setq A3 (+ PIO2 A))
     (setq A4 (- PIO2 A))
     (setq PC1 (polar P0 PIO2 WO2))
     (setq DIST2 (/ WO2 (SIN A)))
     (setq PC3 (polar PC1 0 PTCH))
     (setq P8 (polar PC3 PIO2 DIST2))
     (setq PE (polar P8 PI PTCH))
     (setq MA (- TWOPI A))
     (setq PH (polar PC1 A1 WO2))
     (setvar "lunits" 2)
     (setq PBOX (getvar "pickbox"))
     (setvar "pickbox" 1)
     (setq PREC (getvar "luprec"))
     (setvar "luprec" 8)
     (setvar "blipmode" 0)
     (setq N (- N1 1.0))
     (setq TEST 0)
     (while (<= TEST N)
          (setq P1 (polar PC1 MA WO2))
          (setq P1X (car P1))
          (setq P1Y (cadr P1))
          (setq P1X (+ P1X PTCH))
          (setq PRR (list P1X P1Y))
          (setq P1E P1)
          (setq P2 (polar PC1 A2 WO2))
          (setq P2X (car P2))
          (setq P2Y (cadr P2))
          (setq P2X (+ P2X PTCH))
          (setq PR (list P2X P2Y))
          (setq PC2T (polar PC1 PIO2 MD))
          (setq TANNA (tana A))
          (setq PC2 (polar PC2T 0 (* MD TANNA)))
          (setq DIST (* MD (tana A)))
          (setq P4 (polar PC2 MA WO2))
          (setq P3 (polar PC2 A2 WO2))
          (setq PC3 (polar PC1 0 PTCH))
          (setq P5 (polar PC3 A1 WO2))
          (setq P6 (polar PC3 MA WO2))
          (setq P7 (polar PC2 A WO2))
          (setq P8 (polar PC3 PIO2 DIST2))
          (setq MPIO2 (* 1.5 PI))
          (setq P9 (polar PC2 MPIO2 DIST2))
          (setq P9R P9)
          (setq P9E P9)
          (command "pline" P4 "W" 0 0 P1 "A"  P2 "L" P3 "A" P4 "")
          (command "pline" P9 P5 "A" P6 "")
          (command "pline" P8 P7 "")
          (setq PC1 (polar PC1 0 PTCH))
          (setq TEST (+ TEST 1.0))
     )
     (command "explode" PRR)
     (command "erase" PRR "")
     (setq SINA (sin A))
     (setq Q1 (- 1.0 SINA))
     (setq Q1 (* WO2 Q1))
     (setq Q2 (* R2 SINA))
     (setq Q3 (+ R2 WD))
     (setq VD (- (+ OD Q2) (+ Q1 Q3)))
     (setq D1 (/ VD (COS A)))
     (setq P1 (polar PH A3 D1))
     (setq AR1 (- PIO2 A))
     (setq AR2 (/ (+ PIO2 A) 2.0))
     (setq Q4 (/ (sin AR1) (sin AR2)))
     (setq D2 (* Q4 R2))
     (setq AR3 (+ (- PIO2 AR2) A PIO2))
     (setq AR4 (+ PI AR3))
     (setq D3 (* Q4 Q3))
     (setq P2 (polar P1 AR3 D2))
     (setq P3 (polar P2 PI SP))
     (setq DH (- OD (* 2.0 WD)))
     (setq A270 (* 1.5 PI))
     (setq P4 (polar P3 A270 DH))
     (setq P5 (polar P4 0 EH))
     (setq P6 (polar P5 A270 WD))
     (setq P7 (polar P6 PI EH))
     (setq P8 (polar P7 PIO2 OD))
     (setq P9 (polar P8 0 SP))
     (setq P10 (polar P9 AR4 D3))
     (setq X1 (car P10))
     (setq XE (car PE))
     (command "pline" PH P1 "A" P2 "L" P3 "A" P4 "L" P5 P6 P7 "A"
     P8 "L" P9 "A" P10 "L" PE "")
     (if (> X1 XE)(command "trim" P0 "" P10 ""))
     (setq Q2 (* R2R SINA))
     (setq Q3 (+ R2R WD))
     (setq VD (- (+ OD Q2) (+ Q1 Q3)))
     (setq D1 (/ VD (COS A)))
     (setq A3R (+ PI A3))
     (setq AR1 (- PIO2 A))
     (setq AR2 (/ (+ PIO2 A) 2.0))
     (setq P1R (polar PR AR1 D1))
     (setq Q4 (/ (sin AR1) (sin AR2)))
     (setq D2 (* Q4 R2R))
     (setq AR3 (- AR2 A))
     (setq AR4 (+ PI AR3))
     (setq D3 (* Q4 Q3))
     (setq P2R (polar P1R AR3 D3))
     (setq P3R (polar P2R 0 SPR))
     (setq P4R (polar P3R A270 OD))
     (setq P5R (polar P4R PI EHR))
     (setq P6R (polar P5R PIO2 WD))
     (setq P7R (polar P6R 0 EHR))
     (setq P8R (polar P7R PIO2 DH))
     (setq P9R (polar P8R PI SPR))
     (setq P10R (polar P9R AR4 D2))
     (command "pline" PR P1R "A" P2R "L" P3R "A" P4R "L" P5R
     P6R P7R "A" P8R "L" P9R "A" P10R "L" PRR "A" PR "")
     (setvar "blipmode" 1)
     (setvar "pickbox" PBOX)
     (setvar "luprec" PREC)
); end springhh.lsp
