; **********************************************************
; REPLINE.LSP
; Copyright (c) Barry R. Bowen 1993
; ----------------------------------------------------------
; Variables:
; ANG   = Angle between each vertex
; D1    = Distance between each vertex
; EN    = Pline entity name
; EN1   = Next vertex of Pline
; ELIST = Entity list of each vertex
; PLIST = Polyline list of each vertex distance/angle
; PT1   = Starting point of each vertex
; PT2   = Ending point of each vertex
; ----------------------------------------------------------

(defun C:GETPL (/ ANG D1 EN EN1 ELIST PT1 PT2)
  (setvar "cmdecho" 0)
  (setq PLIST '()
        EN (car (entsel "\nSelect Pline: "))
        ELIST (entget EN))
  (if (= (cdr (assoc 0 ELIST)) "POLYLINE")
    (progn
      (setq EN1 (entnext EN)
            ELIST1 (entget EN1)
            PT1 (cdr (assoc 10 ELIST1))
            EN1 (entnext EN1)
            ELIST1 (entget EN1))
      (while (/= (cdr (assoc 0 ELIST1)) "SEQEND")
         (setq PT2 (cdr (assoc 10 ELIST1))
               D1 (distance PT1 PT2)
               ANG (angle PT1 PT2)
               PLIST (append (list (list D1 ANG)) PLIST)
               EN1 (entnext EN1)
               ELIST1 (entget EN1))
         (if (/= (cdr (assoc 0 ELIST1)) "SEQEND")
           (setq PT1 PT2)
         )
      )
      (setq PLIST (reverse PLIST))
    )
    (prompt "\nEntity Selected is not a Pline!")
  )
)

; ------------------------- CUSTPL -------------------------
(defun C:CUSTPL (/ DIST EPT LGTH ND NUM RM)
  (if (/= PLIST nil)
   (progn
     (setq PT1 (getpoint "\nStart Point: ")
           SP PT1
           EPT (getpoint PT1 "\nEnd Point: ")
           LANG (angle PT1 EPT)
           DIST (distance PT1 EPT)
           LGTH (length PLIST))
     (command "pline" PT1)
     (GETSEG) ;build the first segment
     (setq ND (distance SP NP)
           NUM (/ DIST ND)
           RM (- NUM (fix NUM)))
     (if (> RM 0.5) (setq NUM (fix NUM))
         (setq NUM (1- (fix NUM)))
     )
     (repeat NUM (GETSEG))
     (command "")
   );end progn
   (prompt "\nUse GETPL to Select A PLine Segement!")
  ); end if
)

; -------------------------- GETSEG -------------------------
(defun GETSEG (/ A AG DT IN)
  (setq IN 0)
  (repeat LGTH
    (setq A (nth IN PLIST)
         DT (car A)
         AG (cadr A)
         AG (+ LANG AG)
         NP (polar PT1 AG DT))
    (command NP)
    (setq PT1 NP IN (1+ IN))
  )
)
