;TIP 880B:  XTRACTT.LSP (C)1993, ROBERT L. ZIPPRICH


;------------------------------------------------------------------
;  User selects block and XTRACTT creates an attribute template file
;and an attribute prompt file, both with the same name as the block,
;(i.e. "ETBLOCK.TXT" and "ETBLOCK.DEF").  This function searches the
;drawing block table for the selected entity and its associated
;attributes.
;  The difference between XTRACT and XTRACTT being that the block
;table may contain a different definition of attributes than an
;inserted block.  Default values are 8 characters for the block name,
;X and Y coordinate fields of 7 digits rounded to .1 decimal place,
;and 20 characters for a prompt description.
;------------------------------------------------------------------
(defun C:XTRACTT ()
   (Setq BLK    (car (entsel "Select Block: "))
         DATA   (entget BLK)
         NAME   (cdr (assoc 2 DATA))
         TBLENT (tblsearch "block" name)
         BLK    (cdr (assoc -2 tblent))
         file    (open (strcat name ".txt") "w")
         file2   (open (strcat name ".def") "w")
         blkname (strcat "BL:" name "                    ")
         blkname (substr blkname 1 20)
         blkname (strcat blkname "C008000")
   )
         (write-line blkname file)
         (write-line         "Attribute Tag Names, Defaults, Prompts" file2)
         (write-line (strcat "for: " name " in " 
           (getvar "dwgname") ".DWG")  file2)
         (write-line "" file2)
         (write-line "  TAG          DEFAULT                  PROMPT" file2)
         (write-line "" file2)
         (write-line "BL:X                N007001" file)
         (write-line "BL:Y                N007001" file)

   (while blk
         (setq DATA (entget BLK))
         (if (eq "ATTDEF" (cdr (assoc 0 data)))
             (progn
               (setq dflt (cdr (assoc 1 data))
                     tag  (cdr (assoc 2 data))
                     def  (cdr (assoc 3 data))
                     dflt (strcat dflt "                       ")
                     dflt (substr dflt 1 20)
                     tag  (strcat tag "                       ")
                     tag  (substr tag 1 14)
                     tag2 (strcat tag "C020000")
               )
               (write-line tag2 file)
               (write-line (strcat tag dflt def) file2)
               (setq blk   (entnext blk))
             )
             (progn
                 (setq blk (entnext blk))
             )
         ) ;end if
   ) ;end while
   (close file)
   (close file2)
) ;end xtractt
;-------------------------------------------------------------
cadlst29.ltr
