;==========================================================
; PERIMETR.LSP Copyright 1993 by Looking Glass Microproducts
;==========================================================
; Accumlate Perimeters 
;=============================================================
; 
(setq PERIMETER_COLOR "MAGENTA" PERIMETER_FILE "PERIMETR.TXT")
(defun C:PERIMETER (/ ERROR PUSHVARS POPVARS PERIMETER TOTAL GET_ACTION
                    ITEM ENTITIES BY_POINTS DO_CIRCLE DO_LINE DO_ARC
                    DO_POLYLINE POLYLEN FINISH DISPLAY WRITE_PERIMETER
                    PERIMETERS)
   ;==========================================================
   ; Error Handler
   (defun ERROR (S)
      (if (not
             (member
                S
                '("Function cancelled" "console break")
             )
          )
         (princ S)
      )
      (command)
      (command)
      (command)
      (setvar "cmdecho" 0)
      (command ".undo" "end")
      (command ".undo" "1")
      (POPVARS)
   )
   ;==========================================================
   ; Set and Save System Variables
   (defun PUSHVARS (VLIST)
      (foreach PAIR VLIST
         (setq
            SYSVARS (cons
                       (cons
                          (strcase (car PAIR))
                          (getvar
                             (car PAIR)
                          )
                       )
                       SYSVARS
                    )
         )
         (if (cdr PAIR) (setvar (car PAIR) (cdr PAIR)))
      )
   )
   ;==========================================================
   ; Restore System Variables
   (defun POPVARS ()
      (foreach PAIR SYSVARS (setvar (car PAIR) (cdr PAIR)))
      (setq
         *error* OLD-ERROR
      )
      (setq SYSVARS nil)
      (princ)
   )
   ;==========================================================
   ; Get action
   (defun GET_ACTION (/ PRMPT KWORDS ACTION)
      (graphscr)
      (setq
         PRMPT  (strcat
                   (if (> TOTAL 0)
                      (strcat
                         "\nTotal perimeter = "
                         (rtos TOTAL)
                      )
                      ""
                   )
                   "\n<From point>/Entities/Undo: "
                )
         KWORDS "Entities Undo"
      )
      (initget KWORDS)
      (getpoint PRMPT)
   )
   ;==========================================================
   ; Undo last command
   (defun UNDO ()
      (if PERIMETERS
         (progn
            (setq
               TOTAL      (car PERIMETERS)
               PERIMETERS (cdr PERIMETERS)
            )
            (command ".undo" "back")
         )
         (prompt "\nNothing to undo.")
      )
   )
   ;==========================================================
   ; Exit program
   (defun FINISH ()
      (setq AGAIN nil)
      (WRITE_PERIMETER)
      (command ".undo" "back") ; Remove highlights
   )
   ;===========================================================
   ; item from association list
   (defun ITEM (A B) (cdr (assoc A B)))
   ;===========================================================
   (defun DO_CIRCLE (/ R)
      (setq R (ITEM 40 ENT) TOTAL (+ TOTAL (* 2.0 pi R)))
      (DISPLAY
         ENAME
      )
   )
   ;===========================================================
   (defun DO_ARC (/ R A)
      (setq R (ITEM 40 ENT) A (- (ITEM 51 ENT) (ITEM 50 ENT)))
      (if (minusp A) (setq A (+ A pi pi)))
      (setq
         TOTAL (+ TOTAL (* A R))
      )
      (DISPLAY ENAME)
   )
   ;===========================================================
   (defun DO_LINE ()
      (setq
         TOTAL (+
                  TOTAL
                  (distance (ITEM 10 ENT) (ITEM 11 ENT))
               )
      )
      (DISPLAY ENAME)
   )
   ;===========================================================
   ; Return length of polyline
   (defun POLYLEN (ENAME / ENT VNAME VENT CLOSED LEN P0 P1 P2 BULGE
                   BULGE_LEN)
      ;==========================================
      ; Length of arc from p1 to p2 with bulge b
      (defun BULGE_LEN (P1 P2 B / D A R)
         (setq D (distance P1 P2))
         (if (zerop B)
            D
            (progn
               (setq
                  A (* 4.0 (atan B))
                  R (abs (/ D (* 2.0 (sin (/ A 2.0)))))
               )
               (* R (abs A))
            )
         )
      )
      (setq
         ENT    (entget ENAME)
         CLOSED (= 1 (logand (ITEM 70 ENT) 1))
         VNAME  ENAME
         LEN    0.0
      )
      (while (progn
                (setq
                   VNAME (entnext VNAME)
                   VENT  (entget VNAME)
                )
                (= "VERTEX" (ITEM 0 VENT))
             )
         ; Ignore spline frame control points
         (if (zerop (logand (ITEM 70 VENT) 16))
            (progn
               (setq P2 (ITEM 10 VENT))
               (if P0
                  (setq
                     LEN (+ LEN (BULGE_LEN P1 P2 BULGE))
                  )
                  (setq P0 P2)
               )
               (setq P1 P2 BULGE (ITEM 42 VENT))
            )
         )
      )
      (if CLOSED (+ LEN (BULGE_LEN P2 P0 BULGE)) LEN)
   )
   ;===========================================================
   (defun DO_POLYLINE ()
      (setq TOTAL (+ TOTAL (POLYLEN ENAME)))
      (DISPLAY ENAME)
   )
   ;===========================================================
   ; Distances by selecting entities
   (defun ENTITIES (/ SS1 ENAME ENT ETYPE)
      (command ".undo" "mark")
      (setq
         PERIMETERS (cons TOTAL PERIMETERS)
      )
      (if (setq SS1 (ssget))
         (repeat
            (sslength SS1)
            (setq ENAME (ssname SS1 0))
            (redraw ENAME 3)
            (ssdel ENAME SS1)
            (setq
               ENT   (entget ENAME)
               ETYPE (ITEM 0 ENT)
            )
            (cond
               ((= ETYPE "CIRCLE") (DO_CIRCLE))
               ((= ETYPE "ARC")
                  (DO_ARC)
               )
               ((= ETYPE "LINE") (DO_LINE))
               ((and
                   (= ETYPE "POLYLINE")
                   (zerop
                      (logand (ITEM 70 ENT) 120)
                   )
                )
                  (DO_POLYLINE)
               )
               ((redraw ENAME 4))
            )
         )
         (UNDO)
      )
   )
   ;==========================================================
   ; Distances by specifying points
   (defun BY_POINTS (P1 / POINTS PRMPT AGAIN)
      (command ".undo" "mark")
      (setq
         PERIMETERS (cons TOTAL PERIMETERS)
         POINTS     (list P1)
         AGAIN      t
      )
      (command ".pline" P1)
      (while AGAIN
         (initget "Undo Close")
         (setq
            P1 (getpoint (car POINTS) "\nTo point: ")
         )
         (cond
            ((null P1) (setq AGAIN nil) (command ""))
            ((listp P1)
               (command P1)
               (setq
                  POINTS (cons P1 POINTS)
                  TOTAL  (+
                            TOTAL
                            (distance
                               (car POINTS)
                               (cadr POINTS)
                            )
                         )
               )
            )
            ((= "Undo" P1)
               (if (cdr POINTS)
                  (progn
                     (command P1)
                     (setq
                        TOTAL  (-
                                  TOTAL
                                  (distance
                                     (car POINTS)
                                     (cadr POINTS)
                                  )
                               )
                        POINTS (cdr POINTS)
                     )
                  )
                  (prompt "\nNothing to undo.")
               )
            )
            ((= "Close" P1)
               (if (< (length POINTS) 3)
                  (prompt
                     "\nCannot close until two or more segments drawn."
                  )
                  (progn
                     (command P1)
                     (setq
                        POINTS (cons (last POINTS) POINTS)
                        TOTAL  (+
                                  TOTAL
                                  (distance
                                     (car POINTS)
                                     (cadr POINTS)
                                  )
                               )
                        AGAIN  nil
                     )
                  )
               )
            )
         )
      )
      (if (cdr POINTS) (DISPLAY (entlast)) (UNDO))
   )
   ;============================================================
   ; Display entity in perimeter_color
   (defun DISPLAY (ENAME)
      (command ".chprop" ENAME "" "color" PERIMETER_COLOR "")
   )
   ;==========================================================
   ; Write perimeter
   (defun WRITE_PERIMETER (/ FHAND)
      (if (setq FHAND (open PERIMETER_FILE "w"))
         (progn
            (write-line (rtos TOTAL) FHAND)
            (close FHAND)
            t
         )
         (prompt
            (strcat
               "\nERROR:  Can't write file: "
               PERIMETER_FILE
            )
         )
      )
   )
   ;==========================================================
   (defun PERIMETER (/ AGAIN ACTION)
      (command ".undo" "mark")
      (setq TOTAL 0.0)
      (setq AGAIN (WRITE_PERIMETER))
      (while AGAIN
         (setq ACTION (GET_ACTION))
         (cond
            ((null ACTION) (FINISH))
            ((listp ACTION)
               (BY_POINTS ACTION)
            )
            (t ((eval (read ACTION))))
         )
      )
   )
   ;==========================================================
   ; Body of perimeter  
   (setq OLD-ERROR *error* *error* ERROR)
   (PUSHVARS
      '(("cmdecho" . 0) ("coords" . 2))
   )
   (command ".undo" "group")
   (PERIMETER)
   (command ".undo" "end")
   (POPVARS)
)
(princ
   "  PERIMETR.LSP (Copyright 1993 by Looking Glass Microproducts) loaded."
)
(princ)
