; TIP991.LSP: MANDE.LSP   Mandelbrot Set   (c)1994, Jason Orndorff

(defun c:MANDE ()
    (setq ACORNER (getreal "Enter lower left x coordinate {-.5 to 2.5}: "))
    (setq BCORNER (getreal "Enter lower left y coordinate {-1.5 to 1.5}: "))
    (setq SIDE (getreal "Enter length of side {3.0 max.}: "))
    (setq GAP (/ SIDE 400))
    (setq M (getint "Enter starting screen row: "))
    (setq N (getint "Enter starting screen column: "))
    (while (<= M 400)
      (setq BC (+ (* M GAP) BCORNER))
        (while (<= N 400)
           (setq AC (+ (* N GAP) ACORNER))
            (setq AZ 0.0)
            (setq BZ 0.0)
            (setq COUNT 0)
        (setq SIZE 0.0)
            (while
                (and (< SIZE 4.0)
                    (< COUNT 1000))
                (setq Q (* 2 AZ BZ))
                (setq AZ (+ AC (- (* AZ AZ) (* BZ BZ))))
                (setq BZ (+ Q BC))
                (setq SIZE (+ (* AZ AZ) (* BZ BZ)))
                (setq COUNT (+ 1 COUNT))                     
            )
            (command "color" (fix(- (* 2.458 (expt COUNT 0.67)) 1.458)))
            (command "point" (list N M))
            (setq N (+ 1 N))
        )
        (setq N 1)
        (setq M (+ 1 M))
    )
)

