/* CHLYR.C  (c)1994, Anthony Hotchkiss */

#include <stdio.h>
#include <string.h>
#include "adslib.h"

/* Layer changing example */

int chlyr2 (void)
{
   struct resbuf *elist, *item;
   ads_name ename;
   ads_point pt;
   char lname[133];

   if (ads_entsel("\nSelect entity: ", ename, pt) != RTNORM)
      {
         ads_alert("No entity selected...");
         return RTERROR;
      }      /* entity selection with safeguard in case no entity is selected */
   ads_redraw(ename, 3);   /* redraw the entity with highlight mode */
   ads_getstring(0, "\nNew layer name: ", lname);  
                 /* the ads_getstring function has a flag 0 to indicate no
                      spaces are allowed in the string, it stores the resulting
                      string in the variable lname, which can have a maximum
                       number of characters of 132 plus the null character.
                       ads_getstring returns RTNORM, RTCAN (for ctrl-c),
                        or RTERROR */
   elist = ads_entget(ename);
   for (item=elist; item; item = item->rbnext)
      if (item->restype == 8)     /* check for the restype 8 (for layer name) */
         {
            if (strlen(item->resval.rstring) < strlen(lname))  /* string length check */
               item->resval.rstring = realloc(
                  item->resval.rstring, strlen(lname) +1);  /* allocate memory for the new string */
            strcpy(item->resval.rstring,lname);     /* copy the new layer name */
            ads_entmod(elist);  /* this function modifies the AutoCAD entity */
         }
   if (elist != NULL) 
      ads_relrb(elist);   /* release the entity dxf list memory if necessary */
   ads_retvoid();
} /* chlyr2 */
