#Include "Box.ch"

EXTERNAL BLIMGRSTS, SWPRUNCMD, BLIVERNUM
EXTERNAL MethodName


STATIC cStatic



/*
  Function Ŀ
          Name: MAIN()                                                     
   Description: What's the fastest we can bang together a denmo program    
        Author: Darren Lancaster                                           
  Date created: 29-06-94              Date updated: 29-06-94              
  Time created: 11:22:26am            Time updated: 11:22:26am            
     Copyright: L&W Computer Services Ltd                                  
 Ĵ
     Arguments: None                                                       
  Return Value: MAIN()                                                     
      See Also:                                                            
 
*/

MEMVAR cPublic, cPrivate
FUNCTION MAIN()
   LOCAL cLocal
   LOCAL cScreen := SAVESCREEN(0,0, MAXROW(), MAXCOL())
   PUBLIC cPublic
   PRIVATE cPrivate


   cPublic := "Alt-P toggle publics on or off"

   cStatic := "Alt-S will toggle statics on or off"

   cPrivate := "Alt-V will toggle Private variables on or off"

   cLocal := "Alt-L will toggle Local variable on or off"

   Screen()                                                                    // call a function

   Mainmenu()                                                                  // Play with an object

   RestScreen(0,0, MAXROW(), MAXCOL(), cScreen)

RETURN(NIL)




/*Ŀ
   FunctionMainMenu() --> NIL                                              
    PurposeMain Menu                                                       
  Date-Time29-06-94 12:06pm                                                
  CopyrightL&W Computer Services Ltd.                                      
     AuthorIan Day                                                         
  */
STATIC FUNCTION MainMenu

   LOCAL oWindow, nChoice, lFinish := .F., cSetColor := SetColor("GR+/B,B/W,N,,W+/B"),;
         oTitle

   LOCAL aMenu := {"Look at DBFs",;
                   "Crash the Program",;
                   "Show a Tbrowse",;
                   "Disable an ALTD()",;
                   "Quit"}
   LOCAL aBlocks := { {|| BrowData() },;
                     {|| Crash() },;
                     {|| browser(6, 10, 21, 50) },;
                     {|| DisAltd() },;
                     {|| lFinish := .T. }}

   DispBegin()
   oTitle := Title():New("Main Menu")
   oWindow := Window():New(8, 30, 5, 20, "Main Menu"):Display()

   SetColor("W+/B,B/W,N,,W+/B")
   @ oWindow:nTop + 3, oWindow:nLeft + 2 TO oWindow:nBottom - 1, oWindow:nLeft + 2


   DispEnd()

   DO WHILE !lFinish
      nChoice := aChoice(oWindow:nTop + 3, oWindow:nLeft + 3, oWindow:nBottom - 1, oWindow:nRight - 1, aMenu)

      IF nChoice > 0
         Eval(aBlocks[nChoice])
      ELSE
         EXIT
      ENDIF
   ENDDO

   DispBegin()
   oWindow:CLASS:CloseAll()
   oTitle:Close()
   SetColor(cSetColor)
   DispEnd()

RETURN (NIL)



/*Ŀ
   FunctionSysTitle() --> <cSysTitle>                                      
    PurposeReturn system title                                             
  Date-Time29-06-94 11:38am                                                
  CopyrightL&W Computer Services Ltd.                                      
     AuthorIan Day                                                         
  */
FUNCTION SysTitle
RETURN ("MrDebug Demo Program")



/*Ŀ
   FunctionScreen() --> NIL                                                
    PurposeMain screen                                                     
  Date-Time08-13-93      07:26:33pm                                        
  CopyrightL&W Computer Services Ltd.                                      
     AuthorIan Day                                                         
  */
STATIC FUNCTION Screen

   DispBegin()
   SetColor("B/BG")
   @ 0, 0, 3, MaxCol() BOX B_SINGLE + " "
   @ MaxRow(), 0 CLEAR TO MaxRow(), MaxCol()

   @ 1, 2 SAY Date()
   @ 1, MaxCol() - 9 SAY Time()
   @ 1, MaxCol() / 2 - Len(SysTitle()) / 2 SAY SysTitle()

   @ 4, 0, MaxRow() - 1, MaxCol() BOX Replicate("", 9)
   DispEnd()


RETURN (NIL)



/*
  Function Ŀ
          Name: DisAltd()                                                  
   Description: I left an ALTD() in that loop - ARGHHHHHHH!                
        Author: Darren Lancaster                                           
  Date created: 30-06-94              Date updated: 30-06-94              
  Time created: 00:10:50am            Time updated: 00:10:50am            
     Copyright: L&W Computer Services Ltd                                  
 Ĵ
     Arguments: None                                                       
  Return Value: FUNCTION DisAltd()                                         
      See Also:                                                            
 
*/
STATIC FUNCTION DisAltd()
   LOCAL nI := 0

   FOR nI := 1 TO 10
      // How many time have you forgotten about an ALTD() function
      // within your code
      // MrDebug allows you to Disable and ALTD() function

      ALTD()     // move the cursor to this line in the source code
                 // and press Shift-Alt-D. When you next run the
                 // program you won't have to keep pressing
                 // F5 until you are out of the loop.

   NEXT

RETURN(NIL)
