/*
 Ŀ
  Module....: INFO.prg                                                    
  Author....: Brian Marasca                                               
  Copyright.: Princeton MICRAN Associates, Inc.                           
  Date......: March 1994                                                  
 Ĵ
  Notes.....: Demo Information Screen.                                    
 
*/

/*****************************************************************************
   Include file headers.
*****************************************************************************/

#include "objectdb.ch"
#include "odbdemo.ch"

/*****************************************************************************
   Manifest constants.
*****************************************************************************/

#define INFO_SL " Use  and PgUp/PgDn to scroll, press ESC to exit. "

/*****************************************************************************
   FUNCTION info()
*****************************************************************************/

FUNCTION info( cScreen )
  STATIC oInfo
  LOCAL cScr
  LOCAL cClr
  LOCAL cSL 

  DEFAULT cScreen TO procName( 3 )

  IF oInfo == NIL
     CREATE CONTEXT oInfo FOR info
  ENDIF

  IF oInfo:seek( { cScreen } )
     cScr := saveScreen( 4, 7, 18, 73 )
     cClr := setColor( "g+/b" )
     cSL  := statusLine( INFO_SL )

     dispBegin()
     scroll( 4, 7, 17, 72 )
     dispBox( 4, 7, 17, 72, B_BLOCK_THIN )
     shadow( 4, 7, 17, 72 )
     dispEnd()

     setColor( "bg+/b" )
     memoEdit( oInfo..text, 5, 9, 16, 70, .F. )

     restScreen( maxRow(), 0, maxRow(), maxCol(), cSL )
     restScreen( 4, 7, 18, 73, cScr )
     setColor( cClr )
  ENDIF

  RETURN nil


