/*
 Ŀ
  Module....: MSGBOX.prg                                                  
  Author....: Brian Marasca                                               
  Copyright.: Princeton MICRAN Associates, Inc.                           
  Date......: February 1994                                               
 Ĵ
  Notes.....: General purpose message box function.                       
 
*/

/***************************************************************************
   Include file headers.
***************************************************************************/

#include "objectdb.ch"

/***************************************************************************
   FUNCTION: msgBox
***************************************************************************/

FUNCTION msgBox( cCap, cMsg, aOpts, cCapClr, cWinClr, cMenuClr )
  LOCAL t, l, b, r, w, h
  LOCAL nCapLen := len( cCap )
  LOCAL nMsgLen := 0
  LOCAL nPL := 0
  LOCAL cClr := setColor()
  LOCAL aClr
  LOCAL nChoice
  LOCAL aMsg
  LOCAL cScr

  DEFAULT cCapClr  TO "gr+/b"
  DEFAULT cWinClr  TO "n/w"
  DEFAULT cMenuClr TO "n/bg, n/bg*"

  aMsg := parseMsg( cMsg )
  aeval( aMsg, { |e| nMsgLen := max( nMsgLen, len( e ) ) } )

  w := max( nCapLen, nMsgLen ) + 4
  l := 40 - int( w / 2 )
  r := l + w - 1
  h := 5 + len( aMsg )
  t := 10 - int( h / 2 )
  b := t + h - 1

  cScr := saveScreen( t, l, b+1, r+1 )
  setColor( cWinClr )
  scroll( t, l, b, r )

  @ t, l SAY padc( cCap, w ) COLOR cCapClr

  aeval( aMsg,  { |e,x| devPos( t+1+x, l ), devOut( padc( e, w ), cWinClr ) } )
  aeval( aOpts, { |e| nPL += len( e ) } )
  nPL += len( aOpts ) - 1
  nPL := 40 - int( nPL / 2 )

  shadow( t, l, b, r )
  setColor( cMenuClr )

  aeval( aOpts, { |e| __atPrompt( b-1, nPL, e ), nPL += len( e ) + 1 } )

  MENU TO nChoice

  restScreen( t, l, b+1, r+1, cScr )
  setColor( cClr )

  RETURN nChoice


/***************************************************************************
   FUNCTION: parseMsg()
***************************************************************************/

STATIC FUNCTION parseMsg( cMsg )
  LOCAL aRet := {}

  cMsg := alltrim( cMsg )

  WHILE len( cMsg ) > 0
     aadd( aRet, nextLine( @cMsg, 50 ) )
  END

  RETURN aRet


/***************************************************************************
   FUNCTION: nextLine()

   cText must be passed by reference.
***************************************************************************/

STATIC FUNCTION nextLine( cText, nWidth )
  LOCAL cBuff
  LOCAL n

  IF len( cText ) <= nWidth .AND. at( ";", cText ) ==  0
     cBuff := cText
     cText := ""
  ELSE
     cBuff := left( cText, nWidth )
     n := at ( ";", cBuff )
     IF n == 0
        n := rat( " ", cBuff )
     ENDIF
     IF n > 0
        cBuff := left( cText, n - 1 )
        cText := subs( cText, n + 1 )
     ENDIF
  ENDIF

  RETURN cBuff


