/*
 Ŀ
  Module....: ODBDEMO.prg                                                 
  Author....: Ken Trock                                                   
  Copyright.: Princeton MICRAN Associates, Inc.                           
  Date......: August 1993                                                 
 Ĵ
  Notes.....: Demo of objectDB features.                                  
 
*/

/***************************************************************************
   Include file headers.
***************************************************************************/

#include "objectdb.ch"
#include "inkey.ch"
#include "setcurs.ch"
#include "odbdemo.ch"
#include "getexit.ch"

/***************************************************************************
   FUNCTION main()
***************************************************************************/

FUNCTION main()
  RELEASE getList

  set( _SET_SCOREBOARD, FALSE )
  set( _SET_WRAP, TRUE )
  setColor( "w/n" )
  setCursor( SC_NONE )
  setBlink( FALSE )
  setCancel( FALSE )
  SET MESSAGE TO 23

  CLS

  /******
  * Alt-X simulates a system crash, for testing crash recovery.
  ******/

  setKey( K_ALT_X, { || __quit() } )

  /******
  * Fire up ObjectDB.
  ******/

  banner()
  waitMsg( TRUE )

  INITIALIZE OBJECTDB

  db():waitBlock( { |x| waitMsg( x ) } )
  waitMsg( FALSE )

  IF password()
     CONNECT DATABASE
     mainMenu()
     DISCONNECT DATABASE
  ENDIF

  setBlink( TRUE )
  setCursor( TRUE )
  setColor( "w/n" )

  CLS

  RETURN nil

/***************************************************************************
   FUNCTION mainMenu()
***************************************************************************/

FUNCTION mainMenu
  LOCAL cx, nChoice, lExit, cScr
  
  @06,25 CLEAR TO 14,55

  FOR cx := 1 TO 8
    @ cx + 5, 25 SAY ''
    @ cx + 5, 55 SAY ''
  NEXT

  @14,24 SAY repl( "", 33 )
  @24,00 SAY padc( "Copyright (c) 1993 by Princeton MICRAN Associates, Inc.", 80 ) COLOR "n/w"

  lExit := FALSE

  DO WHILE ! lExit
      setColor( "bg+/b, n/w" )

      @07,26 PROMPT padc( "Referential Integrity", 29 ) ;
         MESSAGE {||dispMsg("Demonstrates objectDB enforcement of referential and entity integrity.")}
      @08,26 PROMPT padc( "Transaction Tracking", 29 )  ;
         MESSAGE {|| dispMsg("Begin, commit, roll back, and do data entry.")}
      @09,26 PROMPT padc( "Multiple Contexts", 29 )     ;
         MESSAGE {|| dispMsg("Demonstrates objectDB support for multiple virtual contexts.")}
      @10,26 PROMPT padc( "View Data Dictionary", 29 )  ;
         MESSAGE {|| dispMsg("Display active data dictionary with declarative referential integrity.")}
      @11,26 PROMPT padc( "Table Maintenance", 29 )  ;
         MESSAGE {|| dispMsg("Edit Parts table, Salesmen table, and Store table.")}
      @12,26 PROMPT padc( "Exit", 29 )  ;
         MESSAGE {|| dispMsg("Exit ObjectDB demo.")}

      MENU TO nChoice

      cScr := saveScreen( 0, 0, 24, 79 )

      DO CASE 
      CASE nChoice == 1
         ri()
      CASE nChoice == 2
         transact()
      CASE nChoice == 3
         mvc()
      CASE nChoice == 4
         viewDict()
      CASE nChoice == 5
         nChoice := tableMenu()
         DO CASE
         CASE nChoice == 1
            salesmenTable()
         CASE nChoice == 2
            partsTable()
         ENDCASE
      CASE nChoice == 6
         IF askUser( "Confirm", "Exit ObjectDB Demo Application?" )
            lExit := TRUE
         ENDIF
      ENDCASE
      restScreen( 0, 0, 24, 79, cScr )
  END

  RETURN nil

/***************************************************************************
   FUNCTION banner()
***************************************************************************/

FUNCTION banner
  LOCAL cx
 
  setColor( "bg+/b" )
  @00,00 CLEAR TO 5, 79

  setColor( "w+/b" )
  @00,00 SAY repl( '', 80 )

  FOR cx := 1 TO 4
     @ cx, 00 SAY repl( '', 2 )
     @ cx, 78 SAY repl( '', 2 )
  NEXT

  @02,02 SAY padc( "ObjectDB Demonstration Program", 76 )
  @05,00 SAY repl( '', 80 )

  RETURN nil

/***************************************************************************
   FUNCTION password()
***************************************************************************/

FUNCTION password
  LOCAL getList := {}
  LOCAL cScr
  LOCAL cColor
  LOCAL cUserID   := space( 15 )
  LOCAL cPassword := space( 10 )
  LOCAL lRetVal
  LOCAL nCtr  := 1
  LOCAL lExit := FALSE
  LOCAL nKey
  LOCAL cx

  cScr := saveScreen( 9, 25, 15, 55 )
  cColor := setColor( "w+/b*" )

  dispBox(  9, 25, 15, 55,, "w+/b*" )
  @ 10, 26 CLEAR TO 14, 54
  @ 10, 26 SAY padc( "Log on to ObjectDB", 29 ) COLOR "gr+/b"
  setColor( "w+/b*" )

  @ 12, 27 SAY "User ID  :" GET cUserID   COLOR "w+/b*, n/w" PICTURE "@!" 
  @ 13, 27 SAY "Password :" GET cPassword COLOR "w+/b*, n/w" PICTURE "@!" 

  /****
  * If /NOAUTOLOG was specified, let the user log on manually.  Otherwise,
  * put in a custom reader to do the log on ...
  ****/

  IF ! odIsCmdArg( "/NOAUTOLOG" )
     aeval( getList, { |o| o:reader := { |o| demoReader( o ) } } )
  ENDIF

  WHILE ! lExit
     READ
     DO CASE
     CASE lastKey() == K_ESC
        lRetVal := FALSE
        lExit := TRUE
     CASE db():logOn( cUserID, cPassword )
        lRetVal := TRUE
        lExit := TRUE
     OTHERWISE
        tone( 400, 1 )
        IF ( nCtr++ ) == 3
           lRetVal := FALSE
           lExit := TRUE
        ENDIF
     ENDCASE
  END

  setColor( cColor )
  restScreen( 9, 25, 15, 55, cScr )

  RETURN lRetVal

/***************************************************************************
   FUNCTION viewDict
***************************************************************************/

STATIC FUNCTION viewDict
   LOCAL cScr, cColor, nCurs

   IF file( "datadict.prg" )
      cScr := saveScreen( 0, 0, 24, 79 )
      nCurs := setCursor( SC_NORMAL )
      
      cColor := setColor( "w/n" )
      @ 24, 0 CLEAR TO 24, 79
      @ 24, 0 SAY "File: demodict.prg"
      cColor := setColor( "w+/b" )
      
      memoEdit( memoRead( "datadict.prg" ), 0, 0, 23, 79, .T., "demoUDF", 90 ) 
      
      restScreen( 0, 0, 24, 79, cScr )
      setColor( cColor )
      setCursor( nCurs )
   ENDIF

   RETURN nil


FUNCTION demoUDF( nMode, nLine, nCol )
  LOCAL cScr

  setColor( "w/n" )
  setCursor( SC_NONE )

  @ 24, 50 SAY " Line: " + subStr( lTrim ( str( nLine, 3 ) ) + space( 3 ), 1, 3 )
  @ 24, 61 SAY " Col: " + subStr( lTrim ( str( nCol, 2 ) ) + space( 2 ), 1, 2 )
  @ 24, 73 SAY lTrim( left( time(), 5 ) )

  setCursor( SC_NORMAL )
  setColor( "w+/b" )

  RETURN 0


FUNCTION dispMsg( c )
  @23,0 SAY padr(c,80) COLOR "w+/n"
  RETURN ""

/***************************************************************************
   FUNCTION tableMenu
***************************************************************************/

FUNCTION tableMenu
  LOCAL cScr := saveScreen( 12, 42, 15, 59 )
  LOCAL cClr
  LOCAL nRet

  cClr := setColor( "w+/b*, n/w" )

  scroll( 12, 42, 15, 59 )
  dispBox( 12, 42, 15, 59 )

  @13,43 PROMPT " Salesmen Table "
  @14,43 PROMPT "   Part Table   "

  MENU TO nRet

  restScreen( 12, 42, 15, 59, cScr )
  setColor( cClr )

  RETURN nRet

/***************************************************************************
   FUNCTION demoReader()

   This is the custom GetReader for the LogOn screen ...
***************************************************************************/

FUNCTION demoReader( oGet )
  STATIC cStr := "DEMOUSER" + chr(13) + "DEMOPASS"
  LOCAL nKey

  oGet:exitState := GE_NOEXIT
  oGet:setFocus()

  WHILE oGet:exitState == GE_NOEXIT
     IF len( cStr ) > 0
        nKey := asc( left( cStr, 1 ) )
        getApplyKey( oGet, nKey )
        cStr := subs( cStr, 2 )
        inkey( 0.2 )
     ELSE
        oGet:exitState := GE_ENTER
     ENDIF
  END

  oGet:assign()
  oGet:killFocus()

  RETURN nil

  
