/*
 Ŀ
  Module....: TRANSACT.prg                                                
  Author....: Ken Trock                                                   
  Copyright.: Princeton MICRAN Associates, Inc.                           
  Date......: August 1993                                                 
 Ĵ
  Notes.....: Transaction tracking display                                
 
*/

/***************************************************************************
   Include file headers.
***************************************************************************/

#include "objectdb.ch"
#include "inkey.ch"
#include "setcurs.ch"
#include "memoedit.ch"
#include "odbdemo.ch"
#include "mb.ch"

/***************************************************************************
  Manifest constants.
***************************************************************************/

#define STATUS_LINE   " F2 : Source  Alt-B : Begin  Alt-C : Commit  Alt-R : Rollback  ESC : Exit "

/***************************************************************************
   FUNCTION trans()
***************************************************************************/

FUNCTION transact()
  LOCAL cColor := setColor( "w+/b*" )
  LOCAL getList := {}
  LOCAL oCust, oInv, oLine, oParts, oSM
  LOCAL oTBcust, oTBinv, oTBline
  LOCAL aCon, aTB
  LOCAL cStatLine

  /*****
  * Create the view.
  *****/

  CREATE CONTEXT oCust  FOR TABLE Customer
  CREATE CONTEXT oInv   FOR TABLE Invoice   CHILD OF oCust
  CREATE CONTEXT oLine  FOR TABLE Lineitem  CHILD OF oInv
  CREATE CONTEXT oParts FOR TABLE Parts     CHILD OF oLine ON part_no
  CREATE CONTEXT oSM    FOR TABLE Salesmen  CHILD OF oInv  ON sm_code

  /*****
  * Configure browses
  *****/

  oTBcust := oCust:browser( { 1, 2, 3 }, 3, 1, 12, 39 ) 

  oTBinv  := oInv:browser( { 1, 2, 3 }, 3, 41, 12, 78 )
  oTBinv:addColumn( TBcolumnNew( "Salesman", { || oSM..Lname } ) )

  oTBline := oLine:browser( { "cust_id", "line_no" }, 16, 1, 22, 78 )
  oTBline:addColumn( TBcolumnNew( "Part Desc", { || oParts..Desc } ) )

  /*****
  * Prepare the browse
  *****/

  aCon := { oCust, oInv, oLine }
  aTB  := { oTBcust, oTBinv, oTBline }

  aeval( aTB, { |o| o:colorSpec := BR_COLORS, o:headSep := SING_HEADSEP } )

  CLS

  topLine( "T r a n s a c t i o n    T r a c k i n g " )
  cStatLine := statusLine( STATUS_LINE )

  @ 1, 40 TO 13, 40  
  @ 13, 0 TO 13, 79  
  @ 13, 40 SAY ""

  MULTIBROWSE KEY K_DEL    CALLS delFunc
  MULTIBROWSE KEY K_INS    CALLS insFunc
  MULTIBROWSE KEY K_ENTER  CALLS editFunc
  MULTIBROWSE KEY K_ALT_B  CALLS beginTrans
  MULTIBROWSE KEY K_ALT_R  CALLS rollBack
  MULTIBROWSE KEY K_ALT_C  CALLS commit
  MULTIBROWSE KEY K_F2     CALLS readSource

  MULTIBROWSE aTB WITH CONTEXTS IN aCon  ;
    CAPTION COLOR "w+/r, w/b"            ;
    EACH ITERATION testTrans

  restScreen( 24, 0, 24, 79, cStatLine )
  setColor( cColor )

  /****
  * Can't forget these.
  ****/

  DESTROY CONTEXT oCust 
  DESTROY CONTEXT oInv  
  DESTROY CONTEXT oLine 
  DESTROY CONTEXT oParts
  DESTROY CONTEXT oSM

  RETURN nil

/***************************************************************************
   FUNCTION beginTrans
***************************************************************************/

STATIC FUNCTION beginTrans
  db():begin()

  RETURN TRUE

/***************************************************************************
   FUNCTION rollBack
***************************************************************************/

STATIC FUNCTION rollBack
  IF db():tx()      
     db():rollback()
     tellUser( "ObjectDB", "The transaction has been rolled back." )
  ENDIF

  RETURN FALSE

/***************************************************************************
   FUNCTION commit
***************************************************************************/

STATIC FUNCTION commit
  IF db():tx()      
     db():commit()
     tellUser( "ObjectDB", "The transaction has been committed." )
  ENDIF

  RETURN TRUE

/***************************************************************************
   FUNCTION testTrans
***************************************************************************/

STATIC FUNCTION testTrans
  IF db():sysRollback
     tellUser( "System Rollback", "ObjectDB has rolled back the transaction"+; 
        " in response to a runtime error." )
     db():commit()
  ENDIF

  IF db():inProcess
     @ 0, 3 SAY " TRANSACTION "  COLOR "gr+/rb"
  ELSE
     @ 0, 3 SAY "             "  COLOR "b/w"
  ENDIF

  RETURN nil

