'  SETS BAUD RATE IN THE RS232 INTERFACE
'
'  BAUD RATE        BAUD RATE DIVISIOR
'   1200                96
'   2400                48
'   9600                12
'  14400                 8
'  19200                 6
'  38400                 3
'
     PORTSPEED! = INT(VAL(COMMAND$))
     SELECT CASE PORTSPEED!
     CASE 1200
        BAUDRATEDIVISOR = &H60
     CASE 2400
        BAUDRATEDIVISOR = &H30
     CASE 9600
        BAUDRATEDIVISOR = &HC
     CASE 14400
        BAUDRATEDIVISOR = &H8
     CASE 19200
        BAUDRATEDIVISOR = &H6
     CASE 38400
        BAUDRATEDIVISOR = &H3
     CASE ELSE
        PRINT "BAUD must be 1200, 2400, 9600, 14400, 19200, or 38400."
        END
     END SELECT
     PRINT "DLAB set to"; STR$(PORTSPEED!)
     ' 28800, 57600, 115200, 330400 (?)
     LSB = &H3F8 ' DLAB LOW
     MSB = &H3F9 ' DLAB HIGH
     LCR = &H3FB ' LINE CONTROL REGISTER

     LINESTATUS = INP(LCR) ' store line control status
     STORE.MSB = INP(MSB) ' store interrupt register
     OUT MSB, 0 ' clear interrupt register
     OUT LCR, LINESTATUS OR 128 ' set dlab bit
     OUT LSB, BAUDRATEDIVISOR ' set divisor latch low byte
     OUT MSB, 0 ' set divisor latch high byte
     OUT LCR, LINESTATUS ' restore line control
     OUT MSB, STORE.MSB ' restore interrupt register
