#include<stdio.h>
#include<fcntl.h>
#include<bios.h>

struct header_s
	{
	unsigned char mfgr;
	unsigned char version;
	unsigned char encoding;
	unsigned char bppix;
	unsigned short xmin;
	unsigned short ymin;
	unsigned short xmax;
	unsigned short ymax;
	unsigned short hdpi;
	unsigned short vdpi;
	unsigned char cmap[48];
	unsigned char reserved;
	unsigned char nplanes;
	unsigned short bypl;
	unsigned short paltinf;
	unsigned short hscrnsz;
	unsigned short vscrnsz;
	unsigned char filler[54];
	};

struct header_s header;

unsigned char buf[17280], bybuf[216], fbuf[8192];

void quit()
	{
	exit(99);
	}

void prchar(int lptn, char c)
	{
	while(!(_bios_printer(_PRINTER_STATUS, lptn, 0)&0x80))
		if(kbhit())
			getchar(); /* Allow interrupt */
	_bios_printer(_PRINTER_WRITE, lptn, c);
	}

main(argc, argv)
	int argc;
	char **argv;
	{
	/* int rns is rough number of stripes. Any resemblence to   */
	/* Rosinante Navy Ship is entirely unintentional. (Tee-hee) */
	int ifd, vsiz, n, curbyt, lptn, fbufn, rns;
	int i, icnt, j, nbyts, totbpl, vdstate, hdstate, fbufindex, stripen;
	long totbyts;
	unsigned char c, nlo, nhi, imask, bitmask;
	if(argc!=3)
		{
		printf("\nUSAGE: bjfaxpcx <lpt #> <file>\n\n"
			"Prints a fax pcx file on Cannon Bubblejet printer at 360 x 360.\n");
		exit(1);
		}
	if(sscanf(argv[1], "%d", &lptn)!=1)
		{
		printf("Bad scan of LPT number.\n");
		exit(10);
		}
	lptn--;
	if((ifd=open(argv[2], O_RDONLY|O_BINARY))==-1)
		{
		printf("Couldn't open %s for read.\n", argv[2]);
		exit(2);
		}
	read(ifd, &header, 128);
	printf("Got header OK.\n");
	if(header.encoding!=1)
		{
		printf("Bad type of encoding declared in header.\n");
		exit();
		}
	if(header.nplanes!=1)
		{
		printf("Only one plane allowed.\n");
		exit();
		}
	if(header.bppix!=1)
		{
		printf("Grayscale.\n");
		exit();
		}
	if((header.xmax-header.xmin)!=1727)
		{
		printf("Wrong width.\n");
		exit();	
		}
	printf("All checks OK.\n");
	vsiz=header.ymax-header.ymin+1;
	totbpl=header.bypl;
	totbyts=totbpl*(long)vsiz;
	curbyt=n=vdstate=hdstate=stripen=0;
	bitmask=0x80;
	for(i=0;i<17280;++i)
		buf[i]=0;
	fbufindex=fbufn=0;
	rns=vsiz*5/3/48; /* Allow for dup'ing 2 out of 3 to match res. */
	for(;;)          /* Make int as big as poss. before divides. */
		{
		if(fbufindex>=fbufn)
			{
			if((fbufn=read(ifd, fbuf, 8192))<=0)
				{
				printf("Terminated by End of File rather than full count.\n");
				printf("We were expecting %ld more horizontal fat bytes of image.\n", totbyts);
				break;
				}
			fbufindex=0;
			}
		c=fbuf[fbufindex++];
		if((c & (unsigned char) 0xc0)== (unsigned char) 0xc0)
			{
			i = c & (unsigned char) 0x3f;
			if(fbufindex>=fbufn)
				{
				if((fbufn=read(ifd, fbuf, 8192))<=0)
					{
					printf("Terminated by End of File rather than full count.\n");
					printf("We were expecting %ld more horizontal fat bytes of image.\n", totbyts);
					break;
					}
				fbufindex=0;
				}
			c=fbuf[fbufindex++];
			while(i--)
				bybuf[n++]=c;
			}
		else
			bybuf[n++]=c;
		if(n>=totbpl)
			{
			if(n!=totbpl)
				{
				printf("Mismatch.\n");
				exit();
				}
			if(vdstate)
				{
				for(i=0,j=0,hdstate=0,icnt=216;icnt;i++,icnt--)
					for(imask=0x80;imask;imask>>=1)
						{
						if(bybuf[i]&imask)
							;
						else
							buf[j+curbyt]|=bitmask;
						j+=6;
						if(hdstate)
							{
							if(bybuf[i]&imask)
								;
							else
								buf[j+curbyt]|=bitmask;
							j+=6;
							}
						if(hdstate++==2)
							hdstate=0;
						}
				if((!(bitmask>>=1))||(totbyts==n))
					{
					bitmask=0x80;
					if((++curbyt==6)||(totbyts==n))
						{
						printf("Sending stripe %d of about %d.\n", ++stripen, rns);
						nbyts=17280+1;
						nlo=nbyts%256;
						nhi=nbyts/256;
						prchar(lptn, '\033');
						prchar(lptn, '[');
						prchar(lptn, 'g');
						prchar(lptn, nlo);
						prchar(lptn, nhi);
						prchar(lptn, 16);
						for(i=0,icnt=17280;icnt;i++,icnt--)
							prchar(lptn, buf[i]);
						prchar(lptn, '\r');
						prchar(lptn, '\034');
						prchar(lptn, 'C');
						prchar(lptn, 'J');
						prchar(lptn, 0);
						prchar(lptn, 24);
						curbyt=0;
						for(i=0,icnt=17280;icnt;++i,--icnt)
							buf[i]=0;
						}
					}
				}
			if(vdstate++==2)
				vdstate=0;
			for(i=0,j=0,hdstate=0,icnt=216;icnt;i++,icnt--)
				for(imask=0x80;imask;imask>>=1)
					{
					if(bybuf[i]&imask)
						;
					else
						buf[j+curbyt]|=bitmask;
					j+=6;
					if(hdstate)
						{
						if(bybuf[i]&imask)
							;
						else
							buf[j+curbyt]|=bitmask;
						j+=6;
						}
					if(hdstate++==2)
						hdstate=0;
					}
			if((!(bitmask>>=1))||(totbyts==n))
				{
				bitmask=0x80;
				if((++curbyt==6)||(totbyts==n))
					{
					printf("\rSending stripe %d of about %d.\n", ++stripen, rns);
					nbyts=17280+1;
					nlo=nbyts%256;
					nhi=nbyts/256;
					nbyts=17280+1;
					nlo=nbyts%256;
					nhi=nbyts/256;
					prchar(lptn, '\033');
					prchar(lptn, '[');
					prchar(lptn, 'g');
					prchar(lptn, nlo);
					prchar(lptn, nhi);
					prchar(lptn, 16);
					for(i=0,icnt=17280;icnt;i++,icnt--)
						prchar(lptn, buf[i]);
					prchar(lptn, '\r');
					prchar(lptn, '\034');
					prchar(lptn, 'C');
					prchar(lptn, 'J');
					prchar(lptn, 0);
					prchar(lptn, 24);
					curbyt=0;
					for(i=0,icnt=17280;icnt;++i,icnt--)
						buf[i]=0;
					}
				}
			totbyts-=n;
			if(totbyts<=0)
				{
				if(curbyt&&(bitmask!=0x80))
					{
					printf("Sending flush stripe.\n");
					nbyts=17280+1;
					nlo=nbyts%256;
					nhi=nbyts/256;
					nbyts=17280+1;
					nlo=nbyts%256;
					nhi=nbyts/256;
					prchar(lptn, '\033');
					prchar(lptn, '[');
					prchar(lptn, 'g');
					prchar(lptn, nlo);
					prchar(lptn, nhi);
					prchar(lptn, 16);
					for(i=0,icnt=17280;icnt;i++,icnt--)
						prchar(lptn, buf[i]);
					prchar(lptn, '\r');
					prchar(lptn, '\034');
					prchar(lptn, 'C');
					prchar(lptn, 'J');
					prchar(lptn, 0);
					prchar(lptn, 24);
					curbyt=0;
					for(i=0,icnt=17280;icnt;++i,icnt--)
						buf[i]=0;
					}
				close(ifd);
				prchar(lptn, 0x0c);
				printf("\nFinished correctly.\n");
				exit(0);
				}
			n=0;
			}
		}
	close(ifd);
	prchar(lptn, 0x0c);
	exit(40);
	}
